<?xml version="1.0" encoding="UTF-8" ?>
<!--
****************
(C) 2005, 1060 Research Limited. All rights reserved.
Licensed under the 1060 Public License v1.0 - http://www.1060research.com/license
1060 is a registered trademark of 1060 Research Ltd.
**********
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="html"/>

	<xsl:param name="param"/>
	
    <xsl:template match="/">

<html xmlns:xrl="http://1060.org/xrl">
	<header>
		<title>1060 Forum Installer</title>
		<link type="text/css" rel="stylesheet" href="/xlib/styles/css_1060_lnf.css" xrl:resolve="href"/>
	</header>
	<body style="padding: 3px;">
		<div class="outer2">
		<table width="100%" class="roundedbox">
		<tr>
			<td colspan="2" style="padding-bottom: 5px;">
			<!--<img src="xrl:img_forum" xrl:resolve="src" valign="middle"/>-->
			<div style="font-size: 50px;">
			1060 Forum Lite <span style="font-size: 25px; color: #807bff;">Installer</span>
			</div>
			
			</td>
		</tr>
		</table>
		<h3>Database Installation</h3>
		<form action="" method="post" class="roundedbox">
			<table cellpadding="1" cellspacing="0" class="title-table">
				<tr>
					<td align="right">
					Database Location 
					</td>
					<td>
						<input name="hostname" style="width:300px;">
							<xsl:attribute name="value"><xsl:value-of select="/nvp/hostname"/></xsl:attribute>
						</input>
					</td>
					<td>
						<div class="tiny">This is the location where the forum database will be stored. It must be read/write accessible by the NetKernel process and
						should be an absolute filename (ie full path).<br/>For example, on Windows <b>C:\some\dir\forum-lite-db</b> or on Unix <b>/some/dir/forum-lite-db</b></div>
					</td>
				</tr>
				<tr>
					<td align="right">
						Forum Administrator Password
					</td>
					<td>
						<input  type="password" name="superpwd" style="width:300px;">
							<xsl:attribute name="value"><xsl:value-of select="/nvp/superpwd"/></xsl:attribute>
						</input>
					</td>
					<td>
						<div class="tiny">This is the password that will be given to user 'super' - the main administrator</div>
					</td>
				</tr>
				<tr>
					<td align="right">
						<input  type="submit" value="install forum"/>
					</td>
				</tr>
			</table>
			
		</form>
		</div>
		<div class="outer3" align="left">
				<table><tr>
				<td width="100%" style="font-size: 70%; text-align: left;">
					(C) 2005-2006, 1060 Research Limited<br/>
					1060 Registered Trademark and NetKernel Trademark of 1060 Research Limited
				</td>
				</tr></table>
			</div>
	</body>
	
</html>

    </xsl:template>

</xsl:stylesheet> 
