/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.processing.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.milvus.MilvusComponent;

/**
 * Perform operations on the Milvus Vector Database.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface MilvusComponentBuilderFactory {

    /**
     * Milvus (camel-milvus)
     * Perform operations on the Milvus Vector Database.
     * 
     * Category: database,ai
     * Since: 4.5
     * Maven coordinates: org.apache.camel:camel-milvus
     * 
     * @return the dsl builder
     */
    static MilvusComponentBuilder milvus() {
        return new MilvusComponentBuilderImpl();
    }

    /**
     * Builder for the Milvus component.
     */
    interface MilvusComponentBuilder extends ComponentBuilder<MilvusComponent> {
    
        /**
         * The configuration;.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.milvus.MilvusConfiguration&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default MilvusComponentBuilder configuration(org.apache.camel.component.milvus.MilvusConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
    
        
        /**
         * The host to connect to.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: localhost
         * Group: producer
         * 
         * @param host the value to set
         * @return the dsl builder
         */
        default MilvusComponentBuilder host(java.lang.String host) {
            doSetProperty("host", host);
            return this;
        }
    
        
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default MilvusComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    
        
        /**
         * The port to connect to.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 19530
         * Group: producer
         * 
         * @param port the value to set
         * @return the dsl builder
         */
        default MilvusComponentBuilder port(int port) {
            doSetProperty("port", port);
            return this;
        }
    
        /**
         * Sets a default timeout for all requests.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default MilvusComponentBuilder timeout(long timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
    
        /**
         * Sets the API key to use for authentication.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param token the value to set
         * @return the dsl builder
         */
        default MilvusComponentBuilder token(java.lang.String token) {
            doSetProperty("token", token);
            return this;
        }
    
        
        /**
         * Whether autowiring is enabled. This is used for automatic autowiring
         * options (the option must be marked as autowired) by looking up in the
         * registry to find if there is a single instance of matching type,
         * which then gets configured on the component. This can be used for
         * automatic configuring JDBC data sources, JMS connection factories,
         * AWS Clients, etc.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param autowiredEnabled the value to set
         * @return the dsl builder
         */
        default MilvusComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
    }

    class MilvusComponentBuilderImpl
            extends AbstractComponentBuilder<MilvusComponent>
            implements MilvusComponentBuilder {
        @Override
        protected MilvusComponent buildConcreteComponent() {
            return new MilvusComponent();
        }
        private org.apache.camel.component.milvus.MilvusConfiguration getOrCreateConfiguration(MilvusComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new org.apache.camel.component.milvus.MilvusConfiguration());
            }
            return component.getConfiguration();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "configuration": ((MilvusComponent) component).setConfiguration((org.apache.camel.component.milvus.MilvusConfiguration) value); return true;
            case "host": getOrCreateConfiguration((MilvusComponent) component).setHost((java.lang.String) value); return true;
            case "lazyStartProducer": ((MilvusComponent) component).setLazyStartProducer((boolean) value); return true;
            case "port": getOrCreateConfiguration((MilvusComponent) component).setPort((int) value); return true;
            case "timeout": getOrCreateConfiguration((MilvusComponent) component).setTimeout((long) value); return true;
            case "token": getOrCreateConfiguration((MilvusComponent) component).setToken((java.lang.String) value); return true;
            case "autowiredEnabled": ((MilvusComponent) component).setAutowiredEnabled((boolean) value); return true;
            default: return false;
            }
        }
    }
}