/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.caconfig.impl.metadata;

import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.sling.caconfig.impl.metadata.BundleConfigurationMapping;
import org.apache.sling.caconfig.impl.metadata.ConfigClassBundleTackerCustomizer;
import org.apache.sling.caconfig.impl.metadata.ConfigurationMapping;
import org.apache.sling.caconfig.spi.ConfigurationMetadataProvider;
import org.apache.sling.caconfig.spi.metadata.ConfigurationMetadata;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ConfigurationMetadataProvider.class})
public class AnnotationClassConfigurationMetadataProvider
implements ConfigurationMetadataProvider {
    private BundleTracker<BundleConfigurationMapping> bundleTracker;
    private ConcurrentSkipListMap<Bundle, BundleConfigurationMapping> bundleMappings = new ConcurrentSkipListMap();
    private static final Logger log = LoggerFactory.getLogger(AnnotationClassConfigurationMetadataProvider.class);

    @Activate
    private void activate(BundleContext bundleContext) {
        ConfigClassBundleTackerCustomizer bundlerTrackerCustomizer = new ConfigClassBundleTackerCustomizer(this);
        this.bundleTracker = new BundleTracker(bundleContext, 32, (BundleTrackerCustomizer)bundlerTrackerCustomizer);
        this.bundleTracker.open();
    }

    @Deactivate
    private void deactivate() {
        this.bundleTracker.close();
        this.bundleTracker = null;
    }

    @NotNull
    public SortedSet<String> getConfigurationNames() {
        TreeSet<String> allConfigNames = new TreeSet<String>();
        for (BundleConfigurationMapping bundleMapping : this.bundleMappings.values()) {
            allConfigNames.addAll(bundleMapping.getConfigurationNames());
        }
        return Collections.unmodifiableSortedSet(allConfigNames);
    }

    public ConfigurationMetadata getConfigurationMetadata(String configName) {
        ConfigurationMapping mapping = this.getConfigurationMapping(configName);
        if (mapping != null) {
            return mapping.getConfigMetadata();
        }
        return null;
    }

    ConfigurationMapping getConfigurationMapping(String configName) {
        ConfigurationMapping matchingConfigMapping = null;
        BundleConfigurationMapping matchingBundleMapping = null;
        for (BundleConfigurationMapping bundleMapping : this.bundleMappings.values()) {
            ConfigurationMapping configMapping = bundleMapping.getConfigurationMapping(configName);
            if (configMapping == null) continue;
            if (matchingConfigMapping == null) {
                matchingConfigMapping = configMapping;
                matchingBundleMapping = bundleMapping;
                continue;
            }
            log.warn("Configuration name conflict: Both configuration classes {} (Bundle {}) and {} (Bundle {}) define the configuration name '{}', ignoring the latter.", new Object[]{matchingConfigMapping.getConfigClass().getName(), matchingBundleMapping.getBundle().getSymbolicName(), configMapping.getConfigClass().getName(), bundleMapping.getBundle().getSymbolicName(), configName});
        }
        return matchingConfigMapping;
    }

    void addBundeMapping(BundleConfigurationMapping bundleMapping) {
        log.debug("Add bundle mapping: {}", (Object)bundleMapping);
        this.bundleMappings.put(bundleMapping.getBundle(), bundleMapping);
    }

    void removeBundleMapping(BundleConfigurationMapping bundleMapping) {
        log.debug("Remove bundle mapping: {}", (Object)bundleMapping);
        this.bundleMappings.remove(bundleMapping.getBundle());
    }
}

