/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.VerticalButton;

public class VerticalFolder
extends Canvas {
    private boolean isLeft;
    private List<VerticalButton> items = new ArrayList<VerticalButton>();
    private VerticalButton selectedItem;
    private boolean checkCommandEnablement;

    public VerticalFolder(Composite parent, int style) {
        super(parent, style);
        this.isLeft = (style & 0x4000) == 16384;
        GridLayout gl = new GridLayout(1, true);
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 2;
        this.setLayout((Layout)gl);
    }

    public boolean isLeft() {
        return this.isLeft;
    }

    public boolean isCheckCommandEnablement() {
        return this.checkCommandEnablement;
    }

    public void setCheckCommandEnablement(boolean checkCommandEnablement) {
        this.checkCommandEnablement = checkCommandEnablement;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size = super.computeSize(wHint, hHint, changed);
        return size;
    }

    public void addItem(VerticalButton item) {
        this.items.add(item);
    }

    public void setSelection(VerticalButton item) {
        this.selectedItem = item;
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.redraw();
            ++n2;
        }
        Event event = new Event();
        event.widget = this;
        this.notifyListeners(13, event);
    }

    public VerticalButton getSelection() {
        return this.selectedItem;
    }

    public VerticalButton[] getItems() {
        return this.items.toArray(new VerticalButton[0]);
    }

    public int getItemCount() {
        return this.items.size();
    }

    public void removeItem(VerticalButton item) {
        this.items.remove((Object)item);
    }

    public void removeAll() {
        UIUtils.disposeChildControls((Composite)this);
    }

    public void addVerticalGap() {
        UIUtils.createEmptyLabel((Composite)this, 1, 1).setLayoutData((Object)new GridData(1040));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.addListener(13, event -> listener.widgetSelected(new SelectionEvent(event)));
    }

    public void redraw() {
        super.redraw();
        for (VerticalButton b : this.items) {
            b.redraw();
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        for (VerticalButton item : this.items) {
            item.setFont(font);
            item.layout(true, true);
        }
    }
}

