/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.support;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.jsp.PageContext;
import jakarta.servlet.jsp.jstl.core.Config;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.springframework.lang.Nullable;
import org.springframework.web.servlet.support.RequestContext;

public class JspAwareRequestContext
extends RequestContext {
    private final PageContext pageContext;

    public JspAwareRequestContext(PageContext pageContext) {
        this(pageContext, null);
    }

    public JspAwareRequestContext(PageContext pageContext, @Nullable Map<String, Object> model) {
        super((HttpServletRequest)pageContext.getRequest(), (HttpServletResponse)pageContext.getResponse(), pageContext.getServletContext(), model);
        this.pageContext = pageContext;
    }

    protected final PageContext getPageContext() {
        return this.pageContext;
    }

    @Override
    protected Locale getFallbackLocale() {
        Locale locale;
        if (jstlPresent && (locale = JstlPageLocaleResolver.getJstlLocale(this.getPageContext())) != null) {
            return locale;
        }
        return this.getRequest().getLocale();
    }

    @Override
    @Nullable
    protected TimeZone getFallbackTimeZone() {
        TimeZone timeZone;
        if (jstlPresent && (timeZone = JstlPageLocaleResolver.getJstlTimeZone(this.getPageContext())) != null) {
            return timeZone;
        }
        return null;
    }

    private static class JstlPageLocaleResolver {
        private JstlPageLocaleResolver() {
        }

        @Nullable
        public static Locale getJstlLocale(PageContext pageContext) {
            Locale locale;
            Object localeObject = Config.find((PageContext)pageContext, (String)"jakarta.servlet.jsp.jstl.fmt.locale");
            return localeObject instanceof Locale ? (locale = (Locale)localeObject) : null;
        }

        @Nullable
        public static TimeZone getJstlTimeZone(PageContext pageContext) {
            TimeZone timeZone;
            Object timeZoneObject = Config.find((PageContext)pageContext, (String)"jakarta.servlet.jsp.jstl.fmt.timeZone");
            return timeZoneObject instanceof TimeZone ? (timeZone = (TimeZone)timeZoneObject) : null;
        }
    }
}

