/*
 * Camel EndpointConfiguration generated by camel-api-component-maven-plugin
 */
package org.apache.camel.component.fhir;

import javax.annotation.processing.Generated;

import org.apache.camel.spi.ApiMethod;
import org.apache.camel.spi.ApiParam;
import org.apache.camel.spi.ApiParams;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

/**
 * Camel endpoint configuration for {@link org.apache.camel.component.fhir.api.FhirUpdate}.
 */
@ApiParams(apiName = "update", 
           description = "API for the update operation, which performs a logical delete on a server resource",
           apiMethods = {@ApiMethod(methodName = "resource", description="Updates a IBaseResource on the server by id", signatures={"ca.uhn.fhir.rest.api.MethodOutcome resource(org.hl7.fhir.instance.model.api.IBaseResource resource, org.hl7.fhir.instance.model.api.IIdType id, ca.uhn.fhir.rest.api.PreferReturnEnum preferReturn, java.util.Map<org.apache.camel.component.fhir.api.ExtraParameters, Object> extraParameters)", "ca.uhn.fhir.rest.api.MethodOutcome resource(org.hl7.fhir.instance.model.api.IBaseResource resource, String stringId, ca.uhn.fhir.rest.api.PreferReturnEnum preferReturn, java.util.Map<org.apache.camel.component.fhir.api.ExtraParameters, Object> extraParameters)", "ca.uhn.fhir.rest.api.MethodOutcome resource(String resourceAsString, org.hl7.fhir.instance.model.api.IIdType id, ca.uhn.fhir.rest.api.PreferReturnEnum preferReturn, java.util.Map<org.apache.camel.component.fhir.api.ExtraParameters, Object> extraParameters)", "ca.uhn.fhir.rest.api.MethodOutcome resource(String resourceAsString, String stringId, ca.uhn.fhir.rest.api.PreferReturnEnum preferReturn, java.util.Map<org.apache.camel.component.fhir.api.ExtraParameters, Object> extraParameters)"}), @ApiMethod(methodName = "resourceBySearchUrl", description="Updates a IBaseResource on the server by search url", signatures={"ca.uhn.fhir.rest.api.MethodOutcome resourceBySearchUrl(org.hl7.fhir.instance.model.api.IBaseResource resource, String url, ca.uhn.fhir.rest.api.PreferReturnEnum preferReturn, java.util.Map<org.apache.camel.component.fhir.api.ExtraParameters, Object> extraParameters)", "ca.uhn.fhir.rest.api.MethodOutcome resourceBySearchUrl(String resourceAsString, String url, ca.uhn.fhir.rest.api.PreferReturnEnum preferReturn, java.util.Map<org.apache.camel.component.fhir.api.ExtraParameters, Object> extraParameters)"}), }, aliases = {})
@UriParams
@Configurer(extended = true)
@Generated("org.apache.camel.maven.ApiComponentGeneratorMojo")
public final class FhirUpdateEndpointConfiguration extends FhirConfiguration {
    @UriParam
    @ApiParam(optional = true, apiMethods = {@ApiMethod(methodName = "resource", description="See ExtraParameters for a full list of parameters that can be passed, may be NULL"), @ApiMethod(methodName = "resource", description="See ExtraParameters for a full list of parameters that can be passed, may be NULL"), @ApiMethod(methodName = "resource", description="See ExtraParameters for a full list of parameters that can be passed, may be NULL"), @ApiMethod(methodName = "resource", description="See ExtraParameters for a full list of parameters that can be passed, may be NULL"), @ApiMethod(methodName = "resourceBySearchUrl", description="See ExtraParameters for a full list of parameters that can be passed, may be NULL"), @ApiMethod(methodName = "resourceBySearchUrl", description="See ExtraParameters for a full list of parameters that can be passed, may be NULL")})
    private java.util.Map<org.apache.camel.component.fhir.api.ExtraParameters, Object> extraParameters;
    @UriParam
    @ApiParam(optional = true, apiMethods = {@ApiMethod(methodName = "resource", description="The IIdType referencing the resource")})
    private org.hl7.fhir.instance.model.api.IIdType id;
    @UriParam
    @ApiParam(optional = true, apiMethods = {@ApiMethod(methodName = "resource", description="Whether the server include or suppress the resource body as a part of the result"), @ApiMethod(methodName = "resource", description="Whether the server include or suppress the resource body as a part of the result"), @ApiMethod(methodName = "resource", description="Whether the server include or suppress the resource body as a part of the result"), @ApiMethod(methodName = "resource", description="Whether the server include or suppress the resource body as a part of the result"), @ApiMethod(methodName = "resourceBySearchUrl", description="Whether the server include or suppress the resource body as a part of the result"), @ApiMethod(methodName = "resourceBySearchUrl", description="Whether the server include or suppress the resource body as a part of the result")})
    private ca.uhn.fhir.rest.api.PreferReturnEnum preferReturn;
    @UriParam
    @ApiParam(optional = false, apiMethods = {@ApiMethod(methodName = "resource", description="The resource to update (e.g. Patient)"), @ApiMethod(methodName = "resourceBySearchUrl", description="The resource to update (e.g. Patient)")})
    private org.hl7.fhir.instance.model.api.IBaseResource resource;
    @UriParam
    @ApiParam(optional = false, apiMethods = {@ApiMethod(methodName = "resource", description="The resource body to update"), @ApiMethod(methodName = "resourceBySearchUrl", description="The resource body to update")})
    private String resourceAsString;
    @UriParam
    @ApiParam(optional = true, apiMethods = {@ApiMethod(methodName = "resource", description="The ID referencing the resource")})
    private String stringId;
    @UriParam
    @ApiParam(optional = false, apiMethods = {@ApiMethod(methodName = "resourceBySearchUrl", description="Specifies that the update should be performed as a conditional create against a given search URL")})
    private String url;

    public java.util.Map<org.apache.camel.component.fhir.api.ExtraParameters, Object> getExtraParameters() {
        return extraParameters;
    }

    public void setExtraParameters(java.util.Map<org.apache.camel.component.fhir.api.ExtraParameters, Object> extraParameters) {
        this.extraParameters = extraParameters;
    }

    public org.hl7.fhir.instance.model.api.IIdType getId() {
        return id;
    }

    public void setId(org.hl7.fhir.instance.model.api.IIdType id) {
        this.id = id;
    }

    public ca.uhn.fhir.rest.api.PreferReturnEnum getPreferReturn() {
        return preferReturn;
    }

    public void setPreferReturn(ca.uhn.fhir.rest.api.PreferReturnEnum preferReturn) {
        this.preferReturn = preferReturn;
    }

    public org.hl7.fhir.instance.model.api.IBaseResource getResource() {
        return resource;
    }

    public void setResource(org.hl7.fhir.instance.model.api.IBaseResource resource) {
        this.resource = resource;
    }

    public String getResourceAsString() {
        return resourceAsString;
    }

    public void setResourceAsString(String resourceAsString) {
        this.resourceAsString = resourceAsString;
    }

    public String getStringId() {
        return stringId;
    }

    public void setStringId(String stringId) {
        this.stringId = stringId;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}
