/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.processing.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.google.vertexai.GoogleVertexAIComponent;

/**
 * Interact with Google Cloud Vertex AI generative models.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface GoogleVertexaiComponentBuilderFactory {

    /**
     * Google Vertex AI (camel-google-vertexai)
     * Interact with Google Cloud Vertex AI generative models.
     * 
     * Category: ai,cloud
     * Since: 4.17
     * Maven coordinates: org.apache.camel:camel-google-vertexai
     * 
     * @return the dsl builder
     */
    static GoogleVertexaiComponentBuilder googleVertexai() {
        return new GoogleVertexaiComponentBuilderImpl();
    }

    /**
     * Builder for the Google Vertex AI component.
     */
    interface GoogleVertexaiComponentBuilder extends ComponentBuilder<GoogleVertexAIComponent> {
    
        /**
         * The Service account key that can be used as credentials for the
         * Vertex AI client. It can be loaded by default from classpath, but you
         * can prefix with classpath:, file:, or http: to load the resource from
         * different systems.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param serviceAccountKey the value to set
         * @return the dsl builder
         */
        default GoogleVertexaiComponentBuilder serviceAccountKey(java.lang.String serviceAccountKey) {
            doSetProperty("serviceAccountKey", serviceAccountKey);
            return this;
        }
    
        
        /**
         * Anthropic API version for Claude models. Required when publisher is
         * 'anthropic'.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: vertex-2023-10-16
         * Group: producer
         * 
         * @param anthropicVersion the value to set
         * @return the dsl builder
         */
        default GoogleVertexaiComponentBuilder anthropicVersion(java.lang.String anthropicVersion) {
            doSetProperty("anthropicVersion", anthropicVersion);
            return this;
        }
    
        
        /**
         * Number of candidate responses to generate.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: producer
         * 
         * @param candidateCount the value to set
         * @return the dsl builder
         */
        default GoogleVertexaiComponentBuilder candidateCount(java.lang.Integer candidateCount) {
            doSetProperty("candidateCount", candidateCount);
            return this;
        }
    
        /**
         * The component configuration.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.google.vertexai.GoogleVertexAIConfiguration&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default GoogleVertexaiComponentBuilder configuration(org.apache.camel.component.google.vertexai.GoogleVertexAIConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
    
        
        /**
         * Whether to use JSON request/response format.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param jsonMode the value to set
         * @return the dsl builder
         */
        default GoogleVertexaiComponentBuilder jsonMode(boolean jsonMode) {
            doSetProperty("jsonMode", jsonMode);
            return this;
        }
    
        
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default GoogleVertexaiComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    
        
        /**
         * Maximum number of output tokens.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 1024
         * Group: producer
         * 
         * @param maxOutputTokens the value to set
         * @return the dsl builder
         */
        default GoogleVertexaiComponentBuilder maxOutputTokens(java.lang.Integer maxOutputTokens) {
            doSetProperty("maxOutputTokens", maxOutputTokens);
            return this;
        }
    
        /**
         * Set the operation for the producer.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.google.vertexai.GoogleVertexAIOperations&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default GoogleVertexaiComponentBuilder operation(org.apache.camel.component.google.vertexai.GoogleVertexAIOperations operation) {
            doSetProperty("operation", operation);
            return this;
        }
    
        /**
         * Publisher name for partner models (e.g., anthropic, meta, mistralai).
         * Required for rawPredict operations.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param publisher the value to set
         * @return the dsl builder
         */
        default GoogleVertexaiComponentBuilder publisher(java.lang.String publisher) {
            doSetProperty("publisher", publisher);
            return this;
        }
    
        
        /**
         * Streaming output mode: complete (default) or chunks.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: complete
         * Group: producer
         * 
         * @param streamOutputMode the value to set
         * @return the dsl builder
         */
        default GoogleVertexaiComponentBuilder streamOutputMode(java.lang.String streamOutputMode) {
            doSetProperty("streamOutputMode", streamOutputMode);
            return this;
        }
    
        
        /**
         * Temperature parameter for generation (0.0-1.0).
         * 
         * The option is a: &lt;code&gt;java.lang.Float&lt;/code&gt; type.
         * 
         * Default: 0.7
         * Group: producer
         * 
         * @param temperature the value to set
         * @return the dsl builder
         */
        default GoogleVertexaiComponentBuilder temperature(java.lang.Float temperature) {
            doSetProperty("temperature", temperature);
            return this;
        }
    
        
        /**
         * Top-K parameter for generation.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 40
         * Group: producer
         * 
         * @param topK the value to set
         * @return the dsl builder
         */
        default GoogleVertexaiComponentBuilder topK(java.lang.Integer topK) {
            doSetProperty("topK", topK);
            return this;
        }
    
        
        /**
         * Top-P parameter for nucleus sampling.
         * 
         * The option is a: &lt;code&gt;java.lang.Float&lt;/code&gt; type.
         * 
         * Default: 0.95
         * Group: producer
         * 
         * @param topP the value to set
         * @return the dsl builder
         */
        default GoogleVertexaiComponentBuilder topP(java.lang.Float topP) {
            doSetProperty("topP", topP);
            return this;
        }
    
        
        /**
         * Whether autowiring is enabled. This is used for automatic autowiring
         * options (the option must be marked as autowired) by looking up in the
         * registry to find if there is a single instance of matching type,
         * which then gets configured on the component. This can be used for
         * automatic configuring JDBC data sources, JMS connection factories,
         * AWS Clients, etc.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param autowiredEnabled the value to set
         * @return the dsl builder
         */
        default GoogleVertexaiComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
    
        /**
         * The Google GenAI client for Vertex AI.
         * 
         * The option is a: &lt;code&gt;com.google.genai.Client&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param client the value to set
         * @return the dsl builder
         */
        default GoogleVertexaiComponentBuilder client(com.google.genai.Client client) {
            doSetProperty("client", client);
            return this;
        }
    
        /**
         * The Google Cloud AI Platform Prediction Service client for rawPredict
         * operations.
         * 
         * The option is a:
         * &lt;code&gt;com.google.cloud.aiplatform.v1.PredictionServiceClient&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param predictionServiceClient the value to set
         * @return the dsl builder
         */
        default GoogleVertexaiComponentBuilder predictionServiceClient(com.google.cloud.aiplatform.v1.PredictionServiceClient predictionServiceClient) {
            doSetProperty("predictionServiceClient", predictionServiceClient);
            return this;
        }
    
        
        /**
         * Used for enabling or disabling all consumer based health checks from
         * this component.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: health
         * 
         * @param healthCheckConsumerEnabled the value to set
         * @return the dsl builder
         */
        default GoogleVertexaiComponentBuilder healthCheckConsumerEnabled(boolean healthCheckConsumerEnabled) {
            doSetProperty("healthCheckConsumerEnabled", healthCheckConsumerEnabled);
            return this;
        }
    
        
        /**
         * Used for enabling or disabling all producer based health checks from
         * this component. Notice: Camel has by default disabled all producer
         * based health-checks. You can turn on producer checks globally by
         * setting camel.health.producersEnabled=true.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: health
         * 
         * @param healthCheckProducerEnabled the value to set
         * @return the dsl builder
         */
        default GoogleVertexaiComponentBuilder healthCheckProducerEnabled(boolean healthCheckProducerEnabled) {
            doSetProperty("healthCheckProducerEnabled", healthCheckProducerEnabled);
            return this;
        }
    }

    class GoogleVertexaiComponentBuilderImpl
            extends AbstractComponentBuilder<GoogleVertexAIComponent>
            implements GoogleVertexaiComponentBuilder {
        @Override
        protected GoogleVertexAIComponent buildConcreteComponent() {
            return new GoogleVertexAIComponent();
        }
        private org.apache.camel.component.google.vertexai.GoogleVertexAIConfiguration getOrCreateConfiguration(GoogleVertexAIComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new org.apache.camel.component.google.vertexai.GoogleVertexAIConfiguration());
            }
            return component.getConfiguration();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "serviceAccountKey": getOrCreateConfiguration((GoogleVertexAIComponent) component).setServiceAccountKey((java.lang.String) value); return true;
            case "anthropicVersion": getOrCreateConfiguration((GoogleVertexAIComponent) component).setAnthropicVersion((java.lang.String) value); return true;
            case "candidateCount": getOrCreateConfiguration((GoogleVertexAIComponent) component).setCandidateCount((java.lang.Integer) value); return true;
            case "configuration": ((GoogleVertexAIComponent) component).setConfiguration((org.apache.camel.component.google.vertexai.GoogleVertexAIConfiguration) value); return true;
            case "jsonMode": getOrCreateConfiguration((GoogleVertexAIComponent) component).setJsonMode((boolean) value); return true;
            case "lazyStartProducer": ((GoogleVertexAIComponent) component).setLazyStartProducer((boolean) value); return true;
            case "maxOutputTokens": getOrCreateConfiguration((GoogleVertexAIComponent) component).setMaxOutputTokens((java.lang.Integer) value); return true;
            case "operation": getOrCreateConfiguration((GoogleVertexAIComponent) component).setOperation((org.apache.camel.component.google.vertexai.GoogleVertexAIOperations) value); return true;
            case "publisher": getOrCreateConfiguration((GoogleVertexAIComponent) component).setPublisher((java.lang.String) value); return true;
            case "streamOutputMode": getOrCreateConfiguration((GoogleVertexAIComponent) component).setStreamOutputMode((java.lang.String) value); return true;
            case "temperature": getOrCreateConfiguration((GoogleVertexAIComponent) component).setTemperature((java.lang.Float) value); return true;
            case "topK": getOrCreateConfiguration((GoogleVertexAIComponent) component).setTopK((java.lang.Integer) value); return true;
            case "topP": getOrCreateConfiguration((GoogleVertexAIComponent) component).setTopP((java.lang.Float) value); return true;
            case "autowiredEnabled": ((GoogleVertexAIComponent) component).setAutowiredEnabled((boolean) value); return true;
            case "client": getOrCreateConfiguration((GoogleVertexAIComponent) component).setClient((com.google.genai.Client) value); return true;
            case "predictionServiceClient": getOrCreateConfiguration((GoogleVertexAIComponent) component).setPredictionServiceClient((com.google.cloud.aiplatform.v1.PredictionServiceClient) value); return true;
            case "healthCheckConsumerEnabled": ((GoogleVertexAIComponent) component).setHealthCheckConsumerEnabled((boolean) value); return true;
            case "healthCheckProducerEnabled": ((GoogleVertexAIComponent) component).setHealthCheckProducerEnabled((boolean) value); return true;
            default: return false;
            }
        }
    }
}