/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Retrieve secrets from CyberArk Conjur Vault.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface CyberArkVaultEndpointBuilderFactory {

    /**
     * Builder for endpoint for the CyberArk Vault component.
     */
    public interface CyberArkVaultEndpointBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedCyberArkVaultEndpointBuilder advanced() {
            return (AdvancedCyberArkVaultEndpointBuilder) this;
        }

        /**
         * The CyberArk Conjur account name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: producer
         * 
         * @param account the value to set
         * @return the dsl builder
         */
        default CyberArkVaultEndpointBuilder account(String account) {
            doSetProperty("account", account);
            return this;
        }
        /**
         * Path to the SSL certificate for verification.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param certificatePath the value to set
         * @return the dsl builder
         */
        default CyberArkVaultEndpointBuilder certificatePath(String certificatePath) {
            doSetProperty("certificatePath", certificatePath);
            return this;
        }
        /**
         * Reference to a ConjurClient instance in the registry.
         * 
         * The option is a:
         * <code>org.apache.camel.component.cyberark.vault.client.ConjurClient</code> type.
         * 
         * Group: producer
         * 
         * @param conjurClient the value to set
         * @return the dsl builder
         */
        default CyberArkVaultEndpointBuilder conjurClient(org.apache.camel.component.cyberark.vault.client.ConjurClient conjurClient) {
            doSetProperty("conjurClient", conjurClient);
            return this;
        }
        /**
         * Reference to a ConjurClient instance in the registry.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.cyberark.vault.client.ConjurClient</code> type.
         * 
         * Group: producer
         * 
         * @param conjurClient the value to set
         * @return the dsl builder
         */
        default CyberArkVaultEndpointBuilder conjurClient(String conjurClient) {
            doSetProperty("conjurClient", conjurClient);
            return this;
        }
        /**
         * The operation to perform. It can be getSecret or createSecret.
         * 
         * The option is a:
         * <code>org.apache.camel.component.cyberark.vault.CyberArkVaultOperations</code> type.
         * 
         * Default: getSecret
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default CyberArkVaultEndpointBuilder operation(org.apache.camel.component.cyberark.vault.CyberArkVaultOperations operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * The operation to perform. It can be getSecret or createSecret.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.cyberark.vault.CyberArkVaultOperations</code> type.
         * 
         * Default: getSecret
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default CyberArkVaultEndpointBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * The secret ID to retrieve from CyberArk Conjur.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param secretId the value to set
         * @return the dsl builder
         */
        default CyberArkVaultEndpointBuilder secretId(String secretId) {
            doSetProperty("secretId", secretId);
            return this;
        }
        /**
         * The CyberArk Conjur instance URL.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: producer
         * 
         * @param url the value to set
         * @return the dsl builder
         */
        default CyberArkVaultEndpointBuilder url(String url) {
            doSetProperty("url", url);
            return this;
        }
        /**
         * Whether to verify SSL certificates when connecting to CyberArk
         * Conjur.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param verifySsl the value to set
         * @return the dsl builder
         */
        default CyberArkVaultEndpointBuilder verifySsl(boolean verifySsl) {
            doSetProperty("verifySsl", verifySsl);
            return this;
        }
        /**
         * Whether to verify SSL certificates when connecting to CyberArk
         * Conjur.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param verifySsl the value to set
         * @return the dsl builder
         */
        default CyberArkVaultEndpointBuilder verifySsl(String verifySsl) {
            doSetProperty("verifySsl", verifySsl);
            return this;
        }
        /**
         * The API key for authentication with CyberArk Conjur.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param apiKey the value to set
         * @return the dsl builder
         */
        default CyberArkVaultEndpointBuilder apiKey(String apiKey) {
            doSetProperty("apiKey", apiKey);
            return this;
        }
        /**
         * Pre-authenticated token to use for CyberArk Conjur.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param authToken the value to set
         * @return the dsl builder
         */
        default CyberArkVaultEndpointBuilder authToken(String authToken) {
            doSetProperty("authToken", authToken);
            return this;
        }
        /**
         * The password for authentication with CyberArk Conjur.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default CyberArkVaultEndpointBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * The username for authentication with CyberArk Conjur.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default CyberArkVaultEndpointBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the CyberArk Vault component.
     */
    public interface AdvancedCyberArkVaultEndpointBuilder
            extends
                EndpointProducerBuilder {
        default CyberArkVaultEndpointBuilder basic() {
            return (CyberArkVaultEndpointBuilder) this;
        }

        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedCyberArkVaultEndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedCyberArkVaultEndpointBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    public interface CyberArkVaultBuilders {
        /**
         * CyberArk Vault (camel-cyberark-vault)
         * Retrieve secrets from CyberArk Conjur Vault.
         * 
         * Category: cloud,security
         * Since: 4.17
         * Maven coordinates: org.apache.camel:camel-cyberark-vault
         * 
         * Syntax: <code>cyberark-vault:label</code>
         * 
         * Path parameter: label (required)
         * Logical name
         * 
         * @param path label
         * @return the dsl builder
         */
        default CyberArkVaultEndpointBuilder cyberarkVault(String path) {
            return CyberArkVaultEndpointBuilderFactory.endpointBuilder("cyberark-vault", path);
        }
        /**
         * CyberArk Vault (camel-cyberark-vault)
         * Retrieve secrets from CyberArk Conjur Vault.
         * 
         * Category: cloud,security
         * Since: 4.17
         * Maven coordinates: org.apache.camel:camel-cyberark-vault
         * 
         * Syntax: <code>cyberark-vault:label</code>
         * 
         * Path parameter: label (required)
         * Logical name
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path label
         * @return the dsl builder
         */
        default CyberArkVaultEndpointBuilder cyberarkVault(String componentName, String path) {
            return CyberArkVaultEndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    static CyberArkVaultEndpointBuilder endpointBuilder(String componentName, String path) {
        class CyberArkVaultEndpointBuilderImpl extends AbstractEndpointBuilder implements CyberArkVaultEndpointBuilder, AdvancedCyberArkVaultEndpointBuilder {
            public CyberArkVaultEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new CyberArkVaultEndpointBuilderImpl(path);
    }
}