/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.crypto.NativeCodeLoader;
import org.apache.commons.crypto.OpenSslInfoNative;
import org.apache.commons.crypto.cipher.CryptoCipher;
import org.apache.commons.crypto.cipher.CryptoCipherFactory;
import org.apache.commons.crypto.random.CryptoRandom;
import org.apache.commons.crypto.random.CryptoRandomFactory;

public final class Crypto {
    public static final String CONF_PREFIX = "commons.crypto.";
    public static final String LIB_NAME_KEY = "commons.crypto.lib.name";
    public static final String LIB_PATH_KEY = "commons.crypto.lib.path";
    public static final String LIB_TEMPDIR_KEY = "commons.crypto.lib.tempdir";
    private static boolean quiet = false;

    public static String getComponentName() {
        return ComponentPropertiesHolder.PROPERTIES.getProperty("NAME");
    }

    public static String getComponentVersion() {
        return ComponentPropertiesHolder.PROPERTIES.getProperty("VERSION");
    }

    public static Throwable getLoadingError() {
        return NativeCodeLoader.getLoadingError();
    }

    private static void info(String format, Object ... args) {
        if (!quiet) {
            System.out.println(String.format(format, args));
        }
    }

    public static boolean isNativeCodeLoaded() {
        return NativeCodeLoader.isNativeCodeLoaded();
    }

    public static void main(String[] args) throws Exception {
        quiet = args.length == 1 && args[0].equals("-q");
        Crypto.info("%s %s", Crypto.getComponentName(), Crypto.getComponentVersion());
        if (Crypto.isNativeCodeLoaded()) {
            Crypto.info("Native code loaded OK: %s", OpenSslInfoNative.NativeVersion());
            Crypto.info("Native name: %s", OpenSslInfoNative.NativeName());
            Crypto.info("Native built: %s", OpenSslInfoNative.NativeTimeStamp());
            Crypto.info("OpenSSL library loaded OK, version: 0x%s", Long.toHexString(OpenSslInfoNative.OpenSSL()));
            Crypto.info("OpenSSL library info: %s", OpenSslInfoNative.OpenSSLVersion(0));
            Crypto.info("DLL name: %s", OpenSslInfoNative.DLLName());
            Crypto.info("DLL path: %s", OpenSslInfoNative.DLLPath());
            Properties props = new Properties();
            props.setProperty("commons.crypto.secure.random.classes", CryptoRandomFactory.RandomProvider.OPENSSL.getClassName());
            Throwable throwable = null;
            Object var3_6 = null;
            try (CryptoRandom cryptoRandom = CryptoRandomFactory.getCryptoRandom(props);){
                Crypto.info("Random instance created OK: %s", cryptoRandom);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            props = new Properties();
            props.setProperty("commons.crypto.cipher.classes", CryptoCipherFactory.CipherProvider.OPENSSL.getClassName());
            throwable = null;
            var3_6 = null;
            try (CryptoCipher cryptoCipher = CryptoCipherFactory.getCryptoCipher("AES/CTR/NoPadding", props);){
                Crypto.info("Cipher %s instance created OK: %s", "AES/CTR/NoPadding", cryptoCipher);
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            Crypto.info("Additional OpenSSL_version(n) details:", new Object[0]);
            int j = 1;
            while (j < 6) {
                Crypto.info("%s: %s", j, OpenSslInfoNative.OpenSSLVersion(j));
                ++j;
            }
        } else {
            Crypto.info("Native load failed: %s", Crypto.getLoadingError());
        }
    }

    private static class ComponentPropertiesHolder {
        static final Properties PROPERTIES = ComponentPropertiesHolder.getComponentProperties();

        private ComponentPropertiesHolder() {
        }

        private static Properties getComponentProperties() {
            URL url = Crypto.class.getResource("/org/apache/commons/crypto/component.properties");
            Properties versionData = new Properties();
            if (url != null) {
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (InputStream inputStream = url.openStream();){
                        versionData.load(inputStream);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return versionData;
        }
    }
}

