/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto.jna;

import java.util.Objects;
import org.apache.commons.crypto.Crypto;
import org.apache.commons.crypto.cipher.CryptoCipher;
import org.apache.commons.crypto.jna.OpenSslJnaCipher;
import org.apache.commons.crypto.jna.OpenSslJnaCryptoRandom;
import org.apache.commons.crypto.jna.OpenSslNativeJna;
import org.apache.commons.crypto.random.CryptoRandom;

public final class OpenSslJna {
    private static final String KEY_DEBUG = "commons.crypto.debug";

    static void debug(Object format, Object ... args) {
        if (Boolean.getBoolean(KEY_DEBUG)) {
            System.out.println(String.format(Objects.toString(format), args));
        }
    }

    public static Class<? extends CryptoCipher> getCipherClass() {
        return OpenSslJnaCipher.class;
    }

    public static Class<? extends CryptoRandom> getRandomClass() {
        return OpenSslJnaCryptoRandom.class;
    }

    private static void info(String format, Object ... args) {
        System.out.println(String.format(format, args));
    }

    public static Throwable initialisationError() {
        return OpenSslNativeJna.INIT_ERROR;
    }

    public static boolean isEnabled() {
        return OpenSslNativeJna.INIT_OK;
    }

    public static void main(String[] args) throws Throwable {
        OpenSslJna.info(String.valueOf(Crypto.getComponentName()) + " OpenSslJna: enabled = %s, version = 0x%08X", OpenSslJna.isEnabled(), OpenSslNativeJna.VERSION);
        Throwable initialisationError = OpenSslJna.initialisationError();
        if (initialisationError != null) {
            OpenSslJna.info("initialisationError(): %s", initialisationError);
            System.err.flush();
            throw initialisationError;
        }
        int i = 0;
        while (i <= 5) {
            OpenSslJna.info("OpenSSLVersion(%d): %s", i, OpenSslJna.OpenSSLVersion(i));
            ++i;
        }
    }

    static String OpenSSLVersion(int type) {
        return OpenSslNativeJna.OpenSSLVersion(type);
    }
}

