/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.euclidean.oned;

import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.geometry.euclidean.oned.Interval;
import org.apache.commons.math3.geometry.partitioning.Region;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;
import org.junit.Assert;
import org.junit.Test;

public class IntervalTest {
    @Test
    public void testInterval() {
        Interval interval = new Interval(2.3, 5.7);
        Assert.assertEquals((double)3.4, (double)interval.getSize(), (double)1.0E-10);
        Assert.assertEquals((double)4.0, (double)interval.getBarycenter(), (double)1.0E-10);
        Assert.assertEquals((Object)Region.Location.BOUNDARY, (Object)interval.checkPoint(2.3, 1.0E-10));
        Assert.assertEquals((Object)Region.Location.BOUNDARY, (Object)interval.checkPoint(5.7, 1.0E-10));
        Assert.assertEquals((Object)Region.Location.OUTSIDE, (Object)interval.checkPoint(1.2, 1.0E-10));
        Assert.assertEquals((Object)Region.Location.OUTSIDE, (Object)interval.checkPoint(8.7, 1.0E-10));
        Assert.assertEquals((Object)Region.Location.INSIDE, (Object)interval.checkPoint(3.0, 1.0E-10));
        Assert.assertEquals((double)2.3, (double)interval.getInf(), (double)1.0E-10);
        Assert.assertEquals((double)5.7, (double)interval.getSup(), (double)1.0E-10);
    }

    @Test
    public void testTolerance() {
        Interval interval = new Interval(2.3, 5.7);
        Assert.assertEquals((Object)Region.Location.OUTSIDE, (Object)interval.checkPoint(1.2, 1.0));
        Assert.assertEquals((Object)Region.Location.BOUNDARY, (Object)interval.checkPoint(1.2, 1.2));
        Assert.assertEquals((Object)Region.Location.OUTSIDE, (Object)interval.checkPoint(8.7, 2.9));
        Assert.assertEquals((Object)Region.Location.BOUNDARY, (Object)interval.checkPoint(8.7, 3.1));
        Assert.assertEquals((Object)Region.Location.INSIDE, (Object)interval.checkPoint(3.0, 0.6));
        Assert.assertEquals((Object)Region.Location.BOUNDARY, (Object)interval.checkPoint(3.0, 0.8));
    }

    @Test
    public void testInfinite() {
        Interval interval = new Interval(9.0, Double.POSITIVE_INFINITY);
        Assert.assertEquals((Object)Region.Location.BOUNDARY, (Object)interval.checkPoint(9.0, 1.0E-10));
        Assert.assertEquals((Object)Region.Location.OUTSIDE, (Object)interval.checkPoint(8.4, 1.0E-10));
        for (double e = 1.0; e <= 6.0; e += 1.0) {
            Assert.assertEquals((Object)Region.Location.INSIDE, (Object)interval.checkPoint(FastMath.pow((double)10.0, (double)e), 1.0E-10));
        }
        Assert.assertTrue((boolean)Double.isInfinite(interval.getSize()));
        Assert.assertEquals((double)9.0, (double)interval.getInf(), (double)1.0E-10);
        Assert.assertTrue((boolean)Double.isInfinite(interval.getSup()));
    }

    @Test
    public void testSinglePoint() {
        Interval interval = new Interval(1.0, 1.0);
        Assert.assertEquals((double)0.0, (double)interval.getSize(), (double)Precision.SAFE_MIN);
        Assert.assertEquals((double)1.0, (double)interval.getBarycenter(), (double)Precision.EPSILON);
    }

    @Test(expected=NumberIsTooSmallException.class)
    public void testStrictOrdering() {
        new Interval(0.0, -1.0);
    }
}

