/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import org.apache.commons.math3.Field;
import org.apache.commons.math3.FieldElement;
import org.apache.commons.math3.TestUtils;
import org.apache.commons.math3.fraction.Fraction;
import org.apache.commons.math3.fraction.FractionField;
import org.apache.commons.math3.linear.Array2DRowFieldMatrix;
import org.apache.commons.math3.linear.FieldLUDecomposition;
import org.apache.commons.math3.linear.FieldMatrix;
import org.apache.commons.math3.linear.NonSquareMatrixException;
import org.junit.Assert;
import org.junit.Test;

public class FieldLUDecompositionTest {
    private Fraction[][] testData = new Fraction[][]{{new Fraction(1), new Fraction(2), new Fraction(3)}, {new Fraction(2), new Fraction(5), new Fraction(3)}, {new Fraction(1), new Fraction(0), new Fraction(8)}};
    private Fraction[][] testDataMinus = new Fraction[][]{{new Fraction(-1), new Fraction(-2), new Fraction(-3)}, {new Fraction(-2), new Fraction(-5), new Fraction(-3)}, {new Fraction(-1), new Fraction(0), new Fraction(-8)}};
    private Fraction[][] luData = new Fraction[][]{{new Fraction(2), new Fraction(3), new Fraction(3)}, {new Fraction(2), new Fraction(3), new Fraction(7)}, {new Fraction(6), new Fraction(6), new Fraction(8)}};
    private Fraction[][] singular = new Fraction[][]{{new Fraction(2), new Fraction(3)}, {new Fraction(2), new Fraction(3)}};
    private Fraction[][] bigSingular = new Fraction[][]{{new Fraction(1), new Fraction(2), new Fraction(3), new Fraction(4)}, {new Fraction(2), new Fraction(5), new Fraction(3), new Fraction(4)}, {new Fraction(7), new Fraction(3), new Fraction(256), new Fraction(1930)}, {new Fraction(3), new Fraction(7), new Fraction(6), new Fraction(8)}};

    @Test
    public void testDimensions() {
        Array2DRowFieldMatrix matrix = new Array2DRowFieldMatrix((Field)FractionField.getInstance(), (FieldElement[][])this.testData);
        FieldLUDecomposition LU = new FieldLUDecomposition((FieldMatrix)matrix);
        Assert.assertEquals((long)this.testData.length, (long)LU.getL().getRowDimension());
        Assert.assertEquals((long)this.testData.length, (long)LU.getL().getColumnDimension());
        Assert.assertEquals((long)this.testData.length, (long)LU.getU().getRowDimension());
        Assert.assertEquals((long)this.testData.length, (long)LU.getU().getColumnDimension());
        Assert.assertEquals((long)this.testData.length, (long)LU.getP().getRowDimension());
        Assert.assertEquals((long)this.testData.length, (long)LU.getP().getColumnDimension());
    }

    @Test
    public void testNonSquare() {
        try {
            new FieldLUDecomposition((FieldMatrix)new Array2DRowFieldMatrix((FieldElement[][])new Fraction[][]{{Fraction.ZERO, Fraction.ZERO}, {Fraction.ZERO, Fraction.ZERO}, {Fraction.ZERO, Fraction.ZERO}}));
            Assert.fail((String)"Expected NonSquareMatrixException");
        }
        catch (NonSquareMatrixException nonSquareMatrixException) {
            // empty catch block
        }
    }

    @Test
    public void testPAEqualLU() {
        Array2DRowFieldMatrix matrix = new Array2DRowFieldMatrix((Field)FractionField.getInstance(), (FieldElement[][])this.testData);
        FieldLUDecomposition lu = new FieldLUDecomposition((FieldMatrix)matrix);
        FieldMatrix l = lu.getL();
        FieldMatrix u = lu.getU();
        FieldMatrix p = lu.getP();
        TestUtils.assertEquals(p.multiply((FieldMatrix)matrix), l.multiply(u));
        matrix = new Array2DRowFieldMatrix((Field)FractionField.getInstance(), (FieldElement[][])this.testDataMinus);
        lu = new FieldLUDecomposition((FieldMatrix)matrix);
        l = lu.getL();
        u = lu.getU();
        p = lu.getP();
        TestUtils.assertEquals(p.multiply((FieldMatrix)matrix), l.multiply(u));
        matrix = new Array2DRowFieldMatrix((Field)FractionField.getInstance(), 17, 17);
        for (int i = 0; i < matrix.getRowDimension(); ++i) {
            matrix.setEntry(i, i, (FieldElement)Fraction.ONE);
        }
        lu = new FieldLUDecomposition((FieldMatrix)matrix);
        l = lu.getL();
        u = lu.getU();
        p = lu.getP();
        TestUtils.assertEquals(p.multiply((FieldMatrix)matrix), l.multiply(u));
        matrix = new Array2DRowFieldMatrix((Field)FractionField.getInstance(), (FieldElement[][])this.singular);
        lu = new FieldLUDecomposition((FieldMatrix)matrix);
        Assert.assertFalse((boolean)lu.getSolver().isNonSingular());
        Assert.assertNull((Object)lu.getL());
        Assert.assertNull((Object)lu.getU());
        Assert.assertNull((Object)lu.getP());
        matrix = new Array2DRowFieldMatrix((Field)FractionField.getInstance(), (FieldElement[][])this.bigSingular);
        lu = new FieldLUDecomposition((FieldMatrix)matrix);
        Assert.assertFalse((boolean)lu.getSolver().isNonSingular());
        Assert.assertNull((Object)lu.getL());
        Assert.assertNull((Object)lu.getU());
        Assert.assertNull((Object)lu.getP());
    }

    @Test
    public void testLLowerTriangular() {
        Array2DRowFieldMatrix matrix = new Array2DRowFieldMatrix((Field)FractionField.getInstance(), (FieldElement[][])this.testData);
        FieldMatrix l = new FieldLUDecomposition((FieldMatrix)matrix).getL();
        for (int i = 0; i < l.getRowDimension(); ++i) {
            Assert.assertEquals((Object)Fraction.ONE, (Object)l.getEntry(i, i));
            for (int j = i + 1; j < l.getColumnDimension(); ++j) {
                Assert.assertEquals((Object)Fraction.ZERO, (Object)l.getEntry(i, j));
            }
        }
    }

    @Test
    public void testUUpperTriangular() {
        Array2DRowFieldMatrix matrix = new Array2DRowFieldMatrix((Field)FractionField.getInstance(), (FieldElement[][])this.testData);
        FieldMatrix u = new FieldLUDecomposition((FieldMatrix)matrix).getU();
        for (int i = 0; i < u.getRowDimension(); ++i) {
            for (int j = 0; j < i; ++j) {
                Assert.assertEquals((Object)Fraction.ZERO, (Object)u.getEntry(i, j));
            }
        }
    }

    @Test
    public void testPPermutation() {
        Fraction e;
        int otherCount;
        int oneCount;
        int zeroCount;
        int i;
        Array2DRowFieldMatrix matrix = new Array2DRowFieldMatrix((Field)FractionField.getInstance(), (FieldElement[][])this.testData);
        FieldMatrix p = new FieldLUDecomposition((FieldMatrix)matrix).getP();
        FieldMatrix ppT = p.multiply(p.transpose());
        Array2DRowFieldMatrix id = new Array2DRowFieldMatrix((Field)FractionField.getInstance(), p.getRowDimension(), p.getRowDimension());
        for (i = 0; i < id.getRowDimension(); ++i) {
            id.setEntry(i, i, (FieldElement)Fraction.ONE);
        }
        TestUtils.assertEquals(id, ppT);
        for (i = 0; i < p.getRowDimension(); ++i) {
            zeroCount = 0;
            oneCount = 0;
            otherCount = 0;
            for (int j = 0; j < p.getColumnDimension(); ++j) {
                e = (Fraction)p.getEntry(i, j);
                if (e.equals((Object)Fraction.ZERO)) {
                    ++zeroCount;
                    continue;
                }
                if (e.equals((Object)Fraction.ONE)) {
                    ++oneCount;
                    continue;
                }
                ++otherCount;
            }
            Assert.assertEquals((long)(p.getColumnDimension() - 1), (long)zeroCount);
            Assert.assertEquals((long)1L, (long)oneCount);
            Assert.assertEquals((long)0L, (long)otherCount);
        }
        for (int j = 0; j < p.getColumnDimension(); ++j) {
            zeroCount = 0;
            oneCount = 0;
            otherCount = 0;
            for (int i2 = 0; i2 < p.getRowDimension(); ++i2) {
                e = (Fraction)p.getEntry(i2, j);
                if (e.equals((Object)Fraction.ZERO)) {
                    ++zeroCount;
                    continue;
                }
                if (e.equals((Object)Fraction.ONE)) {
                    ++oneCount;
                    continue;
                }
                ++otherCount;
            }
            Assert.assertEquals((long)(p.getRowDimension() - 1), (long)zeroCount);
            Assert.assertEquals((long)1L, (long)oneCount);
            Assert.assertEquals((long)0L, (long)otherCount);
        }
    }

    @Test
    public void testSingular() {
        FieldLUDecomposition lu = new FieldLUDecomposition((FieldMatrix)new Array2DRowFieldMatrix((Field)FractionField.getInstance(), (FieldElement[][])this.testData));
        Assert.assertTrue((boolean)lu.getSolver().isNonSingular());
        lu = new FieldLUDecomposition((FieldMatrix)new Array2DRowFieldMatrix((Field)FractionField.getInstance(), (FieldElement[][])this.singular));
        Assert.assertFalse((boolean)lu.getSolver().isNonSingular());
        lu = new FieldLUDecomposition((FieldMatrix)new Array2DRowFieldMatrix((Field)FractionField.getInstance(), (FieldElement[][])this.bigSingular));
        Assert.assertFalse((boolean)lu.getSolver().isNonSingular());
    }

    @Test
    public void testMatricesValues1() {
        FieldLUDecomposition lu = new FieldLUDecomposition((FieldMatrix)new Array2DRowFieldMatrix((Field)FractionField.getInstance(), (FieldElement[][])this.testData));
        Array2DRowFieldMatrix lRef = new Array2DRowFieldMatrix((Field)FractionField.getInstance(), (FieldElement[][])new Fraction[][]{{new Fraction(1), new Fraction(0), new Fraction(0)}, {new Fraction(2), new Fraction(1), new Fraction(0)}, {new Fraction(1), new Fraction(-2), new Fraction(1)}});
        Array2DRowFieldMatrix uRef = new Array2DRowFieldMatrix((Field)FractionField.getInstance(), (FieldElement[][])new Fraction[][]{{new Fraction(1), new Fraction(2), new Fraction(3)}, {new Fraction(0), new Fraction(1), new Fraction(-3)}, {new Fraction(0), new Fraction(0), new Fraction(-1)}});
        Array2DRowFieldMatrix pRef = new Array2DRowFieldMatrix((Field)FractionField.getInstance(), (FieldElement[][])new Fraction[][]{{new Fraction(1), new Fraction(0), new Fraction(0)}, {new Fraction(0), new Fraction(1), new Fraction(0)}, {new Fraction(0), new Fraction(0), new Fraction(1)}});
        int[] pivotRef = new int[]{0, 1, 2};
        FieldMatrix l = lu.getL();
        TestUtils.assertEquals(lRef, l);
        FieldMatrix u = lu.getU();
        TestUtils.assertEquals(uRef, u);
        FieldMatrix p = lu.getP();
        TestUtils.assertEquals(pRef, p);
        int[] pivot = lu.getPivot();
        for (int i = 0; i < pivotRef.length; ++i) {
            Assert.assertEquals((long)pivotRef[i], (long)pivot[i]);
        }
        Assert.assertTrue((l == lu.getL() ? 1 : 0) != 0);
        Assert.assertTrue((u == lu.getU() ? 1 : 0) != 0);
        Assert.assertTrue((p == lu.getP() ? 1 : 0) != 0);
    }

    @Test
    public void testMatricesValues2() {
        FieldLUDecomposition lu = new FieldLUDecomposition((FieldMatrix)new Array2DRowFieldMatrix((Field)FractionField.getInstance(), (FieldElement[][])this.luData));
        Array2DRowFieldMatrix lRef = new Array2DRowFieldMatrix((Field)FractionField.getInstance(), (FieldElement[][])new Fraction[][]{{new Fraction(1), new Fraction(0), new Fraction(0)}, {new Fraction(3), new Fraction(1), new Fraction(0)}, {new Fraction(1), new Fraction(0), new Fraction(1)}});
        Array2DRowFieldMatrix uRef = new Array2DRowFieldMatrix((Field)FractionField.getInstance(), (FieldElement[][])new Fraction[][]{{new Fraction(2), new Fraction(3), new Fraction(3)}, {new Fraction(0), new Fraction(-3), new Fraction(-1)}, {new Fraction(0), new Fraction(0), new Fraction(4)}});
        Array2DRowFieldMatrix pRef = new Array2DRowFieldMatrix((Field)FractionField.getInstance(), (FieldElement[][])new Fraction[][]{{new Fraction(1), new Fraction(0), new Fraction(0)}, {new Fraction(0), new Fraction(0), new Fraction(1)}, {new Fraction(0), new Fraction(1), new Fraction(0)}});
        int[] pivotRef = new int[]{0, 2, 1};
        FieldMatrix l = lu.getL();
        TestUtils.assertEquals(lRef, l);
        FieldMatrix u = lu.getU();
        TestUtils.assertEquals(uRef, u);
        FieldMatrix p = lu.getP();
        TestUtils.assertEquals(pRef, p);
        int[] pivot = lu.getPivot();
        for (int i = 0; i < pivotRef.length; ++i) {
            Assert.assertEquals((long)pivotRef[i], (long)pivot[i]);
        }
        Assert.assertTrue((l == lu.getL() ? 1 : 0) != 0);
        Assert.assertTrue((u == lu.getU() ? 1 : 0) != 0);
        Assert.assertTrue((p == lu.getP() ? 1 : 0) != 0);
    }
}

