/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.exception.NoBracketingException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.TooManyEvaluationsException;
import org.apache.commons.math3.ode.FirstOrderDifferentialEquations;
import org.apache.commons.math3.ode.ODEIntegrator;
import org.apache.commons.math3.ode.TestProblem1;
import org.apache.commons.math3.ode.TestProblem3;
import org.apache.commons.math3.ode.TestProblem4;
import org.apache.commons.math3.ode.TestProblem5;
import org.apache.commons.math3.ode.TestProblemHandler;
import org.apache.commons.math3.ode.events.EventHandler;
import org.apache.commons.math3.ode.nonstiff.HighamHall54Integrator;
import org.apache.commons.math3.ode.sampling.StepHandler;
import org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class HighamHall54IntegratorTest {
    @Test
    public void testWrongDerivative() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        HighamHall54Integrator integrator = new HighamHall54Integrator(0.0, 1.0, 1.0E-10, 1.0E-10);
        FirstOrderDifferentialEquations equations = new FirstOrderDifferentialEquations(){

            public void computeDerivatives(double t, double[] y, double[] dot) {
                if (t < -0.5) {
                    throw new LocalException();
                }
                throw new RuntimeException("oops");
            }

            public int getDimension() {
                return 1;
            }
        };
        try {
            integrator.integrate(equations, -1.0, new double[1], 0.0, new double[1]);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (LocalException localException) {
            // empty catch block
        }
        try {
            integrator.integrate(equations, 0.0, new double[1], 1.0, new double[1]);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test(expected=NumberIsTooSmallException.class)
    public void testMinStep() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        TestProblem1 pb = new TestProblem1();
        double minStep = 0.1 * (pb.getFinalTime() - pb.getInitialTime());
        double maxStep = pb.getFinalTime() - pb.getInitialTime();
        double[] vecAbsoluteTolerance = new double[]{1.0E-15, 1.0E-16};
        double[] vecRelativeTolerance = new double[]{1.0E-15, 1.0E-16};
        HighamHall54Integrator integ = new HighamHall54Integrator(minStep, maxStep, vecAbsoluteTolerance, vecRelativeTolerance);
        TestProblemHandler handler = new TestProblemHandler(pb, (ODEIntegrator)integ);
        integ.addStepHandler((StepHandler)handler);
        integ.integrate((FirstOrderDifferentialEquations)pb, pb.getInitialTime(), pb.getInitialState(), pb.getFinalTime(), new double[pb.getDimension()]);
        Assert.fail((String)"an exception should have been thrown");
    }

    @Test
    public void testIncreasingTolerance() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        int previousCalls = Integer.MAX_VALUE;
        for (int i = -12; i < -2; ++i) {
            TestProblem1 pb = new TestProblem1();
            double minStep = 0.0;
            double maxStep = pb.getFinalTime() - pb.getInitialTime();
            double scalAbsoluteTolerance = FastMath.pow((double)10.0, (int)i);
            double scalRelativeTolerance = 0.01 * scalAbsoluteTolerance;
            HighamHall54Integrator integ = new HighamHall54Integrator(minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
            TestProblemHandler handler = new TestProblemHandler(pb, (ODEIntegrator)integ);
            integ.addStepHandler((StepHandler)handler);
            integ.integrate((FirstOrderDifferentialEquations)pb, pb.getInitialTime(), pb.getInitialState(), pb.getFinalTime(), new double[pb.getDimension()]);
            Assert.assertTrue((handler.getMaximalValueError() < 1.3 * scalAbsoluteTolerance ? 1 : 0) != 0);
            Assert.assertEquals((double)0.0, (double)handler.getMaximalTimeError(), (double)1.0E-12);
            int calls = pb.getCalls();
            Assert.assertEquals((long)integ.getEvaluations(), (long)calls);
            Assert.assertTrue((calls <= previousCalls ? 1 : 0) != 0);
            previousCalls = calls;
        }
    }

    @Test
    public void testBackward() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        TestProblem5 pb = new TestProblem5();
        double minStep = 0.0;
        double maxStep = pb.getFinalTime() - pb.getInitialTime();
        double scalAbsoluteTolerance = 1.0E-8;
        double scalRelativeTolerance = 0.01 * scalAbsoluteTolerance;
        HighamHall54Integrator integ = new HighamHall54Integrator(minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
        TestProblemHandler handler = new TestProblemHandler(pb, (ODEIntegrator)integ);
        integ.addStepHandler((StepHandler)handler);
        integ.integrate((FirstOrderDifferentialEquations)pb, pb.getInitialTime(), pb.getInitialState(), pb.getFinalTime(), new double[pb.getDimension()]);
        Assert.assertTrue((handler.getLastError() < 5.0E-7 ? 1 : 0) != 0);
        Assert.assertTrue((handler.getMaximalValueError() < 5.0E-7 ? 1 : 0) != 0);
        Assert.assertEquals((double)0.0, (double)handler.getMaximalTimeError(), (double)1.0E-12);
        Assert.assertEquals((Object)"Higham-Hall 5(4)", (Object)integ.getName());
    }

    @Test
    public void testEvents() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        TestProblem4 pb = new TestProblem4();
        double minStep = 0.0;
        double maxStep = pb.getFinalTime() - pb.getInitialTime();
        double scalAbsoluteTolerance = 1.0E-8;
        double scalRelativeTolerance = 0.01 * scalAbsoluteTolerance;
        HighamHall54Integrator integ = new HighamHall54Integrator(minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
        TestProblemHandler handler = new TestProblemHandler(pb, (ODEIntegrator)integ);
        integ.addStepHandler((StepHandler)handler);
        EventHandler[] functions = pb.getEventsHandlers();
        double convergence = 1.0E-8 * maxStep;
        for (int l = 0; l < functions.length; ++l) {
            integ.addEventHandler(functions[l], Double.POSITIVE_INFINITY, convergence, 1000);
        }
        Assert.assertEquals((long)functions.length, (long)integ.getEventHandlers().size());
        integ.integrate((FirstOrderDifferentialEquations)pb, pb.getInitialTime(), pb.getInitialState(), pb.getFinalTime(), new double[pb.getDimension()]);
        Assert.assertTrue((handler.getMaximalValueError() < 1.0E-7 ? 1 : 0) != 0);
        Assert.assertEquals((double)0.0, (double)handler.getMaximalTimeError(), (double)convergence);
        Assert.assertEquals((double)12.0, (double)handler.getLastTime(), (double)convergence);
        integ.clearEventHandlers();
        Assert.assertEquals((long)0L, (long)integ.getEventHandlers().size());
    }

    @Test(expected=LocalException.class)
    public void testEventsErrors() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        final TestProblem1 pb = new TestProblem1();
        double minStep = 0.0;
        double maxStep = pb.getFinalTime() - pb.getInitialTime();
        double scalAbsoluteTolerance = 1.0E-8;
        double scalRelativeTolerance = 0.01 * scalAbsoluteTolerance;
        HighamHall54Integrator integ = new HighamHall54Integrator(minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
        TestProblemHandler handler = new TestProblemHandler(pb, (ODEIntegrator)integ);
        integ.addStepHandler((StepHandler)handler);
        integ.addEventHandler(new EventHandler(){

            public void init(double t0, double[] y0, double t) {
            }

            public EventHandler.Action eventOccurred(double t, double[] y, boolean increasing) {
                return EventHandler.Action.CONTINUE;
            }

            public double g(double t, double[] y) {
                double middle = (pb.getInitialTime() + pb.getFinalTime()) / 2.0;
                double offset = t - middle;
                if (offset > 0.0) {
                    throw new LocalException();
                }
                return offset;
            }

            public void resetState(double t, double[] y) {
            }
        }, Double.POSITIVE_INFINITY, 1.0E-8 * maxStep, 1000);
        integ.integrate((FirstOrderDifferentialEquations)pb, pb.getInitialTime(), pb.getInitialState(), pb.getFinalTime(), new double[pb.getDimension()]);
    }

    @Test
    public void testEventsNoConvergence() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        final TestProblem1 pb = new TestProblem1();
        double minStep = 0.0;
        double maxStep = pb.getFinalTime() - pb.getInitialTime();
        double scalAbsoluteTolerance = 1.0E-8;
        double scalRelativeTolerance = 0.01 * scalAbsoluteTolerance;
        HighamHall54Integrator integ = new HighamHall54Integrator(minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
        TestProblemHandler handler = new TestProblemHandler(pb, (ODEIntegrator)integ);
        integ.addStepHandler((StepHandler)handler);
        integ.addEventHandler(new EventHandler(){

            public void init(double t0, double[] y0, double t) {
            }

            public EventHandler.Action eventOccurred(double t, double[] y, boolean increasing) {
                return EventHandler.Action.CONTINUE;
            }

            public double g(double t, double[] y) {
                double middle = (pb.getInitialTime() + pb.getFinalTime()) / 2.0;
                double offset = t - middle;
                return offset > 0.0 ? offset + 0.5 : offset - 0.5;
            }

            public void resetState(double t, double[] y) {
            }
        }, Double.POSITIVE_INFINITY, 1.0E-8 * maxStep, 3);
        try {
            integ.integrate((FirstOrderDifferentialEquations)pb, pb.getInitialTime(), pb.getInitialState(), pb.getFinalTime(), new double[pb.getDimension()]);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (TooManyEvaluationsException tooManyEvaluationsException) {
            // empty catch block
        }
    }

    @Test
    public void testSanityChecks() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        HighamHall54Integrator integ2;
        TestProblem3 pb = new TestProblem3(0.9);
        double minStep = 0.0;
        double maxStep = pb.getFinalTime() - pb.getInitialTime();
        try {
            integ2 = new HighamHall54Integrator(minStep, maxStep, new double[4], new double[4]);
            integ2.integrate((FirstOrderDifferentialEquations)pb, pb.getInitialTime(), new double[6], pb.getFinalTime(), new double[pb.getDimension()]);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException integ2) {
            // empty catch block
        }
        try {
            integ2 = new HighamHall54Integrator(minStep, maxStep, new double[4], new double[4]);
            integ2.integrate((FirstOrderDifferentialEquations)pb, pb.getInitialTime(), pb.getInitialState(), pb.getFinalTime(), new double[6]);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException integ3) {
            // empty catch block
        }
        try {
            integ2 = new HighamHall54Integrator(minStep, maxStep, new double[2], new double[4]);
            integ2.integrate((FirstOrderDifferentialEquations)pb, pb.getInitialTime(), pb.getInitialState(), pb.getFinalTime(), new double[pb.getDimension()]);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException integ4) {
            // empty catch block
        }
        try {
            integ2 = new HighamHall54Integrator(minStep, maxStep, new double[4], new double[2]);
            integ2.integrate((FirstOrderDifferentialEquations)pb, pb.getInitialTime(), pb.getInitialState(), pb.getFinalTime(), new double[pb.getDimension()]);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException integ5) {
            // empty catch block
        }
        try {
            integ2 = new HighamHall54Integrator(minStep, maxStep, new double[4], new double[4]);
            integ2.integrate((FirstOrderDifferentialEquations)pb, pb.getInitialTime(), pb.getInitialState(), pb.getInitialTime(), new double[pb.getDimension()]);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (NumberIsTooSmallException numberIsTooSmallException) {
            // empty catch block
        }
    }

    @Test
    public void testKepler() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        TestProblem3 pb = new TestProblem3(0.9);
        double minStep = 0.0;
        double maxStep = pb.getFinalTime() - pb.getInitialTime();
        double[] vecAbsoluteTolerance = new double[]{1.0E-8, 1.0E-8, 1.0E-10, 1.0E-10};
        double[] vecRelativeTolerance = new double[]{1.0E-10, 1.0E-10, 1.0E-8, 1.0E-8};
        HighamHall54Integrator integ = new HighamHall54Integrator(minStep, maxStep, vecAbsoluteTolerance, vecRelativeTolerance);
        TestProblemHandler handler = new TestProblemHandler(pb, (ODEIntegrator)integ);
        integ.addStepHandler((StepHandler)handler);
        integ.integrate((FirstOrderDifferentialEquations)pb, pb.getInitialTime(), pb.getInitialState(), pb.getFinalTime(), new double[pb.getDimension()]);
        Assert.assertEquals((double)0.0, (double)handler.getMaximalValueError(), (double)1.5E-4);
        Assert.assertEquals((Object)"Higham-Hall 5(4)", (Object)integ.getName());
    }

    private static class LocalException
    extends RuntimeException {
        private static final long serialVersionUID = 3041292643919807960L;

        private LocalException() {
        }
    }
}

