/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optim.nonlinear.scalar.gradient;

import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.analysis.MultivariateVectorFunction;
import org.apache.commons.math3.exception.MathUnsupportedOperationException;
import org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import org.apache.commons.math3.linear.BlockRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.optim.ConvergenceChecker;
import org.apache.commons.math3.optim.InitialGuess;
import org.apache.commons.math3.optim.MaxEval;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.optim.PointValuePair;
import org.apache.commons.math3.optim.SimpleBounds;
import org.apache.commons.math3.optim.SimpleValueChecker;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import org.apache.commons.math3.optim.nonlinear.scalar.ObjectiveFunction;
import org.apache.commons.math3.optim.nonlinear.scalar.ObjectiveFunctionGradient;
import org.apache.commons.math3.optim.nonlinear.scalar.gradient.CircleScalar;
import org.apache.commons.math3.optim.nonlinear.scalar.gradient.NonLinearConjugateGradientOptimizer;
import org.apache.commons.math3.optim.nonlinear.scalar.gradient.Preconditioner;
import org.junit.Assert;
import org.junit.Test;

public class NonLinearConjugateGradientOptimizerTest {
    @Test(expected=MathUnsupportedOperationException.class)
    public void testBoundsUnsupported() {
        LinearProblem problem = new LinearProblem(new double[][]{{2.0}}, new double[]{3.0});
        NonLinearConjugateGradientOptimizer optimizer = new NonLinearConjugateGradientOptimizer(NonLinearConjugateGradientOptimizer.Formula.POLAK_RIBIERE, (ConvergenceChecker)new SimpleValueChecker(1.0E-6, 1.0E-6), 0.001, 0.001, 1.0);
        optimizer.optimize(new OptimizationData[]{new MaxEval(100), problem.getObjectiveFunction(), problem.getObjectiveFunctionGradient(), GoalType.MINIMIZE, new InitialGuess(new double[]{0.0}), new SimpleBounds(new double[]{-1.0}, new double[]{1.0})});
    }

    @Test
    public void testTrivial() {
        LinearProblem problem = new LinearProblem(new double[][]{{2.0}}, new double[]{3.0});
        NonLinearConjugateGradientOptimizer optimizer = new NonLinearConjugateGradientOptimizer(NonLinearConjugateGradientOptimizer.Formula.POLAK_RIBIERE, (ConvergenceChecker)new SimpleValueChecker(1.0E-6, 1.0E-6), 0.001, 0.001, 1.0);
        PointValuePair optimum = optimizer.optimize(new OptimizationData[]{new MaxEval(100), problem.getObjectiveFunction(), problem.getObjectiveFunctionGradient(), GoalType.MINIMIZE, new InitialGuess(new double[]{0.0})});
        Assert.assertEquals((double)1.5, (double)optimum.getPoint()[0], (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)((Double)optimum.getValue()), (double)1.0E-10);
        Assert.assertTrue((optimizer.getIterations() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testColumnsPermutation() {
        LinearProblem problem = new LinearProblem(new double[][]{{1.0, -1.0}, {0.0, 2.0}, {1.0, -2.0}}, new double[]{4.0, 6.0, 1.0});
        NonLinearConjugateGradientOptimizer optimizer = new NonLinearConjugateGradientOptimizer(NonLinearConjugateGradientOptimizer.Formula.POLAK_RIBIERE, (ConvergenceChecker)new SimpleValueChecker(1.0E-6, 1.0E-6), 0.001, 0.001, 1.0);
        PointValuePair optimum = optimizer.optimize(new OptimizationData[]{new MaxEval(100), problem.getObjectiveFunction(), problem.getObjectiveFunctionGradient(), GoalType.MINIMIZE, new InitialGuess(new double[]{0.0, 0.0})});
        Assert.assertEquals((double)7.0, (double)optimum.getPoint()[0], (double)1.0E-10);
        Assert.assertEquals((double)3.0, (double)optimum.getPoint()[1], (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)((Double)optimum.getValue()), (double)1.0E-10);
    }

    @Test
    public void testNoDependency() {
        LinearProblem problem = new LinearProblem(new double[][]{{2.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 2.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 2.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 2.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 2.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 2.0}}, new double[]{0.0, 1.1, 2.2, 3.3, 4.4, 5.5});
        NonLinearConjugateGradientOptimizer optimizer = new NonLinearConjugateGradientOptimizer(NonLinearConjugateGradientOptimizer.Formula.POLAK_RIBIERE, (ConvergenceChecker)new SimpleValueChecker(1.0E-6, 1.0E-6), 0.001, 0.001, 1.0);
        PointValuePair optimum = optimizer.optimize(new OptimizationData[]{new MaxEval(100), problem.getObjectiveFunction(), problem.getObjectiveFunctionGradient(), GoalType.MINIMIZE, new InitialGuess(new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0})});
        for (int i = 0; i < problem.target.length; ++i) {
            Assert.assertEquals((double)(0.55 * (double)i), (double)optimum.getPoint()[i], (double)1.0E-10);
        }
    }

    @Test
    public void testOneSet() {
        LinearProblem problem = new LinearProblem(new double[][]{{1.0, 0.0, 0.0}, {-1.0, 1.0, 0.0}, {0.0, -1.0, 1.0}}, new double[]{1.0, 1.0, 1.0});
        NonLinearConjugateGradientOptimizer optimizer = new NonLinearConjugateGradientOptimizer(NonLinearConjugateGradientOptimizer.Formula.POLAK_RIBIERE, (ConvergenceChecker)new SimpleValueChecker(1.0E-6, 1.0E-6), 0.001, 0.001, 1.0);
        PointValuePair optimum = optimizer.optimize(new OptimizationData[]{new MaxEval(100), problem.getObjectiveFunction(), problem.getObjectiveFunctionGradient(), GoalType.MINIMIZE, new InitialGuess(new double[]{0.0, 0.0, 0.0})});
        Assert.assertEquals((double)1.0, (double)optimum.getPoint()[0], (double)1.0E-10);
        Assert.assertEquals((double)2.0, (double)optimum.getPoint()[1], (double)1.0E-10);
        Assert.assertEquals((double)3.0, (double)optimum.getPoint()[2], (double)1.0E-10);
    }

    @Test
    public void testTwoSets() {
        double epsilon = 1.0E-7;
        LinearProblem problem = new LinearProblem(new double[][]{{2.0, 1.0, 0.0, 4.0, 0.0, 0.0}, {-4.0, -2.0, 3.0, -7.0, 0.0, 0.0}, {4.0, 1.0, -2.0, 8.0, 0.0, 0.0}, {0.0, -3.0, -12.0, -1.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 1.0E-7, 1.0}, {0.0, 0.0, 0.0, 0.0, 1.0, 1.0}}, new double[]{2.0, -9.0, 2.0, 2.0, 1.00000000000001, 2.0});
        Preconditioner preconditioner = new Preconditioner(){

            public double[] precondition(double[] point, double[] r) {
                double[] d = (double[])r.clone();
                d[0] = d[0] / 72.0;
                d[1] = d[1] / 30.0;
                d[2] = d[2] / 314.0;
                d[3] = d[3] / 260.0;
                d[4] = d[4] / 2.00000000000002;
                d[5] = d[5] / 4.0;
                return d;
            }
        };
        NonLinearConjugateGradientOptimizer optimizer = new NonLinearConjugateGradientOptimizer(NonLinearConjugateGradientOptimizer.Formula.POLAK_RIBIERE, (ConvergenceChecker)new SimpleValueChecker(1.0E-13, 1.0E-13), 1.0E-7, 1.0E-7, 1.0, preconditioner);
        PointValuePair optimum = optimizer.optimize(new OptimizationData[]{new MaxEval(100), problem.getObjectiveFunction(), problem.getObjectiveFunctionGradient(), GoalType.MINIMIZE, new InitialGuess(new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0})});
        double[] result = optimum.getPoint();
        double[] expected = new double[]{3.0, 4.0, -1.0, -2.0, 1.0000001, 0.9999999};
        Assert.assertEquals((double)expected[0], (double)result[0], (double)1.0E-7);
        Assert.assertEquals((double)expected[1], (double)result[1], (double)1.0E-7);
        Assert.assertEquals((double)expected[2], (double)result[2], (double)1.0E-9);
        Assert.assertEquals((double)expected[3], (double)result[3], (double)1.0E-8);
        Assert.assertEquals((double)(expected[4] + 1.0E-7), (double)result[4], (double)1.0E-6);
        Assert.assertEquals((double)(expected[5] - 1.0E-7), (double)result[5], (double)1.0E-6);
    }

    @Test
    public void testNonInversible() {
        LinearProblem problem = new LinearProblem(new double[][]{{1.0, 2.0, -3.0}, {2.0, 1.0, 3.0}, {-3.0, 0.0, -9.0}}, new double[]{1.0, 1.0, 1.0});
        NonLinearConjugateGradientOptimizer optimizer = new NonLinearConjugateGradientOptimizer(NonLinearConjugateGradientOptimizer.Formula.POLAK_RIBIERE, (ConvergenceChecker)new SimpleValueChecker(1.0E-6, 1.0E-6), 0.001, 0.001, 1.0);
        PointValuePair optimum = optimizer.optimize(new OptimizationData[]{new MaxEval(100), problem.getObjectiveFunction(), problem.getObjectiveFunctionGradient(), GoalType.MINIMIZE, new InitialGuess(new double[]{0.0, 0.0, 0.0})});
        Assert.assertTrue(((Double)optimum.getValue() > 0.5 ? 1 : 0) != 0);
    }

    @Test
    public void testIllConditioned() {
        LinearProblem problem1 = new LinearProblem(new double[][]{{10.0, 7.0, 8.0, 7.0}, {7.0, 5.0, 6.0, 5.0}, {8.0, 6.0, 10.0, 9.0}, {7.0, 5.0, 9.0, 10.0}}, new double[]{32.0, 23.0, 33.0, 31.0});
        NonLinearConjugateGradientOptimizer optimizer = new NonLinearConjugateGradientOptimizer(NonLinearConjugateGradientOptimizer.Formula.POLAK_RIBIERE, (ConvergenceChecker)new SimpleValueChecker(1.0E-13, 1.0E-13), 1.0E-15, 1.0E-15, 1.0);
        PointValuePair optimum1 = optimizer.optimize(new OptimizationData[]{new MaxEval(200), problem1.getObjectiveFunction(), problem1.getObjectiveFunctionGradient(), GoalType.MINIMIZE, new InitialGuess(new double[]{0.0, 1.0, 2.0, 3.0})});
        Assert.assertEquals((double)1.0, (double)optimum1.getPoint()[0], (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)optimum1.getPoint()[1], (double)0.001);
        Assert.assertEquals((double)1.0, (double)optimum1.getPoint()[2], (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)optimum1.getPoint()[3], (double)1.0E-4);
        LinearProblem problem2 = new LinearProblem(new double[][]{{10.0, 7.0, 8.1, 7.2}, {7.08, 5.04, 6.0, 5.0}, {8.0, 5.98, 9.89, 9.0}, {6.99, 4.99, 9.0, 9.98}}, new double[]{32.0, 23.0, 33.0, 31.0});
        PointValuePair optimum2 = optimizer.optimize(new OptimizationData[]{new MaxEval(200), problem2.getObjectiveFunction(), problem2.getObjectiveFunctionGradient(), GoalType.MINIMIZE, new InitialGuess(new double[]{0.0, 1.0, 2.0, 3.0})});
        double[] result2 = optimum2.getPoint();
        double[] expected2 = new double[]{-81.0, 137.0, -34.0, 22.0};
        Assert.assertEquals((double)expected2[0], (double)result2[0], (double)2.0);
        Assert.assertEquals((double)expected2[1], (double)result2[1], (double)4.0);
        Assert.assertEquals((double)expected2[2], (double)result2[2], (double)1.0);
        Assert.assertEquals((double)expected2[3], (double)result2[3], (double)1.0);
    }

    @Test
    public void testMoreEstimatedParametersSimple() {
        LinearProblem problem = new LinearProblem(new double[][]{{3.0, 2.0, 0.0, 0.0}, {0.0, 1.0, -1.0, 1.0}, {2.0, 0.0, 1.0, 0.0}}, new double[]{7.0, 3.0, 5.0});
        NonLinearConjugateGradientOptimizer optimizer = new NonLinearConjugateGradientOptimizer(NonLinearConjugateGradientOptimizer.Formula.POLAK_RIBIERE, (ConvergenceChecker)new SimpleValueChecker(1.0E-6, 1.0E-6), 0.001, 0.001, 1.0);
        PointValuePair optimum = optimizer.optimize(new OptimizationData[]{new MaxEval(100), problem.getObjectiveFunction(), problem.getObjectiveFunctionGradient(), GoalType.MINIMIZE, new InitialGuess(new double[]{7.0, 6.0, 5.0, 4.0})});
        Assert.assertEquals((double)0.0, (double)((Double)optimum.getValue()), (double)1.0E-10);
    }

    @Test
    public void testMoreEstimatedParametersUnsorted() {
        LinearProblem problem = new LinearProblem(new double[][]{{1.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 1.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 1.0, -1.0}, {0.0, 0.0, -1.0, 1.0, 0.0, 1.0}, {0.0, 0.0, 0.0, -1.0, 1.0, 0.0}}, new double[]{3.0, 12.0, -1.0, 7.0, 1.0});
        NonLinearConjugateGradientOptimizer optimizer = new NonLinearConjugateGradientOptimizer(NonLinearConjugateGradientOptimizer.Formula.POLAK_RIBIERE, (ConvergenceChecker)new SimpleValueChecker(1.0E-6, 1.0E-6), 0.001, 0.001, 1.0);
        PointValuePair optimum = optimizer.optimize(new OptimizationData[]{new MaxEval(100), problem.getObjectiveFunction(), problem.getObjectiveFunctionGradient(), GoalType.MINIMIZE, new InitialGuess(new double[]{2.0, 2.0, 2.0, 2.0, 2.0, 2.0})});
        Assert.assertEquals((double)0.0, (double)((Double)optimum.getValue()), (double)1.0E-10);
    }

    @Test
    public void testRedundantEquations() {
        LinearProblem problem = new LinearProblem(new double[][]{{1.0, 1.0}, {1.0, -1.0}, {1.0, 3.0}}, new double[]{3.0, 1.0, 5.0});
        NonLinearConjugateGradientOptimizer optimizer = new NonLinearConjugateGradientOptimizer(NonLinearConjugateGradientOptimizer.Formula.POLAK_RIBIERE, (ConvergenceChecker)new SimpleValueChecker(1.0E-6, 1.0E-6), 0.001, 0.001, 1.0);
        PointValuePair optimum = optimizer.optimize(new OptimizationData[]{new MaxEval(100), problem.getObjectiveFunction(), problem.getObjectiveFunctionGradient(), GoalType.MINIMIZE, new InitialGuess(new double[]{1.0, 1.0})});
        Assert.assertEquals((double)2.0, (double)optimum.getPoint()[0], (double)1.0E-8);
        Assert.assertEquals((double)1.0, (double)optimum.getPoint()[1], (double)1.0E-8);
    }

    @Test
    public void testInconsistentEquations() {
        LinearProblem problem = new LinearProblem(new double[][]{{1.0, 1.0}, {1.0, -1.0}, {1.0, 3.0}}, new double[]{3.0, 1.0, 4.0});
        NonLinearConjugateGradientOptimizer optimizer = new NonLinearConjugateGradientOptimizer(NonLinearConjugateGradientOptimizer.Formula.POLAK_RIBIERE, (ConvergenceChecker)new SimpleValueChecker(1.0E-6, 1.0E-6), 0.001, 0.001, 1.0);
        PointValuePair optimum = optimizer.optimize(new OptimizationData[]{new MaxEval(100), problem.getObjectiveFunction(), problem.getObjectiveFunctionGradient(), GoalType.MINIMIZE, new InitialGuess(new double[]{1.0, 1.0})});
        Assert.assertTrue(((Double)optimum.getValue() > 0.1 ? 1 : 0) != 0);
    }

    @Test
    public void testCircleFitting() {
        CircleScalar problem = new CircleScalar();
        problem.addPoint(30.0, 68.0);
        problem.addPoint(50.0, -6.0);
        problem.addPoint(110.0, -20.0);
        problem.addPoint(35.0, 15.0);
        problem.addPoint(45.0, 97.0);
        NonLinearConjugateGradientOptimizer optimizer = new NonLinearConjugateGradientOptimizer(NonLinearConjugateGradientOptimizer.Formula.POLAK_RIBIERE, (ConvergenceChecker)new SimpleValueChecker(1.0E-30, 1.0E-30), 1.0E-15, 1.0E-13, 1.0);
        PointValuePair optimum = optimizer.optimize(new OptimizationData[]{new MaxEval(100), problem.getObjectiveFunction(), problem.getObjectiveFunctionGradient(), GoalType.MINIMIZE, new InitialGuess(new double[]{98.68, 47.345})});
        Vector2D center = new Vector2D(optimum.getPointRef()[0], optimum.getPointRef()[1]);
        Assert.assertEquals((double)69.960161753, (double)problem.getRadius(center), (double)1.0E-8);
        Assert.assertEquals((double)96.075902096, (double)center.getX(), (double)1.0E-7);
        Assert.assertEquals((double)48.135167894, (double)center.getY(), (double)1.0E-6);
    }

    private static class LinearProblem {
        final RealMatrix factors;
        final double[] target;

        public LinearProblem(double[][] factors, double[] target) {
            this.factors = new BlockRealMatrix(factors);
            this.target = target;
        }

        public ObjectiveFunction getObjectiveFunction() {
            return new ObjectiveFunction(new MultivariateFunction(){

                public double value(double[] point) {
                    double[] y = LinearProblem.this.factors.operate(point);
                    double sum = 0.0;
                    for (int i = 0; i < y.length; ++i) {
                        double ri = y[i] - LinearProblem.this.target[i];
                        sum += ri * ri;
                    }
                    return sum;
                }
            });
        }

        public ObjectiveFunctionGradient getObjectiveFunctionGradient() {
            return new ObjectiveFunctionGradient(new MultivariateVectorFunction(){

                public double[] value(double[] point) {
                    double[] r = LinearProblem.this.factors.operate(point);
                    for (int i = 0; i < r.length; ++i) {
                        int n = i;
                        r[n] = r[n] - LinearProblem.this.target[i];
                    }
                    double[] p = LinearProblem.this.factors.transpose().operate(r);
                    int i = 0;
                    while (i < p.length) {
                        int n = i++;
                        p[n] = p[n] * 2.0;
                    }
                    return p;
                }
            });
        }
    }
}

