/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.distribution;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.math4.core.jdkmath.JdkMath;
import org.apache.commons.math4.legacy.distribution.AbstractRealDistribution;
import org.apache.commons.math4.legacy.exception.NotStrictlyPositiveException;
import org.apache.commons.math4.legacy.exception.OutOfRangeException;
import org.apache.commons.math4.legacy.stat.descriptive.StatisticalSummary;
import org.apache.commons.math4.legacy.stat.descriptive.SummaryStatistics;
import org.apache.commons.numbers.core.Precision;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.statistics.distribution.ContinuousDistribution;
import org.apache.commons.statistics.distribution.NormalDistribution;

public final class EmpiricalDistribution
extends AbstractRealDistribution
implements ContinuousDistribution {
    private final List<SummaryStatistics> binStats;
    private final SummaryStatistics sampleStats;
    private final double max;
    private final double min;
    private final double delta;
    private final int binCount;
    private final double[] upperBounds;
    private final Function<SummaryStatistics, ContinuousDistribution> kernelFactory;

    private EmpiricalDistribution(int binCount, double[] input, Function<SummaryStatistics, ContinuousDistribution> kernelFactory) {
        if (binCount <= 0) {
            throw new NotStrictlyPositiveException((Number)binCount);
        }
        this.binCount = binCount;
        this.sampleStats = new SummaryStatistics();
        for (int i = 0; i < input.length; ++i) {
            this.sampleStats.addValue(input[i]);
        }
        this.min = this.sampleStats.getMin();
        this.max = this.sampleStats.getMax();
        this.delta = (this.max - this.min) / (double)binCount;
        this.binStats = this.createBinStats(input);
        this.upperBounds = new double[binCount];
        double n = this.sampleStats.getN();
        this.upperBounds[0] = (double)this.binStats.get(0).getN() / n;
        for (int i = 1; i < binCount - 1; ++i) {
            this.upperBounds[i] = this.upperBounds[i - 1] + (double)this.binStats.get(i).getN() / n;
        }
        this.upperBounds[binCount - 1] = 1.0;
        this.kernelFactory = kernelFactory;
    }

    public static EmpiricalDistribution from(int binCount, double[] input, Function<SummaryStatistics, ContinuousDistribution> kernelFactory) {
        return new EmpiricalDistribution(binCount, input, kernelFactory);
    }

    public static EmpiricalDistribution from(int binCount, double[] input) {
        return EmpiricalDistribution.from(binCount, input, EmpiricalDistribution.defaultKernel());
    }

    private List<SummaryStatistics> createBinStats(double[] input) {
        int i;
        ArrayList<SummaryStatistics> stats = new ArrayList<SummaryStatistics>();
        for (i = 0; i < this.binCount; ++i) {
            stats.add(i, new SummaryStatistics());
        }
        for (i = 0; i < input.length; ++i) {
            double v = input[i];
            ((SummaryStatistics)stats.get(this.findBin(v))).addValue(v);
        }
        return stats;
    }

    private int findBin(double value) {
        return Math.min(Math.max((int)JdkMath.ceil((double)((value - this.min) / this.delta)) - 1, 0), this.binCount - 1);
    }

    public StatisticalSummary getSampleStats() {
        return this.sampleStats.copy();
    }

    public int getBinCount() {
        return this.binCount;
    }

    public List<SummaryStatistics> getBinStats() {
        ArrayList<SummaryStatistics> copy = new ArrayList<SummaryStatistics>();
        for (SummaryStatistics s : this.binStats) {
            copy.add(s.copy());
        }
        return copy;
    }

    public double[] getUpperBounds() {
        double[] binUpperBounds = new double[this.binCount];
        for (int i = 0; i < this.binCount - 1; ++i) {
            binUpperBounds[i] = this.min + this.delta * (double)(i + 1);
        }
        binUpperBounds[this.binCount - 1] = this.max;
        return binUpperBounds;
    }

    public double[] getGeneratorUpperBounds() {
        int len = this.upperBounds.length;
        double[] out = new double[len];
        System.arraycopy(this.upperBounds, 0, out, 0, len);
        return out;
    }

    public double density(double x) {
        if (x < this.min || x > this.max) {
            return 0.0;
        }
        int binIndex = this.findBin(x);
        ContinuousDistribution kernel = this.getKernel(this.binStats.get(binIndex));
        return kernel.density(x) * this.pB(binIndex) / this.kB(binIndex);
    }

    public double cumulativeProbability(double x) {
        if (x < this.min) {
            return 0.0;
        }
        if (x >= this.max) {
            return 1.0;
        }
        int binIndex = this.findBin(x);
        double pBminus = this.pBminus(binIndex);
        double pB = this.pB(binIndex);
        ContinuousDistribution kernel = this.k(x);
        if (kernel instanceof ConstantContinuousDistribution) {
            if (x < kernel.getMean()) {
                return pBminus;
            }
            return pBminus + pB;
        }
        double[] binBounds = this.getUpperBounds();
        double kB = this.kB(binIndex);
        double lower = binIndex == 0 ? this.min : binBounds[binIndex - 1];
        double withinBinCum = (kernel.cumulativeProbability(x) - kernel.cumulativeProbability(lower)) / kB;
        return pBminus + pB * withinBinCum;
    }

    @Override
    public double inverseCumulativeProbability(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new OutOfRangeException((Number)p, (Number)0, (Number)1);
        }
        if (p == 0.0) {
            return this.getSupportLowerBound();
        }
        if (p == 1.0) {
            return this.getSupportUpperBound();
        }
        int i = 0;
        while (this.cumBinP(i) < p) {
            ++i;
        }
        SummaryStatistics stats = this.binStats.get(i);
        ContinuousDistribution kernel = this.getKernel(stats);
        double kB = this.kB(i);
        double[] binBounds = this.getUpperBounds();
        double lower = i == 0 ? this.min : binBounds[i - 1];
        double kBminus = kernel.cumulativeProbability(lower);
        double pB = this.pB(i);
        double pBminus = this.pBminus(i);
        double pCrit = p - pBminus;
        if (pCrit <= 0.0) {
            return lower;
        }
        double cP = kBminus + pCrit * kB / pB;
        return Precision.equals((double)cP, (double)1.0) ? kernel.inverseCumulativeProbability(1.0) : kernel.inverseCumulativeProbability(cP);
    }

    public double getMean() {
        return this.sampleStats.getMean();
    }

    public double getVariance() {
        return this.sampleStats.getVariance();
    }

    public double getSupportLowerBound() {
        return this.min;
    }

    public double getSupportUpperBound() {
        return this.max;
    }

    private double pB(int i) {
        return i == 0 ? this.upperBounds[0] : this.upperBounds[i] - this.upperBounds[i - 1];
    }

    private double pBminus(int i) {
        return i == 0 ? 0.0 : this.upperBounds[i - 1];
    }

    private double kB(int i) {
        double[] binBounds = this.getUpperBounds();
        ContinuousDistribution kernel = this.getKernel(this.binStats.get(i));
        return i == 0 ? kernel.probability(this.min, binBounds[0]) : kernel.probability(binBounds[i - 1], binBounds[i]);
    }

    private ContinuousDistribution k(double x) {
        int binIndex = this.findBin(x);
        return this.getKernel(this.binStats.get(binIndex));
    }

    private double cumBinP(int binIndex) {
        return this.upperBounds[binIndex];
    }

    private ContinuousDistribution getKernel(SummaryStatistics stats) {
        return this.kernelFactory.apply(stats);
    }

    private static Function<SummaryStatistics, ContinuousDistribution> defaultKernel() {
        return stats -> {
            if (stats.getN() <= 3L || stats.getVariance() == 0.0) {
                return new ConstantContinuousDistribution(stats.getMean());
            }
            return NormalDistribution.of((double)stats.getMean(), (double)stats.getStandardDeviation());
        };
    }

    private static class ConstantContinuousDistribution
    implements ContinuousDistribution {
        private final double value;

        ConstantContinuousDistribution(double value) {
            this.value = value;
        }

        public double density(double x) {
            return x == this.value ? 1.0 : 0.0;
        }

        public double cumulativeProbability(double x) {
            return x < this.value ? 0.0 : 1.0;
        }

        public double inverseCumulativeProbability(double p) {
            if (p < 0.0 || p > 1.0) {
                throw new IllegalArgumentException("Internal error");
            }
            return this.value;
        }

        public double getMean() {
            return this.value;
        }

        public double getVariance() {
            return 0.0;
        }

        public double getSupportLowerBound() {
            return this.value;
        }

        public double getSupportUpperBound() {
            return this.value;
        }

        public ContinuousDistribution.Sampler createSampler(UniformRandomProvider rng) {
            return this::getSupportLowerBound;
        }
    }
}

