/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.ode.nonstiff;

import org.apache.commons.math4.legacy.core.Field;
import org.apache.commons.math4.legacy.core.RealFieldElement;
import org.apache.commons.math4.legacy.ode.FieldEquationsMapper;
import org.apache.commons.math4.legacy.ode.FieldODEStateAndDerivative;
import org.apache.commons.math4.legacy.ode.nonstiff.RungeKuttaFieldStepInterpolator;

class ClassicalRungeKuttaFieldStepInterpolator<T extends RealFieldElement<T>>
extends RungeKuttaFieldStepInterpolator<T> {
    ClassicalRungeKuttaFieldStepInterpolator(Field<T> field, boolean forward, T[][] yDotK, FieldODEStateAndDerivative<T> globalPreviousState, FieldODEStateAndDerivative<T> globalCurrentState, FieldODEStateAndDerivative<T> softPreviousState, FieldODEStateAndDerivative<T> softCurrentState, FieldEquationsMapper<T> mapper) {
        super(field, forward, yDotK, globalPreviousState, globalCurrentState, softPreviousState, softCurrentState, mapper);
    }

    @Override
    protected ClassicalRungeKuttaFieldStepInterpolator<T> create(Field<T> newField, boolean newForward, T[][] newYDotK, FieldODEStateAndDerivative<T> newGlobalPreviousState, FieldODEStateAndDerivative<T> newGlobalCurrentState, FieldODEStateAndDerivative<T> newSoftPreviousState, FieldODEStateAndDerivative<T> newSoftCurrentState, FieldEquationsMapper<T> newMapper) {
        return new ClassicalRungeKuttaFieldStepInterpolator(newField, newForward, newYDotK, newGlobalPreviousState, newGlobalCurrentState, newSoftPreviousState, newSoftCurrentState, newMapper);
    }

    @Override
    protected FieldODEStateAndDerivative<T> computeInterpolatedStateAndDerivatives(FieldEquationsMapper<T> mapper, T time, T theta, T thetaH, T oneMinusThetaH) {
        RealFieldElement[] interpolatedDerivatives;
        RealFieldElement[] interpolatedState;
        RealFieldElement one = (RealFieldElement)time.getField().getOne();
        RealFieldElement oneMinusTheta = (RealFieldElement)one.subtract(theta);
        RealFieldElement oneMinus2Theta = (RealFieldElement)one.subtract((Object)((RealFieldElement)theta.multiply(2)));
        RealFieldElement coeffDot1 = (RealFieldElement)oneMinusTheta.multiply((Object)oneMinus2Theta);
        RealFieldElement coeffDot23 = (RealFieldElement)((RealFieldElement)theta.multiply((Object)oneMinusTheta)).multiply(2);
        RealFieldElement coeffDot4 = (RealFieldElement)((RealFieldElement)theta.multiply((Object)oneMinus2Theta)).negate();
        if (this.getGlobalPreviousState() != null && theta.getReal() <= 0.5) {
            RealFieldElement fourTheta2 = (RealFieldElement)((RealFieldElement)theta.multiply(theta)).multiply(4);
            RealFieldElement s = (RealFieldElement)thetaH.divide(6.0);
            RealFieldElement coeff1 = (RealFieldElement)s.multiply((Object)((RealFieldElement)((RealFieldElement)fourTheta2.subtract((Object)((RealFieldElement)theta.multiply(9)))).add(6.0)));
            RealFieldElement coeff23 = (RealFieldElement)s.multiply((Object)((RealFieldElement)((RealFieldElement)theta.multiply(6)).subtract((Object)fourTheta2)));
            RealFieldElement coeff4 = (RealFieldElement)s.multiply((Object)((RealFieldElement)fourTheta2.subtract((Object)((RealFieldElement)theta.multiply(3)))));
            interpolatedState = this.previousStateLinearCombination(new RealFieldElement[]{coeff1, coeff23, coeff23, coeff4});
            interpolatedDerivatives = this.derivativeLinearCombination(new RealFieldElement[]{coeffDot1, coeffDot23, coeffDot23, coeffDot4});
        } else {
            RealFieldElement fourTheta = (RealFieldElement)theta.multiply(4);
            RealFieldElement s = (RealFieldElement)oneMinusThetaH.divide(6.0);
            RealFieldElement coeff1 = (RealFieldElement)s.multiply((Object)((RealFieldElement)((RealFieldElement)theta.multiply((Object)((RealFieldElement)((RealFieldElement)fourTheta.negate()).add(5.0)))).subtract(1.0)));
            RealFieldElement coeff23 = (RealFieldElement)s.multiply((Object)((RealFieldElement)((RealFieldElement)theta.multiply((Object)((RealFieldElement)fourTheta.subtract(2.0)))).subtract(2.0)));
            RealFieldElement coeff4 = (RealFieldElement)s.multiply((Object)((RealFieldElement)((RealFieldElement)theta.multiply((Object)((RealFieldElement)((RealFieldElement)fourTheta.negate()).subtract(1.0)))).subtract(1.0)));
            interpolatedState = this.currentStateLinearCombination(new RealFieldElement[]{coeff1, coeff23, coeff23, coeff4});
            interpolatedDerivatives = this.derivativeLinearCombination(new RealFieldElement[]{coeffDot1, coeffDot23, coeffDot23, coeffDot4});
        }
        return new FieldODEStateAndDerivative(time, interpolatedState, interpolatedDerivatives);
    }
}

