/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.release.plugin;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.codehaus.plexus.util.FileUtils;

public final class SharedFunctions {
    public static final int BUFFER_BYTE_SIZE = 1024;

    public static void copyFile(Log log, File fromFile, File toFile) throws MojoExecutionException {
        String format = "Unable to copy file %s to %s: %s";
        SharedFunctions.requireNonNull(fromFile, () -> String.format("Unable to copy file %s to %s: %s", fromFile, toFile));
        SharedFunctions.requireNonNull(toFile, () -> String.format("Unable to copy file %s to %s: %s", fromFile, toFile));
        try {
            FileUtils.copyFile((File)fromFile, (File)toFile);
        }
        catch (IOException e) {
            String message = String.format("Unable to copy file %s to %s: %s", fromFile, toFile, e.getMessage());
            log.error((CharSequence)message);
            throw new MojoExecutionException(message, (Exception)e);
        }
    }

    public static void initDirectory(Log log, File workingDirectory) throws MojoExecutionException {
        String format = "Unable to remove directory %s: %s";
        SharedFunctions.requireNonNull(workingDirectory, () -> String.format("Unable to remove directory %s: %s", workingDirectory));
        if (workingDirectory.exists()) {
            try {
                FileUtils.deleteDirectory((File)workingDirectory);
            }
            catch (IOException e) {
                String message = String.format("Unable to remove directory %s: %s", workingDirectory, e.getMessage());
                log.error((CharSequence)message);
                throw new MojoExecutionException(message, (Exception)e);
            }
        }
        if (!workingDirectory.exists()) {
            workingDirectory.mkdirs();
        }
    }

    public static <T> T requireNonNull(T obj) throws MojoExecutionException {
        if (obj == null) {
            throw new MojoExecutionException((Throwable)new NullPointerException());
        }
        return obj;
    }

    public static <T> T requireNonNull(T obj, String message) throws MojoExecutionException {
        if (obj == null) {
            throw new MojoExecutionException((Throwable)new NullPointerException(message));
        }
        return obj;
    }

    public static <T> T requireNonNull(T obj, Supplier<String> messageSupplier) throws MojoExecutionException {
        if (obj == null) {
            throw new MojoExecutionException((Throwable)new NullPointerException(messageSupplier.get()));
        }
        return obj;
    }

    public static void setAuthentication(ScmProviderRepository providerRepository, String distServer, Settings settings, SettingsDecrypter settingsDecrypter, String username, String password) {
        Optional<Server> server = Optional.ofNullable(distServer).map(arg_0 -> ((Settings)settings).getServer(arg_0)).map(DefaultSettingsDecryptionRequest::new).map(arg_0 -> ((SettingsDecrypter)settingsDecrypter).decrypt(arg_0)).map(SettingsDecryptionResult::getServer);
        providerRepository.setUser(server.map(Server::getUsername).orElse(username));
        providerRepository.setPassword(server.map(Server::getPassword).orElse(password));
    }

    private SharedFunctions() {
    }
}

