/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.clustering.circuitbreaker;

import org.apache.cxf.clustering.CircuitBreakerTargetSelector;
import org.apache.cxf.clustering.FailoverFeature;
import org.apache.cxf.clustering.FailoverTargetSelector;

public class CircuitBreakerFailoverFeature
extends FailoverFeature {
    public CircuitBreakerFailoverFeature() {
        this(1, 60000L);
    }

    public CircuitBreakerFailoverFeature(String clientBootstrapAddress) {
        this(1, 60000L, clientBootstrapAddress);
    }

    public CircuitBreakerFailoverFeature(int threshold, long timeout) {
        super(new Portable(threshold, timeout));
    }

    public CircuitBreakerFailoverFeature(int threshold, long timeout, String clientBootstrapAddress) {
        super(new Portable(threshold, timeout, clientBootstrapAddress));
    }

    @Override
    public FailoverTargetSelector getTargetSelector() {
        return ((FailoverFeature.Portable)this.delegate).getTargetSelector();
    }

    @Override
    public void setTargetSelector(FailoverTargetSelector targetSelector) {
        ((FailoverFeature.Portable)this.delegate).setTargetSelector(targetSelector);
    }

    public int getThreshold() {
        return ((Portable)Portable.class.cast(this.delegate)).getThreshold();
    }

    public long getTimeout() {
        return ((Portable)Portable.class.cast(this.delegate)).getTimeout();
    }

    public void setThreshold(int threshold) {
        ((Portable)Portable.class.cast(this.delegate)).setThreshold(threshold);
    }

    public void setTimeout(long timeout) {
        ((Portable)Portable.class.cast(this.delegate)).setTimeout(timeout);
    }

    public static class Portable
    extends FailoverFeature.Portable {
        private int threshold;
        private long timeout;
        private FailoverTargetSelector targetSelector;

        public Portable() {
            this(1, 60000L);
        }

        public Portable(String clientBootstrapAddress) {
            this(1, 60000L, clientBootstrapAddress);
        }

        public Portable(int threshold, long timeout) {
            this.threshold = threshold;
            this.timeout = timeout;
        }

        public Portable(int threshold, long timeout, String clientBootstrapAddress) {
            super(clientBootstrapAddress);
            this.threshold = threshold;
            this.timeout = timeout;
        }

        @Override
        public FailoverTargetSelector getTargetSelector() {
            if (this.targetSelector == null) {
                this.targetSelector = new CircuitBreakerTargetSelector(this.threshold, this.timeout, super.getClientBootstrapAddress());
            }
            return this.targetSelector;
        }

        @Override
        public void setTargetSelector(FailoverTargetSelector targetSelector) {
            this.targetSelector = targetSelector;
        }

        public int getThreshold() {
            return this.threshold;
        }

        public long getTimeout() {
            return this.timeout;
        }

        public void setThreshold(int threshold) {
            this.threshold = threshold;
        }

        public void setTimeout(long timeout) {
            this.timeout = timeout;
        }
    }
}

