/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config.amqpBrokerConnectivity;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionAddressType;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPFederationAddressPolicyElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPFederationQueuePolicyElement;

public class AMQPFederatedBrokerConnectionElement
extends AMQPBrokerConnectionElement {
    private static final long serialVersionUID = -6701394020085679414L;
    private Set<AMQPFederationAddressPolicyElement> remoteAddressPolicies = new HashSet<AMQPFederationAddressPolicyElement>();
    private Set<AMQPFederationQueuePolicyElement> remoteQueuePolicies = new HashSet<AMQPFederationQueuePolicyElement>();
    private Set<AMQPFederationAddressPolicyElement> localAddressPolicies = new HashSet<AMQPFederationAddressPolicyElement>();
    private Set<AMQPFederationQueuePolicyElement> localQueuePolicies = new HashSet<AMQPFederationQueuePolicyElement>();
    private Map<String, Object> properties = new HashMap<String, Object>();

    public AMQPFederatedBrokerConnectionElement() {
        this.setType(AMQPBrokerConnectionAddressType.FEDERATION);
    }

    public AMQPFederatedBrokerConnectionElement(String name) {
        this.setType(AMQPBrokerConnectionAddressType.FEDERATION);
        this.setName(name);
    }

    @Override
    public AMQPFederatedBrokerConnectionElement setType(AMQPBrokerConnectionAddressType type) {
        if (!AMQPBrokerConnectionAddressType.FEDERATION.equals((Object)type)) {
            throw new IllegalArgumentException("Cannot change the type for this broker connection element");
        }
        return (AMQPFederatedBrokerConnectionElement)super.setType(type);
    }

    public Set<AMQPFederationAddressPolicyElement> getRemoteAddressPolicies() {
        return this.remoteAddressPolicies;
    }

    public AMQPFederatedBrokerConnectionElement addRemoteAddressPolicy(AMQPFederationAddressPolicyElement remoteAddressPolicy) {
        this.remoteAddressPolicies.add(remoteAddressPolicy);
        return this;
    }

    public Set<AMQPFederationQueuePolicyElement> getRemoteQueuePolicies() {
        return this.remoteQueuePolicies;
    }

    public AMQPFederatedBrokerConnectionElement addRemoteQueuePolicy(AMQPFederationQueuePolicyElement remoteQueuePolicy) {
        this.remoteQueuePolicies.add(remoteQueuePolicy);
        return this;
    }

    public Set<AMQPFederationAddressPolicyElement> getLocalAddressPolicies() {
        return this.localAddressPolicies;
    }

    public AMQPFederatedBrokerConnectionElement addLocalAddressPolicy(AMQPFederationAddressPolicyElement localAddressPolicy) {
        this.localAddressPolicies.add(localAddressPolicy);
        return this;
    }

    public Set<AMQPFederationQueuePolicyElement> getLocalQueuePolicies() {
        return this.localQueuePolicies;
    }

    public AMQPFederatedBrokerConnectionElement addLocalQueuePolicy(AMQPFederationQueuePolicyElement localQueuePolicy) {
        this.localQueuePolicies.add(localQueuePolicy);
        return this;
    }

    public AMQPFederatedBrokerConnectionElement addProperty(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    public AMQPFederatedBrokerConnectionElement addProperty(String key, Number value) {
        this.properties.put(key, value);
        return this;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }
}

