/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.logs;

import java.security.AccessController;
import java.security.Principal;
import java.util.Arrays;
import java.util.Set;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import org.apache.activemq.artemis.logs.BundleFactory;
import org.slf4j.Logger;

public interface AuditLogger {
    public static final AuditLogger BASE_LOGGER = BundleFactory.newBundle(AuditLogger.class, "org.apache.activemq.audit.base");
    public static final AuditLogger RESOURCE_LOGGER = BundleFactory.newBundle(AuditLogger.class, "org.apache.activemq.audit.resource");
    public static final AuditLogger MESSAGE_LOGGER = BundleFactory.newBundle(AuditLogger.class, "org.apache.activemq.audit.message");
    public static final ThreadLocal<String> remoteAddress = new ThreadLocal();
    public static final ThreadLocal<Subject> currentCaller = new ThreadLocal();

    public Logger getLogger();

    public static boolean isAnyLoggingEnabled() {
        return AuditLogger.isBaseLoggingEnabled() || AuditLogger.isMessageLoggingEnabled() || AuditLogger.isResourceLoggingEnabled();
    }

    public static boolean isBaseLoggingEnabled() {
        return BASE_LOGGER.getLogger().isInfoEnabled();
    }

    public static boolean isResourceLoggingEnabled() {
        return RESOURCE_LOGGER.getLogger().isInfoEnabled();
    }

    public static boolean isMessageLoggingEnabled() {
        return MESSAGE_LOGGER.getLogger().isInfoEnabled();
    }

    public static String getCaller() {
        Subject subject = Subject.getSubject(AccessController.getContext());
        if (subject == null) {
            subject = currentCaller.get();
        }
        return AuditLogger.getCaller(subject, null);
    }

    public static String getCaller(Subject subject, String remoteAddress) {
        String url;
        String user = "anonymous";
        Object roles = "";
        String string = remoteAddress == null ? (AuditLogger.remoteAddress.get() == null ? "@unknown" : AuditLogger.remoteAddress.get()) : (url = AuditLogger.formatRemoteAddress(remoteAddress));
        if (subject != null) {
            Set<Principal> principals = subject.getPrincipals();
            for (Principal principal : principals) {
                if (principal.getClass().getName().endsWith("UserPrincipal")) {
                    user = principal.getName();
                    continue;
                }
                if (!principal.getClass().getName().endsWith("RolePrincipal")) continue;
                roles = "(" + principal.getName() + ")";
            }
        }
        return user + (String)roles + url;
    }

    public static void setCurrentCaller(Subject caller) {
        currentCaller.set(caller);
    }

    public static void setRemoteAddress(String remoteAddress) {
        AuditLogger.remoteAddress.set(AuditLogger.formatRemoteAddress(remoteAddress));
    }

    public static String formatRemoteAddress(String remoteAddress) {
        String actualAddress = remoteAddress.startsWith("/") ? "@" + remoteAddress.substring(1) : "@" + remoteAddress;
        return actualAddress;
    }

    public static String getRemoteAddress() {
        return remoteAddress.get();
    }

    public static String parametersList(Object value) {
        if (value == null) {
            return "";
        }
        String prefix = "with parameters: ";
        if (value instanceof long[]) {
            return "with parameters: " + Arrays.toString((long[])value);
        }
        if (value instanceof int[]) {
            return "with parameters: " + Arrays.toString((int[])value);
        }
        if (value instanceof char[]) {
            return "with parameters: " + Arrays.toString((char[])value);
        }
        if (value instanceof byte[]) {
            return "with parameters: " + Arrays.toString((byte[])value);
        }
        if (value instanceof float[]) {
            return "with parameters: " + Arrays.toString((float[])value);
        }
        if (value instanceof short[]) {
            return "with parameters: " + Arrays.toString((short[])value);
        }
        if (value instanceof double[]) {
            return "with parameters: " + Arrays.toString((double[])value);
        }
        if (value instanceof boolean[]) {
            return "with parameters: " + Arrays.toString((boolean[])value);
        }
        if (value instanceof Object[]) {
            return "with parameters: " + Arrays.toString((Object[])value);
        }
        return "with parameters: " + value.toString();
    }

    public static void getRoutingTypes(Object source) {
        BASE_LOGGER.getRoutingTypes(AuditLogger.getCaller(), source);
    }

    public void getRoutingTypes(String var1, Object var2);

    public static void getRoutingTypesAsJSON(Object source) {
        BASE_LOGGER.getRoutingTypesAsJSON(AuditLogger.getCaller(), source);
    }

    public void getRoutingTypesAsJSON(String var1, Object var2);

    public static void getQueueNames(Object source, Object ... args) {
        BASE_LOGGER.getQueueNames(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void getQueueNames(String var1, Object var2, String var3);

    public static void getBindingNames(Object source) {
        BASE_LOGGER.getBindingNames(AuditLogger.getCaller(), source);
    }

    public void getBindingNames(String var1, Object var2);

    public static void getRoles(Object source, Object ... args) {
        BASE_LOGGER.getRoles(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void getRoles(String var1, Object var2, String var3);

    public static void getRolesAsJSON(Object source, Object ... args) {
        BASE_LOGGER.getRolesAsJSON(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void getRolesAsJSON(String var1, Object var2, String var3);

    public static void getNumberOfBytesPerPage(Object source) {
        BASE_LOGGER.getNumberOfBytesPerPage(AuditLogger.getCaller(), source);
    }

    public void getNumberOfBytesPerPage(String var1, Object var2);

    public static void getAddressSize(Object source) {
        BASE_LOGGER.getAddressSize(AuditLogger.getCaller(), source);
    }

    public void getAddressSize(String var1, Object var2);

    public static void getNumberOfMessages(Object source) {
        BASE_LOGGER.getNumberOfMessages(AuditLogger.getCaller(), source);
    }

    public void getNumberOfMessages(String var1, Object var2);

    public static void isPaging(Object source) {
        BASE_LOGGER.isPaging(AuditLogger.getCaller(), source);
    }

    public void isPaging(String var1, Object var2);

    public static void getNumberOfPages(Object source) {
        BASE_LOGGER.getNumberOfPages(AuditLogger.getCaller(), source);
    }

    public void getNumberOfPages(String var1, Object var2);

    public static void getRoutedMessageCount(Object source) {
        BASE_LOGGER.getRoutedMessageCount(AuditLogger.getCaller(), source);
    }

    public void getRoutedMessageCount(String var1, Object var2);

    public static void getUnRoutedMessageCount(Object source) {
        BASE_LOGGER.getUnRoutedMessageCount(AuditLogger.getCaller(), source);
    }

    public void getUnRoutedMessageCount(String var1, Object var2);

    public static void sendMessageThroughManagement(Object source, Object ... args) {
        BASE_LOGGER.sendMessageThroughManagement(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void sendMessageThroughManagement(String var1, Object var2, String var3);

    public static void getName(Object source) {
        BASE_LOGGER.getName(AuditLogger.getCaller(), source);
    }

    public void getName(String var1, Object var2);

    public static void getAddress(Object source) {
        BASE_LOGGER.getAddress(AuditLogger.getCaller(), source);
    }

    public void getAddress(String var1, Object var2);

    public static void getFilter(Object source) {
        BASE_LOGGER.getFilter(AuditLogger.getCaller(), source);
    }

    public void getFilter(String var1, Object var2);

    public static void isDurable(Object source) {
        BASE_LOGGER.isDurable(AuditLogger.getCaller(), source);
    }

    public void isDurable(String var1, Object var2);

    public static void getMessageCount(Object source) {
        BASE_LOGGER.getMessageCount(AuditLogger.getCaller(), source);
    }

    public void getMessageCount(String var1, Object var2);

    public static void getMBeanInfo(Object source) {
        BASE_LOGGER.getMBeanInfo(AuditLogger.getCaller(), source);
    }

    public void getMBeanInfo(String var1, Object var2);

    public static void getFactoryClassName(Object source) {
        BASE_LOGGER.getFactoryClassName(AuditLogger.getCaller(), source);
    }

    public void getFactoryClassName(String var1, Object var2);

    public static void getParameters(Object source) {
        BASE_LOGGER.getParameters(AuditLogger.getCaller(), source);
    }

    public void getParameters(String var1, Object var2);

    public static void reload(Object source) {
        BASE_LOGGER.reload(AuditLogger.getCaller(), source);
    }

    public void reload(String var1, Object var2);

    public static void isStarted(Object source) {
        BASE_LOGGER.isStarted(AuditLogger.getCaller(), source);
    }

    public void isStarted(String var1, Object var2);

    public static void startAcceptor(Object source) {
        BASE_LOGGER.startAcceptor(AuditLogger.getCaller(), source);
    }

    public void startAcceptor(String var1, Object var2);

    public static void stopAcceptor(Object source) {
        BASE_LOGGER.stopAcceptor(AuditLogger.getCaller(), source);
    }

    public void stopAcceptor(String var1, Object var2);

    public static void getVersion(Object source) {
        BASE_LOGGER.getVersion(AuditLogger.getCaller(), source);
    }

    public void getVersion(String var1, Object var2);

    public static void isBackup(Object source) {
        BASE_LOGGER.isBackup(AuditLogger.getCaller(), source);
    }

    public void isBackup(String var1, Object var2);

    public static void isSharedStore(Object source) {
        BASE_LOGGER.isSharedStore(AuditLogger.getCaller(), source);
    }

    public void isSharedStore(String var1, Object var2);

    public static void getBindingsDirectory(Object source) {
        BASE_LOGGER.getBindingsDirectory(AuditLogger.getCaller(), source);
    }

    public void getBindingsDirectory(String var1, Object var2);

    public static void getIncomingInterceptorClassNames(Object source) {
        BASE_LOGGER.getIncomingInterceptorClassNames(AuditLogger.getCaller(), source);
    }

    public void getIncomingInterceptorClassNames(String var1, Object var2);

    public static void getOutgoingInterceptorClassNames(Object source) {
        BASE_LOGGER.getOutgoingInterceptorClassNames(AuditLogger.getCaller(), source);
    }

    public void getOutgoingInterceptorClassNames(String var1, Object var2);

    public static void getJournalBufferSize(Object source) {
        BASE_LOGGER.getJournalBufferSize(AuditLogger.getCaller(), source);
    }

    public void getJournalBufferSize(String var1, Object var2);

    public static void getJournalBufferTimeout(Object source) {
        BASE_LOGGER.getJournalBufferTimeout(AuditLogger.getCaller(), source);
    }

    public void getJournalBufferTimeout(String var1, Object var2);

    public static void setFailoverOnServerShutdown(Object source, Object ... args) {
        BASE_LOGGER.setFailoverOnServerShutdown(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void setFailoverOnServerShutdown(String var1, Object var2, String var3);

    public static void isFailoverOnServerShutdown(Object source) {
        BASE_LOGGER.isFailoverOnServerShutdown(AuditLogger.getCaller(), source);
    }

    public void isFailoverOnServerShutdown(String var1, Object var2);

    public static void getJournalMaxIO(Object source) {
        BASE_LOGGER.getJournalMaxIO(AuditLogger.getCaller(), source);
    }

    public void getJournalMaxIO(String var1, Object var2);

    public static void getJournalDirectory(Object source) {
        BASE_LOGGER.getJournalDirectory(AuditLogger.getCaller(), source);
    }

    public void getJournalDirectory(String var1, Object var2);

    public static void getJournalFileSize(Object source) {
        BASE_LOGGER.getJournalFileSize(AuditLogger.getCaller(), source);
    }

    public void getJournalFileSize(String var1, Object var2);

    public static void getJournalMinFiles(Object source) {
        BASE_LOGGER.getJournalMinFiles(AuditLogger.getCaller(), source);
    }

    public void getJournalMinFiles(String var1, Object var2);

    public static void getJournalCompactMinFiles(Object source) {
        BASE_LOGGER.getJournalCompactMinFiles(AuditLogger.getCaller(), source);
    }

    public void getJournalCompactMinFiles(String var1, Object var2);

    public static void getJournalCompactPercentage(Object source) {
        BASE_LOGGER.getJournalCompactPercentage(AuditLogger.getCaller(), source);
    }

    public void getJournalCompactPercentage(String var1, Object var2);

    public static void isPersistenceEnabled(Object source) {
        BASE_LOGGER.isPersistenceEnabled(AuditLogger.getCaller(), source);
    }

    public void isPersistenceEnabled(String var1, Object var2);

    public static void getJournalType(Object source) {
        BASE_LOGGER.getJournalType(AuditLogger.getCaller(), source);
    }

    public void getJournalType(String var1, Object var2);

    public static void getPagingDirectory(Object source) {
        BASE_LOGGER.getPagingDirectory(AuditLogger.getCaller(), source);
    }

    public void getPagingDirectory(String var1, Object var2);

    public static void getScheduledThreadPoolMaxSize(Object source) {
        BASE_LOGGER.getScheduledThreadPoolMaxSize(AuditLogger.getCaller(), source);
    }

    public void getScheduledThreadPoolMaxSize(String var1, Object var2);

    public static void getThreadPoolMaxSize(Object source) {
        BASE_LOGGER.getThreadPoolMaxSize(AuditLogger.getCaller(), source);
    }

    public void getThreadPoolMaxSize(String var1, Object var2);

    public static void getSecurityInvalidationInterval(Object source) {
        BASE_LOGGER.getSecurityInvalidationInterval(AuditLogger.getCaller(), source);
    }

    public void getSecurityInvalidationInterval(String var1, Object var2);

    public static void isClustered(Object source) {
        BASE_LOGGER.isClustered(AuditLogger.getCaller(), source);
    }

    public void isClustered(String var1, Object var2);

    public static void isCreateBindingsDir(Object source) {
        BASE_LOGGER.isCreateBindingsDir(AuditLogger.getCaller(), source);
    }

    public void isCreateBindingsDir(String var1, Object var2);

    public static void isCreateJournalDir(Object source) {
        BASE_LOGGER.isCreateJournalDir(AuditLogger.getCaller(), source);
    }

    public void isCreateJournalDir(String var1, Object var2);

    public static void isJournalSyncNonTransactional(Object source) {
        BASE_LOGGER.isJournalSyncNonTransactional(AuditLogger.getCaller(), source);
    }

    public void isJournalSyncNonTransactional(String var1, Object var2);

    public static void isJournalSyncTransactional(Object source) {
        BASE_LOGGER.isJournalSyncTransactional(AuditLogger.getCaller(), source);
    }

    public void isJournalSyncTransactional(String var1, Object var2);

    public static void isSecurityEnabled(Object source) {
        BASE_LOGGER.isSecurityEnabled(AuditLogger.getCaller(), source);
    }

    public void isSecurityEnabled(String var1, Object var2);

    public static void isAsyncConnectionExecutionEnabled(Object source) {
        BASE_LOGGER.isAsyncConnectionExecutionEnabled(AuditLogger.getCaller(), source);
    }

    public void isAsyncConnectionExecutionEnabled(String var1, Object var2);

    public static void getDiskScanPeriod(Object source) {
        BASE_LOGGER.getDiskScanPeriod(AuditLogger.getCaller(), source);
    }

    public void getDiskScanPeriod(String var1, Object var2);

    public static void getMaxDiskUsage(Object source) {
        BASE_LOGGER.getMaxDiskUsage(AuditLogger.getCaller(), source);
    }

    public void getMaxDiskUsage(String var1, Object var2);

    public static void getGlobalMaxSize(Object source) {
        BASE_LOGGER.getGlobalMaxSize(AuditLogger.getCaller(), source);
    }

    public void getGlobalMaxSize(String var1, Object var2);

    public static void getAddressMemoryUsage(Object source) {
        BASE_LOGGER.getAddressMemoryUsage(AuditLogger.getCaller(), source);
    }

    public void getAddressMemoryUsage(String var1, Object var2);

    public static void getAddressMemoryUsagePercentage(Object source) {
        BASE_LOGGER.getAddressMemoryUsagePercentage(AuditLogger.getCaller(), source);
    }

    public void getAddressMemoryUsagePercentage(String var1, Object var2);

    public static void freezeReplication(Object source) {
        BASE_LOGGER.freezeReplication(AuditLogger.getCaller(), source);
    }

    public void freezeReplication(String var1, Object var2);

    public static void createAddress(Object source, Object ... args) {
        BASE_LOGGER.createAddress(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void createAddress(String var1, Object var2, String var3);

    public static void updateAddress(Object source, Object ... args) {
        BASE_LOGGER.updateAddress(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void updateAddress(String var1, Object var2, String var3);

    public static void deleteAddress(Object source, Object ... args) {
        BASE_LOGGER.deleteAddress(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void deleteAddress(String var1, Object var2, String var3);

    public static void deployQueue(Object source, Object ... args) {
        BASE_LOGGER.deployQueue(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void deployQueue(String var1, Object var2, String var3);

    public static void createQueue(Object source, Subject user, String remoteAddress, Object ... args) {
        RESOURCE_LOGGER.createQueue(AuditLogger.getCaller(user, remoteAddress), source, AuditLogger.parametersList(args));
    }

    public void createQueue(String var1, Object var2, String var3);

    public static void updateQueue(Object source, Object ... args) {
        BASE_LOGGER.updateQueue(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void updateQueue(String var1, Object var2, String var3);

    public static void getClusterConnectionNames(Object source) {
        BASE_LOGGER.getClusterConnectionNames(AuditLogger.getCaller(), source);
    }

    public void getClusterConnectionNames(String var1, Object var2);

    public static void getUptime(Object source) {
        BASE_LOGGER.getUptime(AuditLogger.getCaller(), source);
    }

    public void getUptime(String var1, Object var2);

    public static void getUptimeMillis(Object source) {
        BASE_LOGGER.getUptimeMillis(AuditLogger.getCaller(), source);
    }

    public void getUptimeMillis(String var1, Object var2);

    public static void isReplicaSync(Object source) {
        BASE_LOGGER.isReplicaSync(AuditLogger.getCaller(), source);
    }

    public void isReplicaSync(String var1, Object var2);

    public static void getAddressNames(Object source) {
        BASE_LOGGER.getAddressNames(AuditLogger.getCaller(), source);
    }

    public void getAddressNames(String var1, Object var2);

    public static void destroyQueue(Object source, Subject user, String remoteAddress, Object ... args) {
        BASE_LOGGER.destroyQueue(AuditLogger.getCaller(user, remoteAddress), source, AuditLogger.parametersList(args));
    }

    public void destroyQueue(String var1, Object var2, String var3);

    public static void getAddressInfo(Object source, Object ... args) {
        BASE_LOGGER.getAddressInfo(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void getAddressInfo(String var1, Object var2, String var3);

    public static void listBindingsForAddress(Object source, Object ... args) {
        BASE_LOGGER.listBindingsForAddress(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void listBindingsForAddress(String var1, Object var2, String var3);

    public static void listAddresses(Object source, Object ... args) {
        BASE_LOGGER.listAddresses(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void listAddresses(String var1, Object var2, String var3);

    public static void getConnectionCount(Object source, Object ... args) {
        BASE_LOGGER.getConnectionCount(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void getConnectionCount(String var1, Object var2, String var3);

    public static void getTotalConnectionCount(Object source) {
        BASE_LOGGER.getTotalConnectionCount(AuditLogger.getCaller(), source);
    }

    public void getTotalConnectionCount(String var1, Object var2);

    public static void getTotalMessageCount(Object source) {
        BASE_LOGGER.getTotalMessageCount(AuditLogger.getCaller(), source);
    }

    public void getTotalMessageCount(String var1, Object var2);

    public static void getTotalMessagesAdded(Object source) {
        BASE_LOGGER.getTotalMessagesAdded(AuditLogger.getCaller(), source);
    }

    public void getTotalMessagesAdded(String var1, Object var2);

    public static void getTotalMessagesAcknowledged(Object source) {
        BASE_LOGGER.getTotalMessagesAcknowledged(AuditLogger.getCaller(), source);
    }

    public void getTotalMessagesAcknowledged(String var1, Object var2);

    public static void getTotalConsumerCount(Object source) {
        BASE_LOGGER.getTotalConsumerCount(AuditLogger.getCaller(), source);
    }

    public void getTotalConsumerCount(String var1, Object var2);

    public static void enableMessageCounters(Object source) {
        BASE_LOGGER.enableMessageCounters(AuditLogger.getCaller(), source);
    }

    public void enableMessageCounters(String var1, Object var2);

    public static void disableMessageCounters(Object source) {
        BASE_LOGGER.disableMessageCounters(AuditLogger.getCaller(), source);
    }

    public void disableMessageCounters(String var1, Object var2);

    public static void resetAllMessageCounters(Object source) {
        BASE_LOGGER.resetAllMessageCounters(AuditLogger.getCaller(), source);
    }

    public void resetAllMessageCounters(String var1, Object var2);

    public static void resetAllMessageCounterHistories(Object source) {
        BASE_LOGGER.resetAllMessageCounterHistories(AuditLogger.getCaller(), source);
    }

    public void resetAllMessageCounterHistories(String var1, Object var2);

    public static void isMessageCounterEnabled(Object source) {
        BASE_LOGGER.isMessageCounterEnabled(AuditLogger.getCaller(), source);
    }

    public void isMessageCounterEnabled(String var1, Object var2);

    public static void getMessageCounterSamplePeriod(Object source) {
        BASE_LOGGER.getMessageCounterSamplePeriod(AuditLogger.getCaller(), source);
    }

    public void getMessageCounterSamplePeriod(String var1, Object var2);

    public static void setMessageCounterSamplePeriod(Object source, Object ... args) {
        BASE_LOGGER.setMessageCounterSamplePeriod(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void setMessageCounterSamplePeriod(String var1, Object var2, String var3);

    public static void getMessageCounterMaxDayCount(Object source) {
        BASE_LOGGER.getMessageCounterMaxDayCount(AuditLogger.getCaller(), source);
    }

    public void getMessageCounterMaxDayCount(String var1, Object var2);

    public static void setMessageCounterMaxDayCount(Object source, Object ... args) {
        BASE_LOGGER.setMessageCounterMaxDayCount(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void setMessageCounterMaxDayCount(String var1, Object var2, String var3);

    public static void listPreparedTransactions(Object source) {
        BASE_LOGGER.listPreparedTransactions(AuditLogger.getCaller(), source);
    }

    public void listPreparedTransactions(String var1, Object var2);

    public static void listPreparedTransactionDetailsAsJSON(Object source) {
        BASE_LOGGER.listPreparedTransactionDetailsAsJSON(AuditLogger.getCaller(), source);
    }

    public void listPreparedTransactionDetailsAsJSON(String var1, Object var2);

    public static void listPreparedTransactionDetailsAsHTML(Object source, Object ... args) {
        BASE_LOGGER.listPreparedTransactionDetailsAsHTML(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void listPreparedTransactionDetailsAsHTML(String var1, Object var2, String var3);

    public static void listHeuristicCommittedTransactions(Object source) {
        BASE_LOGGER.listHeuristicCommittedTransactions(AuditLogger.getCaller(), source);
    }

    public void listHeuristicCommittedTransactions(String var1, Object var2);

    public static void listHeuristicRolledBackTransactions(Object source) {
        BASE_LOGGER.listHeuristicRolledBackTransactions(AuditLogger.getCaller(), source);
    }

    public void listHeuristicRolledBackTransactions(String var1, Object var2);

    public static void commitPreparedTransaction(Object source, Object ... args) {
        BASE_LOGGER.commitPreparedTransaction(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void commitPreparedTransaction(String var1, Object var2, String var3);

    public static void rollbackPreparedTransaction(Object source, Object ... args) {
        BASE_LOGGER.rollbackPreparedTransaction(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void rollbackPreparedTransaction(String var1, Object var2, String var3);

    public static void listRemoteAddresses(Object source, Object ... args) {
        BASE_LOGGER.listRemoteAddresses(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void listRemoteAddresses(String var1, Object var2, String var3);

    public static void closeConnectionsForAddress(Object source, Object ... args) {
        BASE_LOGGER.closeConnectionsForAddress(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void closeConnectionsForAddress(String var1, Object var2, String var3);

    public static void closeConsumerConnectionsForAddress(Object source, Object ... args) {
        BASE_LOGGER.closeConsumerConnectionsForAddress(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void closeConsumerConnectionsForAddress(String var1, Object var2, String var3);

    public static void closeConnectionsForUser(Object source, Object ... args) {
        BASE_LOGGER.closeConnectionsForUser(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void closeConnectionsForUser(String var1, Object var2, String var3);

    public static void closeConnectionWithID(Object source, Object ... args) {
        BASE_LOGGER.closeConnectionWithID(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void closeConnectionWithID(String var1, Object var2, String var3);

    public static void closeSessionWithID(Object source, Object ... args) {
        BASE_LOGGER.closeSessionWithID(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void closeSessionWithID(String var1, Object var2, String var3);

    public static void closeConsumerWithID(Object source, Object ... args) {
        BASE_LOGGER.closeConsumerWithID(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void closeConsumerWithID(String var1, Object var2, String var3);

    public static void listConnectionIDs(Object source) {
        BASE_LOGGER.listConnectionIDs(AuditLogger.getCaller(), source);
    }

    public void listConnectionIDs(String var1, Object var2);

    public static void listSessions(Object source, Object ... args) {
        BASE_LOGGER.listSessions(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void listSessions(String var1, Object var2, String var3);

    public static void listProducersInfoAsJSON(Object source) {
        BASE_LOGGER.listProducersInfoAsJSON(AuditLogger.getCaller(), source);
    }

    public void listProducersInfoAsJSON(String var1, Object var2);

    public static void listConnections(Object source, Object ... args) {
        BASE_LOGGER.listConnections(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void listConnections(String var1, Object var2, String var3);

    public static void listConsumers(Object source, Object ... args) {
        BASE_LOGGER.listConsumers(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void listConsumers(String var1, Object var2, String var3);

    public static void listQueues(Object source, Object ... args) {
        BASE_LOGGER.listQueues(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void listQueues(String var1, Object var2, String var3);

    public static void listProducers(Object source, Object ... args) {
        BASE_LOGGER.listProducers(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void listProducers(String var1, Object var2, String var3);

    public static void listConnectionsAsJSON(Object source) {
        BASE_LOGGER.listConnectionsAsJSON(AuditLogger.getCaller(), source);
    }

    public void listConnectionsAsJSON(String var1, Object var2);

    public static void listSessionsAsJSON(Object source, Object ... args) {
        BASE_LOGGER.listSessionsAsJSON(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void listSessionsAsJSON(String var1, Object var2, String var3);

    public static void listAllSessionsAsJSON(Object source) {
        BASE_LOGGER.listAllSessionsAsJSON(AuditLogger.getCaller(), source);
    }

    public void listAllSessionsAsJSON(String var1, Object var2);

    public static void listConsumersAsJSON(Object source, Object ... args) {
        BASE_LOGGER.listConsumersAsJSON(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void listConsumersAsJSON(String var1, Object var2, String var3);

    public static void listAllConsumersAsJSON(Object source) {
        BASE_LOGGER.listAllConsumersAsJSON(AuditLogger.getCaller(), source);
    }

    public void listAllConsumersAsJSON(String var1, Object var2);

    public static void getConnectors(Object source) {
        BASE_LOGGER.getConnectors(AuditLogger.getCaller(), source);
    }

    public void getConnectors(String var1, Object var2);

    public static void getConnectorsAsJSON(Object source) {
        BASE_LOGGER.getConnectorsAsJSON(AuditLogger.getCaller(), source);
    }

    public void getConnectorsAsJSON(String var1, Object var2);

    public static void addSecuritySettings(Object source, Object ... args) {
        BASE_LOGGER.addSecuritySettings(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void addSecuritySettings(String var1, Object var2, String var3);

    public static void removeSecuritySettings(Object source, Object ... args) {
        BASE_LOGGER.removeSecuritySettings(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void removeSecuritySettings(String var1, Object var2, String var3);

    public static void getAddressSettingsAsJSON(Object source, Object ... args) {
        BASE_LOGGER.getAddressSettingsAsJSON(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void getAddressSettingsAsJSON(String var1, Object var2, String var3);

    public static void addAddressSettings(Object source, Object ... args) {
        BASE_LOGGER.addAddressSettings(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void addAddressSettings(String var1, Object var2, String var3);

    public static void removeAddressSettings(Object source, Object ... args) {
        BASE_LOGGER.removeAddressSettings(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void removeAddressSettings(String var1, Object var2, String var3);

    public static void getDivertNames(Object source) {
        BASE_LOGGER.getDivertNames(AuditLogger.getCaller(), source);
    }

    public void getDivertNames(String var1, Object var2);

    public static void createDivert(Object source, Object ... args) {
        BASE_LOGGER.createDivert(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void createDivert(String var1, Object var2, String var3);

    public static void destroyDivert(Object source, Object ... args) {
        BASE_LOGGER.destroyDivert(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void destroyDivert(String var1, Object var2, String var3);

    public static void getBridgeNames(Object source) {
        BASE_LOGGER.getBridgeNames(AuditLogger.getCaller(), source);
    }

    public void getBridgeNames(String var1, Object var2);

    public static void createBridge(Object source, Object ... args) {
        BASE_LOGGER.createBridge(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void createBridge(String var1, Object var2, String var3);

    public static void destroyBridge(Object source, Object ... args) {
        BASE_LOGGER.destroyBridge(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void destroyBridge(String var1, Object var2, String var3);

    public static void createConnectorService(Object source, Object ... args) {
        BASE_LOGGER.createConnectorService(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void createConnectorService(String var1, Object var2, String var3);

    public static void destroyConnectorService(Object source, Object ... args) {
        BASE_LOGGER.destroyConnectorService(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void destroyConnectorService(String var1, Object var2, String var3);

    public static void getConnectorServices(Object source, Object ... args) {
        BASE_LOGGER.getConnectorServices(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void getConnectorServices(String var1, Object var2, String var3);

    public static void forceFailover(Object source) {
        BASE_LOGGER.forceFailover(AuditLogger.getCaller(), source);
    }

    public void forceFailover(String var1, Object var2);

    public static void scaleDown(Object source, Object ... args) {
        BASE_LOGGER.scaleDown(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void scaleDown(String var1, Object var2, String var3);

    public static void listNetworkTopology(Object source) {
        BASE_LOGGER.listNetworkTopology(AuditLogger.getCaller(), source);
    }

    public void listNetworkTopology(String var1, Object var2);

    public static void removeNotificationListener(Object source, Object ... args) {
        BASE_LOGGER.removeNotificationListener(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void removeNotificationListener(String var1, Object var2, String var3);

    public static void addNotificationListener(Object source, Object ... args) {
        BASE_LOGGER.addNotificationListener(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void addNotificationListener(String var1, Object var2, String var3);

    public static void getNotificationInfo(Object source) {
        BASE_LOGGER.getNotificationInfo(AuditLogger.getCaller(), source);
    }

    public void getNotificationInfo(String var1, Object var2);

    public static void getConnectionTTLOverride(Object source) {
        BASE_LOGGER.getConnectionTTLOverride(AuditLogger.getCaller(), source);
    }

    public void getConnectionTTLOverride(String var1, Object var2);

    public static void getIDCacheSize(Object source) {
        BASE_LOGGER.getIDCacheSize(AuditLogger.getCaller(), source);
    }

    public void getIDCacheSize(String var1, Object var2);

    public static void getLargeMessagesDirectory(Object source) {
        BASE_LOGGER.getLargeMessagesDirectory(AuditLogger.getCaller(), source);
    }

    public void getLargeMessagesDirectory(String var1, Object var2);

    public static void getManagementAddress(Object source) {
        BASE_LOGGER.getManagementAddress(AuditLogger.getCaller(), source);
    }

    public void getManagementAddress(String var1, Object var2);

    public static void getNodeID(Object source) {
        BASE_LOGGER.getNodeID(AuditLogger.getCaller(), source);
    }

    public void getNodeID(String var1, Object var2);

    public static void getManagementNotificationAddress(Object source) {
        BASE_LOGGER.getManagementNotificationAddress(AuditLogger.getCaller(), source);
    }

    public void getManagementNotificationAddress(String var1, Object var2);

    public static void getMessageExpiryScanPeriod(Object source) {
        BASE_LOGGER.getMessageExpiryScanPeriod(AuditLogger.getCaller(), source);
    }

    public void getMessageExpiryScanPeriod(String var1, Object var2);

    public static void getMessageExpiryThreadPriority(Object source) {
        BASE_LOGGER.getMessageExpiryThreadPriority(AuditLogger.getCaller(), source);
    }

    public void getMessageExpiryThreadPriority(String var1, Object var2);

    public static void getTransactionTimeout(Object source) {
        BASE_LOGGER.getTransactionTimeout(AuditLogger.getCaller(), source);
    }

    public void getTransactionTimeout(String var1, Object var2);

    public static void getTransactionTimeoutScanPeriod(Object source) {
        BASE_LOGGER.getTransactionTimeoutScanPeriod(AuditLogger.getCaller(), source);
    }

    public void getTransactionTimeoutScanPeriod(String var1, Object var2);

    public static void isPersistDeliveryCountBeforeDelivery(Object source) {
        BASE_LOGGER.isPersistDeliveryCountBeforeDelivery(AuditLogger.getCaller(), source);
    }

    public void isPersistDeliveryCountBeforeDelivery(String var1, Object var2);

    public static void isPersistIDCache(Object source) {
        BASE_LOGGER.isPersistIDCache(AuditLogger.getCaller(), source);
    }

    public void isPersistIDCache(String var1, Object var2);

    public static void isWildcardRoutingEnabled(Object source) {
        BASE_LOGGER.isWildcardRoutingEnabled(AuditLogger.getCaller(), source);
    }

    public void isWildcardRoutingEnabled(String var1, Object var2);

    public static void addUser(Object source, Object ... args) {
        BASE_LOGGER.addUser(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void addUser(String var1, Object var2, String var3);

    public static void listUser(Object source, Object ... args) {
        BASE_LOGGER.listUser(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void listUser(String var1, Object var2, String var3);

    public static void removeUser(Object source, Object ... args) {
        BASE_LOGGER.removeUser(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void removeUser(String var1, Object var2, String var3);

    public static void resetUser(Object source, Object ... args) {
        BASE_LOGGER.resetUser(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void resetUser(String var1, Object var2, String var3);

    public static void getUser(Object source) {
        BASE_LOGGER.getUser(AuditLogger.getCaller(), source);
    }

    public void getUser(String var1, Object var2);

    public static void getRoutingType(Object source) {
        BASE_LOGGER.getRoutingType(AuditLogger.getCaller(), source);
    }

    public void getRoutingType(String var1, Object var2);

    public static void isTemporary(Object source) {
        BASE_LOGGER.isTemporary(AuditLogger.getCaller(), source);
    }

    public void isTemporary(String var1, Object var2);

    public static void getPersistentSize(Object source) {
        BASE_LOGGER.getPersistentSize(AuditLogger.getCaller(), source);
    }

    public void getPersistentSize(String var1, Object var2);

    public static void getDurableMessageCount(Object source) {
        BASE_LOGGER.getDurableMessageCount(AuditLogger.getCaller(), source);
    }

    public void getDurableMessageCount(String var1, Object var2);

    public static void getDurablePersistSize(Object source) {
        BASE_LOGGER.getDurablePersistSize(AuditLogger.getCaller(), source);
    }

    public void getDurablePersistSize(String var1, Object var2);

    public static void getConsumerCount(Object source) {
        BASE_LOGGER.getConsumerCount(AuditLogger.getCaller(), source);
    }

    public void getConsumerCount(String var1, Object var2);

    public static void getDeliveringCount(Object source) {
        BASE_LOGGER.getDeliveringCount(AuditLogger.getCaller(), source);
    }

    public void getDeliveringCount(String var1, Object var2);

    public static void getDeliveringSize(Object source) {
        BASE_LOGGER.getDeliveringSize(AuditLogger.getCaller(), source);
    }

    public void getDeliveringSize(String var1, Object var2);

    public static void getDurableDeliveringCount(Object source) {
        BASE_LOGGER.getDurableDeliveringCount(AuditLogger.getCaller(), source);
    }

    public void getDurableDeliveringCount(String var1, Object var2);

    public static void getDurableDeliveringSize(Object source) {
        BASE_LOGGER.getDurableDeliveringSize(AuditLogger.getCaller(), source);
    }

    public void getDurableDeliveringSize(String var1, Object var2);

    public static void getMessagesAdded(Object source) {
        BASE_LOGGER.getMessagesAdded(AuditLogger.getCaller(), source);
    }

    public void getMessagesAdded(String var1, Object var2);

    public static void getMessagesAcknowledged(Object source) {
        BASE_LOGGER.getMessagesAcknowledged(AuditLogger.getCaller(), source);
    }

    public void getMessagesAcknowledged(String var1, Object var2);

    public static void getMessagesExpired(Object source) {
        BASE_LOGGER.getMessagesExpired(AuditLogger.getCaller(), source);
    }

    public void getMessagesExpired(String var1, Object var2);

    public static void getMessagesKilled(Object source) {
        BASE_LOGGER.getMessagesKilled(AuditLogger.getCaller(), source);
    }

    public void getMessagesKilled(String var1, Object var2);

    public static void getID(Object source) {
        BASE_LOGGER.getID(AuditLogger.getCaller(), source);
    }

    public void getID(String var1, Object var2);

    public static void getScheduledCount(Object source) {
        BASE_LOGGER.getScheduledCount(AuditLogger.getCaller(), source);
    }

    public void getScheduledCount(String var1, Object var2);

    public static void getScheduledSize(Object source) {
        BASE_LOGGER.getScheduledSize(AuditLogger.getCaller(), source);
    }

    public void getScheduledSize(String var1, Object var2);

    public static void getDurableScheduledCount(Object source) {
        BASE_LOGGER.getDurableScheduledCount(AuditLogger.getCaller(), source);
    }

    public void getDurableScheduledCount(String var1, Object var2);

    public static void getDurableScheduledSize(Object source) {
        BASE_LOGGER.getDurableScheduledSize(AuditLogger.getCaller(), source);
    }

    public void getDurableScheduledSize(String var1, Object var2);

    public static void getDeadLetterAddress(Object source) {
        BASE_LOGGER.getDeadLetterAddress(AuditLogger.getCaller(), source);
    }

    public void getDeadLetterAddress(String var1, Object var2);

    public static void getExpiryAddress(Object source) {
        BASE_LOGGER.getExpiryAddress(AuditLogger.getCaller(), source);
    }

    public void getExpiryAddress(String var1, Object var2);

    public static void getMaxConsumers(Object source) {
        BASE_LOGGER.getMaxConsumers(AuditLogger.getCaller(), source);
    }

    public void getMaxConsumers(String var1, Object var2);

    public static void isPurgeOnNoConsumers(Object source) {
        BASE_LOGGER.isPurgeOnNoConsumers(AuditLogger.getCaller(), source);
    }

    public void isPurgeOnNoConsumers(String var1, Object var2);

    public static void isConfigurationManaged(Object source) {
        BASE_LOGGER.isConfigurationManaged(AuditLogger.getCaller(), source);
    }

    public void isConfigurationManaged(String var1, Object var2);

    public static void isExclusive(Object source) {
        BASE_LOGGER.isExclusive(AuditLogger.getCaller(), source);
    }

    public void isExclusive(String var1, Object var2);

    public static void isLastValue(Object source) {
        BASE_LOGGER.isLastValue(AuditLogger.getCaller(), source);
    }

    public void isLastValue(String var1, Object var2);

    public static void listScheduledMessages(Object source) {
        BASE_LOGGER.listScheduledMessages(AuditLogger.getCaller(), source);
    }

    public void listScheduledMessages(String var1, Object var2);

    public static void listScheduledMessagesAsJSON(Object source) {
        BASE_LOGGER.listScheduledMessagesAsJSON(AuditLogger.getCaller(), source);
    }

    public void listScheduledMessagesAsJSON(String var1, Object var2);

    public static void listDeliveringMessages(Object source) {
        BASE_LOGGER.listDeliveringMessages(AuditLogger.getCaller(), source);
    }

    public void listDeliveringMessages(String var1, Object var2);

    public static void listDeliveringMessagesAsJSON(Object source) {
        BASE_LOGGER.listDeliveringMessagesAsJSON(AuditLogger.getCaller(), source);
    }

    public void listDeliveringMessagesAsJSON(String var1, Object var2);

    public static void listMessages(Object source, Object ... args) {
        BASE_LOGGER.listMessages(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void listMessages(String var1, Object var2, String var3);

    public static void listMessagesAsJSON(Object source) {
        BASE_LOGGER.listMessagesAsJSON(AuditLogger.getCaller(), source);
    }

    public void listMessagesAsJSON(String var1, Object var2);

    public static void getFirstMessage(Object source) {
        BASE_LOGGER.getFirstMessage(AuditLogger.getCaller(), source);
    }

    public void getFirstMessage(String var1, Object var2);

    public static void getFirstMessageAsJSON(Object source) {
        BASE_LOGGER.getFirstMessageAsJSON(AuditLogger.getCaller(), source);
    }

    public void getFirstMessageAsJSON(String var1, Object var2);

    public static void getFirstMessageTimestamp(Object source) {
        BASE_LOGGER.getFirstMessageTimestamp(AuditLogger.getCaller(), source);
    }

    public void getFirstMessageTimestamp(String var1, Object var2);

    public static void getFirstMessageAge(Object source) {
        BASE_LOGGER.getFirstMessageAge(AuditLogger.getCaller(), source);
    }

    public void getFirstMessageAge(String var1, Object var2);

    public static void countMessages(Object source, Object ... args) {
        BASE_LOGGER.countMessages(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void countMessages(String var1, Object var2, String var3);

    public static void countDeliveringMessages(Object source, Object ... args) {
        BASE_LOGGER.countDeliveringMessages(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void countDeliveringMessages(String var1, Object var2, String var3);

    public static void removeMessage(Object source, Object ... args) {
        BASE_LOGGER.removeMessage(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void removeMessage(String var1, Object var2, String var3);

    public static void removeMessages(Object source, Object ... args) {
        BASE_LOGGER.removeMessages(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void removeMessages(String var1, Object var2, String var3);

    public static void expireMessage(Object source, Object ... args) {
        BASE_LOGGER.expireMessage(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void expireMessage(String var1, Object var2, String var3);

    public static void expireMessages(Object source, Object ... args) {
        BASE_LOGGER.expireMessages(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void expireMessages(String var1, Object var2, String var3);

    public static void retryMessage(Object source, Object ... args) {
        BASE_LOGGER.retryMessage(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void retryMessage(String var1, Object var2, String var3);

    public static void retryMessages(Object source) {
        BASE_LOGGER.retryMessages(AuditLogger.getCaller(), source);
    }

    public void retryMessages(String var1, Object var2);

    public static void moveMessage(Object source, Object ... args) {
        BASE_LOGGER.moveMessage(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void moveMessage(String var1, Object var2, String var3);

    public static void moveMessages(Object source, Object ... args) {
        BASE_LOGGER.moveMessages(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void moveMessages(String var1, Object var2, String var3);

    public static void sendMessagesToDeadLetterAddress(Object source, Object ... args) {
        BASE_LOGGER.sendMessagesToDeadLetterAddress(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void sendMessagesToDeadLetterAddress(String var1, Object var2, String var3);

    public static void sendMessageToDeadLetterAddress(Object source, Object ... args) {
        BASE_LOGGER.sendMessageToDeadLetterAddress(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void sendMessageToDeadLetterAddress(String var1, Object var2, String var3);

    public static void changeMessagesPriority(Object source, Object ... args) {
        BASE_LOGGER.changeMessagesPriority(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void changeMessagesPriority(String var1, Object var2, String var3);

    public static void changeMessagePriority(Object source, Object ... args) {
        BASE_LOGGER.changeMessagePriority(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void changeMessagePriority(String var1, Object var2, String var3);

    public static void listMessageCounter(Object source) {
        BASE_LOGGER.listMessageCounter(AuditLogger.getCaller(), source);
    }

    public void listMessageCounter(String var1, Object var2);

    public static void resetMessageCounter(Object source) {
        BASE_LOGGER.resetMessageCounter(AuditLogger.getCaller(), source);
    }

    public void resetMessageCounter(String var1, Object var2);

    public static void listMessageCounterAsHTML(Object source) {
        BASE_LOGGER.listMessageCounterAsHTML(AuditLogger.getCaller(), source);
    }

    public void listMessageCounterAsHTML(String var1, Object var2);

    public static void listMessageCounterHistory(Object source) {
        BASE_LOGGER.listMessageCounterHistory(AuditLogger.getCaller(), source);
    }

    public void listMessageCounterHistory(String var1, Object var2);

    public static void listMessageCounterHistoryAsHTML(Object source) {
        BASE_LOGGER.listMessageCounterHistoryAsHTML(AuditLogger.getCaller(), source);
    }

    public void listMessageCounterHistoryAsHTML(String var1, Object var2);

    public static void pause(Object source, Object ... args) {
        BASE_LOGGER.pause(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void pause(String var1, Object var2, String var3);

    public static void resume(Object source) {
        BASE_LOGGER.resume(AuditLogger.getCaller(), source);
    }

    public void resume(String var1, Object var2);

    public static void isPaused(Object source) {
        BASE_LOGGER.isPaused(AuditLogger.getCaller(), source);
    }

    public void isPaused(String var1, Object var2);

    public static void browse(Object source, Object ... args) {
        BASE_LOGGER.browse(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void browse(String var1, Object var2, String var3);

    public static void flushExecutor(Object source) {
        BASE_LOGGER.flushExecutor(AuditLogger.getCaller(), source);
    }

    public void flushExecutor(String var1, Object var2);

    public static void resetAllGroups(Object source) {
        BASE_LOGGER.resetAllGroups(AuditLogger.getCaller(), source);
    }

    public void resetAllGroups(String var1, Object var2);

    public static void resetGroup(Object source, Object ... args) {
        BASE_LOGGER.resetGroup(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void resetGroup(String var1, Object var2, String var3);

    public static void getGroupCount(Object source, Object ... args) {
        BASE_LOGGER.getGroupCount(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void getGroupCount(String var1, Object var2, String var3);

    public static void listGroupsAsJSON(Object source) {
        BASE_LOGGER.listGroupsAsJSON(AuditLogger.getCaller(), source);
    }

    public void listGroupsAsJSON(String var1, Object var2);

    public static void resetMessagesAdded(Object source) {
        BASE_LOGGER.resetMessagesAdded(AuditLogger.getCaller(), source);
    }

    public void resetMessagesAdded(String var1, Object var2);

    public static void resetMessagesAcknowledged(Object source) {
        BASE_LOGGER.resetMessagesAcknowledged(AuditLogger.getCaller(), source);
    }

    public void resetMessagesAcknowledged(String var1, Object var2);

    public static void resetMessagesExpired(Object source) {
        BASE_LOGGER.resetMessagesExpired(AuditLogger.getCaller(), source);
    }

    public void resetMessagesExpired(String var1, Object var2);

    public static void resetMessagesKilled(Object source) {
        BASE_LOGGER.resetMessagesKilled(AuditLogger.getCaller(), source);
    }

    public void resetMessagesKilled(String var1, Object var2);

    public static void getStaticConnectors(Object source) {
        BASE_LOGGER.getStaticConnectors(AuditLogger.getCaller(), source);
    }

    public void getStaticConnectors(String var1, Object var2);

    public static void getForwardingAddress(Object source) {
        BASE_LOGGER.getForwardingAddress(AuditLogger.getCaller(), source);
    }

    public void getForwardingAddress(String var1, Object var2);

    public static void getQueueName(Object source) {
        BASE_LOGGER.getQueueName(AuditLogger.getCaller(), source);
    }

    public void getQueueName(String var1, Object var2);

    public static void getDiscoveryGroupName(Object source) {
        BASE_LOGGER.getDiscoveryGroupName(AuditLogger.getCaller(), source);
    }

    public void getDiscoveryGroupName(String var1, Object var2);

    public static void getFilterString(Object source) {
        BASE_LOGGER.getFilterString(AuditLogger.getCaller(), source);
    }

    public void getFilterString(String var1, Object var2);

    public static void getReconnectAttempts(Object source) {
        BASE_LOGGER.getReconnectAttempts(AuditLogger.getCaller(), source);
    }

    public void getReconnectAttempts(String var1, Object var2);

    public static void getRetryInterval(Object source) {
        BASE_LOGGER.getRetryInterval(AuditLogger.getCaller(), source);
    }

    public void getRetryInterval(String var1, Object var2);

    public static void getRetryIntervalMultiplier(Object source) {
        BASE_LOGGER.getRetryIntervalMultiplier(AuditLogger.getCaller(), source);
    }

    public void getRetryIntervalMultiplier(String var1, Object var2);

    public static void getTransformerClassName(Object source) {
        BASE_LOGGER.getTransformerClassName(AuditLogger.getCaller(), source);
    }

    public void getTransformerClassName(String var1, Object var2);

    public static void getTransformerPropertiesAsJSON(Object source) {
        BASE_LOGGER.getTransformerPropertiesAsJSON(AuditLogger.getCaller(), source);
    }

    public void getTransformerPropertiesAsJSON(String var1, Object var2);

    public static void getTransformerProperties(Object source) {
        BASE_LOGGER.getTransformerProperties(AuditLogger.getCaller(), source);
    }

    public void getTransformerProperties(String var1, Object var2);

    public static void isStartedBridge(Object source) {
        BASE_LOGGER.isStartedBridge(AuditLogger.getCaller(), source);
    }

    public void isStartedBridge(String var1, Object var2);

    public static void isUseDuplicateDetection(Object source) {
        BASE_LOGGER.isUseDuplicateDetection(AuditLogger.getCaller(), source);
    }

    public void isUseDuplicateDetection(String var1, Object var2);

    public static void isHA(Object source) {
        BASE_LOGGER.isHA(AuditLogger.getCaller(), source);
    }

    public void isHA(String var1, Object var2);

    public static void startBridge(Object source) {
        BASE_LOGGER.startBridge(AuditLogger.getCaller(), source);
    }

    public void startBridge(String var1, Object var2);

    public static void stopBridge(Object source) {
        BASE_LOGGER.stopBridge(AuditLogger.getCaller(), source);
    }

    public void stopBridge(String var1, Object var2);

    public static void getMessagesPendingAcknowledgement(Object source) {
        BASE_LOGGER.getMessagesPendingAcknowledgement(AuditLogger.getCaller(), source);
    }

    public void getMessagesPendingAcknowledgement(String var1, Object var2);

    public static void getMetrics(Object source) {
        BASE_LOGGER.getMetrics(AuditLogger.getCaller(), source);
    }

    public void getMetrics(String var1, Object var2);

    public static void getBroadcastPeriod(Object source) {
        BASE_LOGGER.getBroadcastPeriod(AuditLogger.getCaller(), source);
    }

    public void getBroadcastPeriod(String var1, Object var2);

    public static void getConnectorPairs(Object source) {
        BASE_LOGGER.getConnectorPairs(AuditLogger.getCaller(), source);
    }

    public void getConnectorPairs(String var1, Object var2);

    public static void getConnectorPairsAsJSON(Object source) {
        BASE_LOGGER.getConnectorPairsAsJSON(AuditLogger.getCaller(), source);
    }

    public void getConnectorPairsAsJSON(String var1, Object var2);

    public static void getGroupAddress(Object source) {
        BASE_LOGGER.getGroupAddress(AuditLogger.getCaller(), source);
    }

    public void getGroupAddress(String var1, Object var2);

    public static void getGroupPort(Object source) {
        BASE_LOGGER.getGroupPort(AuditLogger.getCaller(), source);
    }

    public void getGroupPort(String var1, Object var2);

    public static void getLocalBindPort(Object source) {
        BASE_LOGGER.getLocalBindPort(AuditLogger.getCaller(), source);
    }

    public void getLocalBindPort(String var1, Object var2);

    public static void startBroadcastGroup(Object source) {
        BASE_LOGGER.startBroadcastGroup(AuditLogger.getCaller(), source);
    }

    public void startBroadcastGroup(String var1, Object var2);

    public static void stopBroadcastGroup(Object source) {
        BASE_LOGGER.stopBroadcastGroup(AuditLogger.getCaller(), source);
    }

    public void stopBroadcastGroup(String var1, Object var2);

    public static void getMaxHops(Object source) {
        BASE_LOGGER.getMaxHops(AuditLogger.getCaller(), source);
    }

    public void getMaxHops(String var1, Object var2);

    public static void getStaticConnectorsAsJSON(Object source) {
        BASE_LOGGER.getStaticConnectorsAsJSON(AuditLogger.getCaller(), source);
    }

    public void getStaticConnectorsAsJSON(String var1, Object var2);

    public static void isDuplicateDetection(Object source) {
        BASE_LOGGER.isDuplicateDetection(AuditLogger.getCaller(), source);
    }

    public void isDuplicateDetection(String var1, Object var2);

    public static void getMessageLoadBalancingType(Object source) {
        BASE_LOGGER.getMessageLoadBalancingType(AuditLogger.getCaller(), source);
    }

    public void getMessageLoadBalancingType(String var1, Object var2);

    public static void getTopology(Object source) {
        BASE_LOGGER.getTopology(AuditLogger.getCaller(), source);
    }

    public void getTopology(String var1, Object var2);

    public static void getNodes(Object source) {
        BASE_LOGGER.getNodes(AuditLogger.getCaller(), source);
    }

    public void getNodes(String var1, Object var2);

    public static void startClusterConnection(Object source) {
        BASE_LOGGER.startClusterConnection(AuditLogger.getCaller(), source);
    }

    public void startClusterConnection(String var1, Object var2);

    public static void stopClusterConnection(Object source) {
        BASE_LOGGER.stopClusterConnection(AuditLogger.getCaller(), source);
    }

    public void stopClusterConnection(String var1, Object var2);

    public static void getBridgeMetrics(Object source, Object ... args) {
        BASE_LOGGER.getBridgeMetrics(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void getBridgeMetrics(String var1, Object var2, String var3);

    public static void getRoutingName(Object source) {
        BASE_LOGGER.getRoutingName(AuditLogger.getCaller(), source);
    }

    public void getRoutingName(String var1, Object var2);

    public static void getUniqueName(Object source) {
        BASE_LOGGER.getUniqueName(AuditLogger.getCaller(), source);
    }

    public void getUniqueName(String var1, Object var2);

    public static void serverSessionCreateAddress(Object source, Subject user, String remoteAddress, Object ... args) {
        BASE_LOGGER.serverSessionCreateAddress2(AuditLogger.getCaller(user, remoteAddress), source, AuditLogger.parametersList(args));
    }

    public void serverSessionCreateAddress2(String var1, Object var2, String var3);

    public static void handleManagementMessage(Object source, Subject user, String remoteAddress, Object ... args) {
        BASE_LOGGER.handleManagementMessage2(AuditLogger.getCaller(user, remoteAddress), source, AuditLogger.parametersList(args));
    }

    public void handleManagementMessage2(String var1, Object var2, String var3);

    public static void securityFailure(Subject subject, String remoteAddress, String reason, Exception cause) {
        BASE_LOGGER.securityFailure(AuditLogger.getCaller(subject, remoteAddress), reason, cause);
    }

    public void securityFailure(String var1, String var2, Throwable var3);

    public static void createCoreConsumer(Object source, Subject user, String remoteAddress, Object ... args) {
        BASE_LOGGER.createCoreConsumer(AuditLogger.getCaller(user, remoteAddress), source, AuditLogger.parametersList(args));
    }

    public void createCoreConsumer(String var1, Object var2, String var3);

    public static void createSharedQueue(Object source, Subject user, String remoteAddress, Object ... args) {
        BASE_LOGGER.createSharedQueue(AuditLogger.getCaller(user, remoteAddress), source, AuditLogger.parametersList(args));
    }

    public void createSharedQueue(String var1, Object var2, String var3);

    public static void createCoreSession(Object source, Subject user, String remoteAddress, Object ... args) {
        BASE_LOGGER.createCoreSession(AuditLogger.getCaller(user, remoteAddress), source, AuditLogger.parametersList(args));
    }

    public void createCoreSession(String var1, Object var2, String var3);

    public static void getAcknowledgeAttempts(Object source) {
        BASE_LOGGER.getMessagesAcknowledged(AuditLogger.getCaller(), source);
    }

    public void getAcknowledgeAttempts(String var1, Object var2, String var3);

    public static void getRingSize(Object source, Object ... args) {
        BASE_LOGGER.getRingSize(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void getRingSize(String var1, Object var2, String var3);

    public static void isRetroactiveResource(Object source) {
        BASE_LOGGER.isRetroactiveResource(AuditLogger.getCaller(), source);
    }

    public void isRetroactiveResource(String var1, Object var2);

    public static void getDiskStoreUsage(Object source) {
        BASE_LOGGER.getDiskStoreUsage(AuditLogger.getCaller(), source);
    }

    public void getDiskStoreUsage(String var1, Object var2);

    public static void getDiskStoreUsagePercentage(Object source) {
        BASE_LOGGER.getDiskStoreUsagePercentage(AuditLogger.getCaller(), source);
    }

    public void getDiskStoreUsagePercentage(String var1, Object var2);

    public static void isGroupRebalance(Object source) {
        BASE_LOGGER.isGroupRebalance(AuditLogger.getCaller(), source);
    }

    public void isGroupRebalance(String var1, Object var2);

    public static void getGroupBuckets(Object source) {
        BASE_LOGGER.getGroupBuckets(AuditLogger.getCaller(), source);
    }

    public void getGroupBuckets(String var1, Object var2);

    public static void getGroupFirstKey(Object source) {
        BASE_LOGGER.getGroupFirstKey(AuditLogger.getCaller(), source);
    }

    public void getGroupFirstKey(String var1, Object var2);

    public static void getCurrentDuplicateIdCacheSize(Object source) {
        BASE_LOGGER.getCurrentDuplicateIdCacheSize(AuditLogger.getCaller(), source);
    }

    public void getCurrentDuplicateIdCacheSize(String var1, Object var2);

    public static void clearDuplicateIdCache(Object source) {
        BASE_LOGGER.clearDuplicateIdCache(AuditLogger.getCaller(), source);
    }

    public void clearDuplicateIdCache(String var1, Object var2);

    public static void getChannelName(Object source) {
        BASE_LOGGER.getChannelName(AuditLogger.getCaller(), source);
    }

    public void getChannelName(String var1, Object var2);

    public static void getFileContents(Object source) {
        BASE_LOGGER.getFileContents(AuditLogger.getCaller(), source);
    }

    public void getFileContents(String var1, Object var2);

    public static void getFile(Object source) {
        BASE_LOGGER.getFile(AuditLogger.getCaller(), source);
    }

    public void getFile(String var1, Object var2);

    public static void getPreparedTransactionMessageCount(Object source) {
        BASE_LOGGER.getPreparedTransactionMessageCount(AuditLogger.getCaller(), source);
    }

    public void getPreparedTransactionMessageCount(String var1, Object var2);

    public static void coreSendMessage(Subject user, String remoteAddress, String messageToString, Object context, String tx) {
        MESSAGE_LOGGER.coreSendMessage(AuditLogger.getCaller(user, remoteAddress), messageToString, context, tx);
    }

    public void coreSendMessage(String var1, String var2, Object var3, String var4);

    public static void coreConsumeMessage(Subject user, String remoteAddress, String queue, String message) {
        MESSAGE_LOGGER.consumeMessage(AuditLogger.getCaller(user, remoteAddress), queue, message);
    }

    public void consumeMessage(String var1, String var2, String var3);

    public static void coreAcknowledgeMessage(Subject user, String remoteAddress, String queue, String message, String tx) {
        MESSAGE_LOGGER.coreAcknowledgeMessage(AuditLogger.getCaller(user, remoteAddress), queue, message, tx);
    }

    public void coreAcknowledgeMessage(String var1, String var2, String var3, String var4);

    public static void createAddressSuccess(String name, String routingTypes) {
        RESOURCE_LOGGER.createAddressSuccess(AuditLogger.getCaller(), name, routingTypes);
    }

    public void createAddressSuccess(String var1, String var2, String var3);

    public static void createAddressFailure(String name, String routingTypes) {
        RESOURCE_LOGGER.createAddressFailure(AuditLogger.getCaller(), name, routingTypes);
    }

    public void createAddressFailure(String var1, String var2, String var3);

    public static void updateAddressSuccess(String name, String routingTypes) {
        RESOURCE_LOGGER.updateAddressSuccess(AuditLogger.getCaller(), name, routingTypes);
    }

    public void updateAddressSuccess(String var1, String var2, String var3);

    public static void updateAddressFailure(String name, String routingTypes) {
        RESOURCE_LOGGER.updateAddressFailure(AuditLogger.getCaller(), name, routingTypes);
    }

    public void updateAddressFailure(String var1, String var2, String var3);

    public static void deleteAddressSuccess(String name) {
        RESOURCE_LOGGER.deleteAddressSuccess(AuditLogger.getCaller(), name);
    }

    public void deleteAddressSuccess(String var1, String var2);

    public static void deleteAddressFailure(String name) {
        RESOURCE_LOGGER.deleteAddressFailure(AuditLogger.getCaller(), name);
    }

    public void deleteAddressFailure(String var1, String var2);

    public static void createQueueSuccess(String name, String address, String routingType) {
        RESOURCE_LOGGER.createQueueSuccess(AuditLogger.getCaller(), name, address, routingType);
    }

    public void createQueueSuccess(String var1, String var2, String var3, String var4);

    public static void createQueueFailure(String name, String address, String routingType) {
        RESOURCE_LOGGER.createQueueFailure(AuditLogger.getCaller(), name, address, routingType);
    }

    public void createQueueFailure(String var1, String var2, String var3, String var4);

    public static void updateQueueSuccess(String name, String routingType) {
        RESOURCE_LOGGER.updateQueueSuccess(AuditLogger.getCaller(), name, routingType);
    }

    public void updateQueueSuccess(String var1, String var2, String var3);

    public static void updateQueueFailure(String name, String routingType) {
        RESOURCE_LOGGER.updateQueueFailure(AuditLogger.getCaller(), name, routingType);
    }

    public void updateQueueFailure(String var1, String var2, String var3);

    public static void destroyQueueSuccess(String name) {
        RESOURCE_LOGGER.destroyQueueSuccess(AuditLogger.getCaller(), name);
    }

    public void destroyQueueSuccess(String var1, String var2);

    public static void destroyQueueFailure(String name) {
        RESOURCE_LOGGER.destroyQueueFailure(AuditLogger.getCaller(), name);
    }

    public void destroyQueueFailure(String var1, String var2);

    public static void removeMessagesSuccess(int removed, String queue) {
        RESOURCE_LOGGER.removeMessagesSuccess(AuditLogger.getCaller(), removed, queue);
    }

    public void removeMessagesSuccess(String var1, int var2, String var3);

    public static void removeMessagesFailure(String queue) {
        RESOURCE_LOGGER.removeMessagesFailure(AuditLogger.getCaller(), queue);
    }

    public void removeMessagesFailure(String var1, String var2);

    public static void userSuccesfullyAuthenticatedInAudit(Subject subject, String remoteAddress, String connectionID) {
        RESOURCE_LOGGER.userSuccesfullyAuthenticated(AuditLogger.getCaller(subject, remoteAddress), connectionID);
    }

    public static void userSuccesfullyAuthenticatedInAudit(Subject subject) {
        AuditLogger.userSuccesfullyAuthenticatedInAudit(subject, null, null);
    }

    public void userSuccesfullyAuthenticated(String var1, String var2);

    public static void userFailedAuthenticationInAudit(String reason) {
        RESOURCE_LOGGER.userFailedAuthentication(AuditLogger.getCaller(), null, reason);
    }

    public static void userFailedAuthenticationInAudit(Subject subject, String reason, String connectionID) {
        RESOURCE_LOGGER.userFailedAuthentication(AuditLogger.getCaller(subject, null), connectionID, reason);
    }

    public void userFailedAuthentication(String var1, String var2, String var3);

    public static void objectInvokedSuccessfully(ObjectName objectName, String operationName) {
        RESOURCE_LOGGER.objectInvokedSuccessfully(AuditLogger.getCaller(), objectName, operationName);
    }

    public void objectInvokedSuccessfully(String var1, ObjectName var2, String var3);

    public static void objectInvokedFailure(ObjectName objectName, String operationName) {
        RESOURCE_LOGGER.objectInvokedFailure(AuditLogger.getCaller(), objectName, operationName);
    }

    public void objectInvokedFailure(String var1, ObjectName var2, String var3);

    public static void pauseQueueSuccess(String queueName) {
        RESOURCE_LOGGER.pauseQueueSuccess(AuditLogger.getCaller(), queueName);
    }

    public void pauseQueueSuccess(String var1, String var2);

    public static void pauseQueueFailure(String queueName) {
        RESOURCE_LOGGER.pauseQueueFailure(AuditLogger.getCaller(), queueName);
    }

    public void pauseQueueFailure(String var1, String var2);

    public static void resumeQueueSuccess(String queueName) {
        RESOURCE_LOGGER.resumeQueueSuccess(AuditLogger.getCaller(), queueName);
    }

    public void resumeQueueSuccess(String var1, String var2);

    public static void resumeQueueFailure(String queueName) {
        RESOURCE_LOGGER.pauseQueueFailure(AuditLogger.getCaller(), queueName);
    }

    public void resumeQueueFailure(String var1, String var2);

    public static void sendMessageSuccess(String queueName, String user) {
        RESOURCE_LOGGER.sendMessageSuccess(AuditLogger.getCaller(), queueName, user);
    }

    public void sendMessageSuccess(String var1, String var2, String var3);

    public static void sendMessageFailure(String queueName, String user) {
        RESOURCE_LOGGER.sendMessageFailure(AuditLogger.getCaller(), queueName, user);
    }

    public void sendMessageFailure(String var1, String var2, String var3);

    public static void browseMessagesSuccess(String queueName, int numMessages) {
        RESOURCE_LOGGER.browseMessagesSuccess(AuditLogger.getCaller(), numMessages, queueName);
    }

    public void browseMessagesSuccess(String var1, int var2, String var3);

    public static void browseMessagesFailure(String queueName) {
        RESOURCE_LOGGER.browseMessagesFailure(AuditLogger.getCaller(), queueName);
    }

    public void browseMessagesFailure(String var1, String var2);

    public static void updateDivert(Object source, Object ... args) {
        BASE_LOGGER.updateDivert(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void updateDivert(String var1, Object var2, String var3);

    public static void isEnabled(Object source) {
        BASE_LOGGER.isEnabled(AuditLogger.getCaller(), source);
    }

    public void isEnabled(String var1, Object var2);

    public static void disable(Object source, Object ... args) {
        BASE_LOGGER.disable(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void disable(String var1, Object var2, String var3);

    public static void enable(Object source) {
        BASE_LOGGER.resume(AuditLogger.getCaller(), source);
    }

    public void enable(String var1, Object var2);

    public static void pauseAddressSuccess(String queueName) {
        RESOURCE_LOGGER.pauseAddressSuccess(AuditLogger.getCaller(), queueName);
    }

    public void pauseAddressSuccess(String var1, String var2);

    public static void pauseAddressFailure(String queueName) {
        RESOURCE_LOGGER.pauseAddressFailure(AuditLogger.getCaller(), queueName);
    }

    public void pauseAddressFailure(String var1, String var2);

    public static void resumeAddressSuccess(String queueName) {
        RESOURCE_LOGGER.resumeAddressSuccess(AuditLogger.getCaller(), queueName);
    }

    public void resumeAddressSuccess(String var1, String var2);

    public static void resumeAddressFailure(String queueName) {
        RESOURCE_LOGGER.resumeAddressFailure(AuditLogger.getCaller(), queueName);
    }

    public void resumeAddressFailure(String var1, String var2);

    public static void isGroupRebalancePauseDispatch(Object source) {
        BASE_LOGGER.isGroupRebalancePauseDispatch(AuditLogger.getCaller(), source);
    }

    public void isGroupRebalancePauseDispatch(String var1, Object var2);

    public static void getAuthenticationCacheSize(Object source) {
        BASE_LOGGER.getAuthenticationCacheSize(AuditLogger.getCaller(), source);
    }

    public void getAuthenticationCacheSize(String var1, Object var2);

    public static void getAuthorizationCacheSize(Object source) {
        BASE_LOGGER.getAuthorizationCacheSize(AuditLogger.getCaller(), source);
    }

    public void getAuthorizationCacheSize(String var1, Object var2);

    public static void listBrokerConnections() {
        BASE_LOGGER.listBrokerConnections(AuditLogger.getCaller());
    }

    public void listBrokerConnections(String var1);

    public static void stopBrokerConnection(String name) {
        BASE_LOGGER.stopBrokerConnection(AuditLogger.getCaller(), name);
    }

    public void stopBrokerConnection(String var1, String var2);

    public static void startBrokerConnection(String name) {
        BASE_LOGGER.startBrokerConnection(AuditLogger.getCaller(), name);
    }

    public void startBrokerConnection(String var1, String var2);

    public static void getAddressCount(Object source) {
        BASE_LOGGER.getAddressCount(AuditLogger.getCaller(), source);
    }

    public void getAddressCount(String var1, Object var2);

    public static void getQueueCount(Object source) {
        BASE_LOGGER.getQueueCount(AuditLogger.getCaller(), source);
    }

    public void getQueueCount(String var1, Object var2);

    public static void lastValueKey(Object source) {
        BASE_LOGGER.lastValueKey(AuditLogger.getCaller(), source);
    }

    public void lastValueKey(String var1, Object var2);

    public static void consumersBeforeDispatch(Object source) {
        BASE_LOGGER.consumersBeforeDispatch(AuditLogger.getCaller(), source);
    }

    public void consumersBeforeDispatch(String var1, Object var2);

    public static void delayBeforeDispatch(Object source) {
        BASE_LOGGER.delayBeforeDispatch(AuditLogger.getCaller(), source);
    }

    public void delayBeforeDispatch(String var1, Object var2);

    public static void isInternal(Object source) {
        BASE_LOGGER.isInternal(AuditLogger.getCaller(), source);
    }

    public void isInternal(String var1, Object var2);

    public static void isAutoCreated(Object source) {
        BASE_LOGGER.isAutoCreated(AuditLogger.getCaller(), source);
    }

    public void isAutoCreated(String var1, Object var2);

    public static void getMaxRetryInterval(Object source) {
        BASE_LOGGER.getMaxRetryInterval(AuditLogger.getCaller(), source);
    }

    public void getMaxRetryInterval(String var1, Object var2);

    public static void getActivationSequence(Object source) {
        BASE_LOGGER.getActivationSequence(AuditLogger.getCaller(), source);
    }

    public void getActivationSequence(String var1, Object var2);

    public static void purge(Object source) {
        RESOURCE_LOGGER.purge(AuditLogger.getCaller(), source);
    }

    public void purge(String var1, Object var2);

    public static void purgeAddressSuccess(String queueName) {
        RESOURCE_LOGGER.purgeAddressSuccess(AuditLogger.getCaller(), queueName);
    }

    public void purgeAddressSuccess(String var1, String var2);

    public static void purgeAddressFailure(String queueName) {
        RESOURCE_LOGGER.purgeAddressFailure(AuditLogger.getCaller(), queueName);
    }

    public void purgeAddressFailure(String var1, String var2);

    public static void getAddressLimitPercent(Object source) {
        BASE_LOGGER.getAddressLimitPercent(AuditLogger.getCaller(), source);
    }

    public void getAddressLimitPercent(String var1, Object var2);

    public static void block(Object source) {
        BASE_LOGGER.block(AuditLogger.getCaller(), source);
    }

    public void block(String var1, Object var2);

    public static void unBlock(Object source) {
        BASE_LOGGER.unBlock(AuditLogger.getCaller(), source);
    }

    public void unBlock(String var1, Object var2);

    public static void getAcceptors(Object source) {
        BASE_LOGGER.getAcceptors(AuditLogger.getCaller(), source);
    }

    public void getAcceptors(String var1, Object var2);

    public static void getAcceptorsAsJSON(Object source) {
        BASE_LOGGER.getAcceptorsAsJSON(AuditLogger.getCaller(), source);
    }

    public void getAcceptorsAsJSON(String var1, Object var2);

    public static void schedulePageCleanup(Object source) {
        BASE_LOGGER.schedulePageCleanup(AuditLogger.getCaller(), source);
    }

    public void schedulePageCleanup(String var1, Object var2);

    public static void addAckToTransaction(Subject user, String remoteAddress, String queue, String message, String tx) {
        MESSAGE_LOGGER.addAckToTransaction(AuditLogger.getCaller(user, remoteAddress), queue, message, tx);
    }

    public void addAckToTransaction(String var1, String var2, String var3, String var4);

    public static void addSendToTransaction(Subject user, String remoteAddress, String messageToString, String tx) {
        MESSAGE_LOGGER.addSendToTransaction(AuditLogger.getCaller(user, remoteAddress), messageToString, tx);
    }

    public void addSendToTransaction(String var1, String var2, String var3);

    public static void rolledBackTransaction(Subject user, String remoteAddress, String tx, String resource) {
        MESSAGE_LOGGER.rolledBackTransaction(AuditLogger.getCaller(user, remoteAddress), tx, resource);
    }

    public void rolledBackTransaction(String var1, String var2, String var3);

    public static void addConnector(Object source, Object ... args) {
        BASE_LOGGER.addConnector(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void addConnector(String var1, Object var2, String var3);

    public static void removeConnector(Object source, Object ... args) {
        BASE_LOGGER.removeConnector(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void removeConnector(String var1, Object var2, String var3);

    public static void deliverScheduledMessage(Object source, Object ... args) {
        BASE_LOGGER.deliverScheduledMessage(AuditLogger.getCaller(), source, AuditLogger.parametersList(args));
    }

    public void deliverScheduledMessage(String var1, Object var2, String var3);

    public static void getStatus(Object source) {
        BASE_LOGGER.getStatus(AuditLogger.getCaller(), source);
    }

    public void getStatus(String var1, Object var2);

    public static void isAutoDelete(Object source) {
        BASE_LOGGER.isAutoDelete(AuditLogger.getCaller(), source);
    }

    public void isAutoDelete(String var1, Object var2);

    public static void createdConnection(String protocol, Object connectionID, String remoteAddress) {
        RESOURCE_LOGGER.createdConnection(protocol, String.valueOf(connectionID), String.format("unknown%s", AuditLogger.formatRemoteAddress(remoteAddress)));
    }

    public void createdConnection(String var1, String var2, String var3);

    public static void destroyedConnection(String protocol, Object connectionID, Subject subject, String remoteAddress) {
        RESOURCE_LOGGER.destroyedConnection(protocol, String.valueOf(connectionID), AuditLogger.getCaller(subject, remoteAddress));
    }

    public void destroyedConnection(String var1, String var2, String var3);

    public static void clearAuthenticationCache(Object source) {
        BASE_LOGGER.clearAuthenticationCache(AuditLogger.getCaller(), source);
    }

    public void clearAuthenticationCache(String var1, Object var2);

    public static void clearAuthorizationCache(Object source) {
        BASE_LOGGER.clearAuthorizationCache(AuditLogger.getCaller(), source);
    }

    public void clearAuthorizationCache(String var1, Object var2);

    public static void getCurrentTimeMillis() {
        BASE_LOGGER.getCurrentTimeMillis(AuditLogger.getCaller());
    }

    public void getCurrentTimeMillis(Object var1);
}

