/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.utils;

import jakarta.ws.rs.core.EntityPart;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.Providers;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.ContentDisposition;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;
import org.apache.cxf.jaxrs.impl.EntityPartImpl;
import org.apache.cxf.jaxrs.impl.ProvidersImpl;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.multipart.AttachmentUtils;
import org.apache.cxf.message.Message;

final class EntityPartUtils {
    private static final String MULTIPART_FORM_DATA_TYPE = "form-data";
    private static final String CONTENT_DISPOSITION_FILES_PARAM = "files";

    private EntityPartUtils() {
    }

    public static List<EntityPart> getEntityParts(MessageContext mc) {
        return EntityPartUtils.from(mc.getProviders(), AttachmentUtils.getMultipartBody(mc));
    }

    public static EntityPart getEntityPart(String key, String value, Message message) {
        ProvidersImpl providers = new ProvidersImpl(message);
        MultipartBody body = (MultipartBody)message.get((Object)"org.apache.cxf.jaxrs.attachments.inbound");
        if (body != null) {
            Attachment attachment = body.getAttachment(key);
            if (attachment != null) {
                String fileName;
                ContentDisposition cd = attachment.getContentDisposition();
                String string = fileName = cd != null ? cd.getFilename() : null;
                if (!StringUtils.isEmpty((String)fileName)) {
                    return new EntityPartImpl(providers, key, fileName, value, String.class, null, attachment.getHeaders(), attachment.getContentType());
                }
                return new EntityPartImpl(providers, key, null, value, String.class, null, attachment.getHeaders(), attachment.getContentType());
            }
            return new EntityPartImpl(providers, key, null, value, String.class, null, (MultivaluedMap<String, String>)new MultivaluedHashMap(), MediaType.TEXT_PLAIN_TYPE);
        }
        return new EntityPartImpl(providers, key, null, value, String.class, null, (MultivaluedMap<String, String>)new MultivaluedHashMap(), MediaType.TEXT_PLAIN_TYPE);
    }

    private static List<EntityPart> from(Providers providers, MultipartBody body) {
        List<Attachment> atts = body.getAllAttachments();
        ArrayList<EntityPart> parts = new ArrayList<EntityPart>(atts.size());
        for (Attachment a : atts) {
            EntityPart part = EntityPartUtils.createFromAttachment(providers, a);
            if (part == null) continue;
            parts.add(part);
        }
        return parts;
    }

    private static EntityPart createFromAttachment(Providers providers, Attachment a) {
        String name;
        ContentDisposition cd = a.getContentDisposition();
        if (cd != null && !MULTIPART_FORM_DATA_TYPE.equalsIgnoreCase(cd.getType())) {
            return null;
        }
        String fileName = cd != null ? cd.getFilename() : null;
        String cdName = cd == null ? null : cd.getParameter("name");
        String contentId = a.getContentId();
        String string = name = StringUtils.isEmpty((String)cdName) ? contentId : cdName.replace("\"", "").replace("'", "");
        if (StringUtils.isEmpty((String)name) && StringUtils.isEmpty((String)fileName)) {
            throw ExceptionUtils.toBadRequestException(null, null);
        }
        if (CONTENT_DISPOSITION_FILES_PARAM.equals(name)) {
            return null;
        }
        try {
            InputStream is = a.getDataHandler().getInputStream();
            if (!StringUtils.isEmpty((String)fileName)) {
                return new EntityPartImpl(providers, name, fileName, is, InputStream.class, null, a.getHeaders(), a.getContentType());
            }
            return new EntityPartImpl(providers, name, null, is, InputStream.class, null, a.getHeaders(), a.getContentType());
        }
        catch (IOException ex) {
            throw ExceptionUtils.toBadRequestException(null, null);
        }
    }
}

