/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.lc.type.impl;

import java.util.Map;
import java.util.Objects;
import org.mozilla.javascript.lc.type.TypeInfo;
import org.mozilla.javascript.lc.type.VariableTypeInfo;
import org.mozilla.javascript.lc.type.impl.TypeInfoBase;

public final class ArrayTypeInfo
extends TypeInfoBase {
    private final TypeInfo component;
    private Class<?> asClass;

    public ArrayTypeInfo(TypeInfo component) {
        this.component = Objects.requireNonNull(component);
    }

    @Override
    public boolean is(Class<?> c) {
        return c.isArray() && this.asClass() == c;
    }

    @Override
    public Class<?> asClass() {
        if (this.asClass == null) {
            this.asClass = this.component.newArray(0).getClass();
        }
        return this.asClass;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof ArrayTypeInfo && this.component.equals(((ArrayTypeInfo)obj).component);
    }

    public int hashCode() {
        return this.component.hashCode() + 1;
    }

    @Override
    public TypeInfo getComponentType() {
        return this.component;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public int getTypeTag() {
        return 0;
    }

    @Override
    public TypeInfo consolidate(Map<VariableTypeInfo, TypeInfo> mapping) {
        TypeInfo component = this.component;
        TypeInfo consolidated = component.consolidate(mapping);
        return component == consolidated ? this : new ArrayTypeInfo(consolidated);
    }
}

