/*
 * Decompiled with CFR 0.152.
 */
package groovy.transform.builder;

import groovy.transform.TupleConstructor;
import groovy.transform.Undefined;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.groovy.ast.tools.AnnotatedNodeUtils;
import org.apache.groovy.ast.tools.ClassNodeUtils;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.ast.tools.GenericsUtils;
import org.codehaus.groovy.transform.AbstractASTTransformation;
import org.codehaus.groovy.transform.BuilderASTTransformation;

public class InitializerStrategy
extends BuilderASTTransformation.AbstractBuilderStrategy {
    private static final Expression DEFAULT_INITIAL_VALUE = null;
    private static final ClassNode TUPLECONS_TYPE = ClassHelper.make(TupleConstructor.class);

    @Override
    public void build(BuilderASTTransformation transform, AnnotatedNode annotatedNode, AnnotationNode anno) {
        if (this.unsupportedAttribute(transform, anno, "forClass")) {
            return;
        }
        if (this.unsupportedAttribute(transform, anno, "allProperties")) {
            return;
        }
        boolean useSetters = transform.memberHasValue(anno, "useSetters", true);
        boolean allNames = transform.memberHasValue(anno, "allNames", true);
        boolean force = transform.memberHasValue(anno, "force", true);
        if (annotatedNode instanceof ClassNode) {
            this.createBuilderForAnnotatedClass(transform, (ClassNode)annotatedNode, anno, useSetters, allNames, force);
        } else if (annotatedNode instanceof MethodNode) {
            if (annotatedNode.getNodeMetaData("PSEUDO_CONSTRUCTOR") != null) {
                transform.addError("Error during " + BuilderASTTransformation.MY_TYPE_NAME + " processing: building for the canonical constructor of records not supported by " + this.getClass().getSimpleName(), annotatedNode);
                return;
            }
            this.createBuilderForAnnotatedMethod(transform, (MethodNode)annotatedNode, anno, useSetters);
        }
    }

    private void createBuilderForAnnotatedClass(BuilderASTTransformation transform, ClassNode buildee, AnnotationNode anno, boolean useSetters, boolean allNames, boolean force) {
        List<FieldNode> fields;
        List<FieldNode> filteredFields;
        ArrayList<String> excludes = new ArrayList<String>();
        ArrayList<String> includes = new ArrayList<String>();
        includes.add("<DummyUndefinedMarkerString-DoNotUse>");
        if (!this.getIncludeExclude(transform, anno, buildee, excludes, includes)) {
            return;
        }
        if (includes.size() == 1 && Undefined.isUndefined((String)includes.get(0))) {
            includes = null;
        }
        if ((filteredFields = InitializerStrategy.filterFields(fields = this.getFields(transform, anno, buildee), includes, excludes, allNames)).isEmpty()) {
            transform.addError("Error during " + BuilderASTTransformation.MY_TYPE_NAME + " processing: at least one property is required for this strategy", anno);
        }
        ClassNode builder = InitializerStrategy.createInnerHelperClass(buildee, InitializerStrategy.getBuilderClassName(buildee, anno), filteredFields.size());
        filteredFields = InitializerStrategy.addFields(buildee, filteredFields, builder);
        this.buildCommon(buildee, anno, filteredFields, builder);
        boolean needsConstructor = !AnnotatedNodeUtils.hasAnnotation(buildee, TUPLECONS_TYPE) || force;
        InitializerStrategy.createBuildeeConstructors(buildee, builder, filteredFields, needsConstructor, useSetters);
    }

    private void createBuilderForAnnotatedMethod(BuilderASTTransformation transform, MethodNode mNode, AnnotationNode anno, boolean useSetters) {
        if (transform.getMemberValue(anno, "includes") != null || transform.getMemberValue(anno, "excludes") != null) {
            transform.addError("Error during " + BuilderASTTransformation.MY_TYPE_NAME + " processing: includes/excludes only allowed on classes", anno);
        }
        if (mNode instanceof ConstructorNode) {
            mNode.setModifiers(2);
        } else {
            if (!mNode.isStatic()) {
                transform.addError("Error during " + BuilderASTTransformation.MY_TYPE_NAME + " processing: method builders only allowed on static methods", anno);
            }
            mNode.setModifiers(4106);
        }
        ClassNode buildee = mNode.getDeclaringClass();
        Parameter[] parameters = mNode.getParameters();
        if (parameters.length == 0) {
            transform.addError("Error during " + BuilderASTTransformation.MY_TYPE_NAME + " processing: at least one parameter is required for this strategy", anno);
        }
        ClassNode builder = InitializerStrategy.createInnerHelperClass(buildee, InitializerStrategy.getBuilderClassName(buildee, anno), parameters.length);
        List<FieldNode> convertedFields = InitializerStrategy.convertParamsToFields(builder, parameters);
        this.buildCommon(buildee, anno, convertedFields, builder);
        if (mNode instanceof ConstructorNode) {
            InitializerStrategy.createBuildeeConstructors(buildee, builder, convertedFields, false, useSetters);
        } else {
            InitializerStrategy.createBuildeeMethods(buildee, mNode, builder, convertedFields);
        }
    }

    private static String getBuilderClassName(ClassNode buildee, AnnotationNode anno) {
        return AbstractASTTransformation.getMemberStringValue(anno, "builderClassName", buildee.getNameWithoutPackage() + "Initializer");
    }

    private static List<FieldNode> addFields(ClassNode buildee, List<FieldNode> filteredFields, ClassNode builder) {
        ArrayList<FieldNode> result = new ArrayList<FieldNode>();
        for (FieldNode filteredField : filteredFields) {
            FieldNode fieldCopy = InitializerStrategy.createFieldCopy(buildee, filteredField);
            builder.addField(fieldCopy);
            result.add(fieldCopy);
        }
        return result;
    }

    private void buildCommon(ClassNode buildee, AnnotationNode anno, List<FieldNode> fieldNodes, ClassNode builder) {
        String prefix = AbstractASTTransformation.getMemberStringValue(anno, "prefix", "");
        String buildMethodName = AbstractASTTransformation.getMemberStringValue(anno, "buildMethodName", "create");
        ClassNodeUtils.addGeneratedInnerClass(buildee, builder);
        InitializerStrategy.createBuilderConstructors(builder, buildee, fieldNodes);
        String builderMethodName = AbstractASTTransformation.getMemberStringValue(anno, "builderMethodName", "createInitializer");
        ClassNodeUtils.addGeneratedMethod(buildee, InitializerStrategy.createBuilderMethod(buildMethodName, builder, fieldNodes.size(), builderMethodName));
        for (int i2 = 0; i2 < fieldNodes.size(); ++i2) {
            ClassNodeUtils.addGeneratedMethod(builder, this.createBuilderMethodForField(builder, fieldNodes, prefix, i2));
        }
        ClassNodeUtils.addGeneratedMethod(builder, InitializerStrategy.createBuildMethod(builder, buildMethodName, fieldNodes));
    }

    private static List<FieldNode> convertParamsToFields(ClassNode builder, Parameter[] parameters) {
        ArrayList<FieldNode> fieldNodes = new ArrayList<FieldNode>();
        for (Parameter parameter : parameters) {
            Map<String, ClassNode> genericsSpec = GenericsUtils.createGenericsSpec(builder);
            ClassNode correctedType = GenericsUtils.correctToGenericsSpecRecurse(genericsSpec, parameter.getType());
            FieldNode fieldNode = new FieldNode("$" + parameter.getName(), parameter.getModifiers(), correctedType, builder, DEFAULT_INITIAL_VALUE);
            fieldNodes.add(fieldNode);
            builder.addField(fieldNode);
        }
        return fieldNodes;
    }

    private static ClassNode createInnerHelperClass(ClassNode buildee, String builderClassName, int fieldsSize) {
        String fullName = buildee.getName() + "$" + builderClassName;
        InnerClassNode builder = new InnerClassNode(buildee, fullName, 9, ClassHelper.OBJECT_TYPE);
        GenericsType[] gtypes = new GenericsType[fieldsSize];
        for (int i2 = 0; i2 < gtypes.length; ++i2) {
            gtypes[i2] = InitializerStrategy.makePlaceholder(i2);
        }
        builder.setGenericsTypes(gtypes);
        return builder;
    }

    private static MethodNode createBuilderMethod(String buildMethodName, ClassNode builder, int numFields, String builderMethodName) {
        BlockStatement body2 = new BlockStatement();
        body2.addStatement(GeneralUtils.returnS(GeneralUtils.callX(builder, buildMethodName)));
        ClassNode returnType = GenericsUtils.makeClassSafeWithGenerics(builder, InitializerStrategy.unsetGenTypes(numFields));
        return new MethodNode(builderMethodName, 9, returnType, BuilderASTTransformation.NO_PARAMS, BuilderASTTransformation.NO_EXCEPTIONS, body2);
    }

    private static GenericsType[] unsetGenTypes(int numFields) {
        GenericsType[] gtypes = new GenericsType[numFields];
        for (int i2 = 0; i2 < gtypes.length; ++i2) {
            gtypes[i2] = new GenericsType(ClassHelper.make(UNSET.class));
        }
        return gtypes;
    }

    private static GenericsType[] setGenTypes(int numFields) {
        GenericsType[] gtypes = new GenericsType[numFields];
        for (int i2 = 0; i2 < gtypes.length; ++i2) {
            gtypes[i2] = new GenericsType(ClassHelper.make(SET.class));
        }
        return gtypes;
    }

    private static void createBuilderConstructors(ClassNode builder, ClassNode buildee, List<FieldNode> fields) {
        ClassNodeUtils.addGeneratedConstructor(builder, 2, BuilderASTTransformation.NO_PARAMS, BuilderASTTransformation.NO_EXCEPTIONS, GeneralUtils.block(GeneralUtils.ctorSuperS()));
        BlockStatement body2 = GeneralUtils.block(GeneralUtils.ctorSuperS());
        InitializerStrategy.initializeFields(fields, body2, false, false);
        ClassNodeUtils.addGeneratedConstructor(builder, 2, InitializerStrategy.getParams(fields, buildee), BuilderASTTransformation.NO_EXCEPTIONS, body2);
    }

    private static void createBuildeeConstructors(ClassNode buildee, ClassNode builder, List<FieldNode> fields, boolean needsConstructor, boolean useSetters) {
        InitializerStrategy.createInitializerConstructor(buildee, builder, fields);
        if (needsConstructor) {
            BlockStatement body2 = GeneralUtils.block(GeneralUtils.ctorSuperS());
            InitializerStrategy.initializeFields(fields, body2, useSetters, true);
            ClassNodeUtils.addGeneratedConstructor(buildee, 2, InitializerStrategy.getParams(fields, buildee), BuilderASTTransformation.NO_EXCEPTIONS, body2);
        }
    }

    private static void createBuildeeMethods(ClassNode buildee, MethodNode mNode, ClassNode builder, List<FieldNode> fields) {
        ClassNode paramType = GenericsUtils.makeClassSafeWithGenerics(builder, InitializerStrategy.setGenTypes(fields.size()));
        ArrayList<Expression> argsList = new ArrayList<Expression>();
        Parameter initParam = GeneralUtils.param(paramType, "initializer");
        for (FieldNode fieldNode : fields) {
            argsList.add(GeneralUtils.propX((Expression)GeneralUtils.varX(initParam), fieldNode.getName()));
        }
        String newName = "$" + mNode.getName();
        ClassNodeUtils.addGeneratedMethod(buildee, mNode.getName(), 9, mNode.getReturnType(), GeneralUtils.params(GeneralUtils.param(paramType, "initializer")), BuilderASTTransformation.NO_EXCEPTIONS, GeneralUtils.block(GeneralUtils.stmt(GeneralUtils.callX(buildee, newName, (Expression)GeneralUtils.args(argsList)))));
        InitializerStrategy.renameMethod(buildee, mNode, newName);
    }

    private static void renameMethod(ClassNode buildee, MethodNode mNode, String newName) {
        ClassNodeUtils.addGeneratedMethod(buildee, newName, mNode.getModifiers(), mNode.getReturnType(), mNode.getParameters(), mNode.getExceptions(), mNode.getCode());
        buildee.removeMethod(mNode);
    }

    private static Parameter[] getParams(List<FieldNode> fields, ClassNode cNode) {
        Parameter[] parameters = new Parameter[fields.size()];
        for (int i2 = 0; i2 < parameters.length; ++i2) {
            FieldNode fNode = fields.get(i2);
            Map<String, ClassNode> genericsSpec = GenericsUtils.createGenericsSpec(fNode.getDeclaringClass());
            GenericsUtils.extractSuperClassGenerics(fNode.getType(), cNode, genericsSpec);
            ClassNode correctedType = GenericsUtils.correctToGenericsSpecRecurse(genericsSpec, fNode.getType());
            parameters[i2] = new Parameter(correctedType, fNode.getName().substring(1));
        }
        return parameters;
    }

    private static void createInitializerConstructor(ClassNode buildee, ClassNode builder, List<FieldNode> fields) {
        ClassNode paramType = GenericsUtils.makeClassSafeWithGenerics(builder, InitializerStrategy.setGenTypes(fields.size()));
        ArrayList<Expression> argsList = new ArrayList<Expression>();
        Parameter initParam = GeneralUtils.param(paramType, "initializer");
        for (FieldNode fieldNode : fields) {
            argsList.add(GeneralUtils.propX((Expression)GeneralUtils.varX(initParam), fieldNode.getName()));
        }
        ClassNodeUtils.addGeneratedConstructor(buildee, 1, GeneralUtils.params(GeneralUtils.param(paramType, "initializer")), BuilderASTTransformation.NO_EXCEPTIONS, GeneralUtils.block(GeneralUtils.ctorThisS(GeneralUtils.args(argsList))));
    }

    private static MethodNode createBuildMethod(ClassNode builder, String buildMethodName, List<FieldNode> fields) {
        ClassNode returnType = GenericsUtils.makeClassSafeWithGenerics(builder, InitializerStrategy.unsetGenTypes(fields.size()));
        return new MethodNode(buildMethodName, 9, returnType, BuilderASTTransformation.NO_PARAMS, BuilderASTTransformation.NO_EXCEPTIONS, GeneralUtils.block(GeneralUtils.returnS(GeneralUtils.ctorX(returnType))));
    }

    private MethodNode createBuilderMethodForField(ClassNode builder, List<FieldNode> fields, String prefix, int fieldPos) {
        String fieldName = fields.get(fieldPos).getName();
        String baseName = fieldName.substring(1);
        String setterName = this.getSetterName(prefix, baseName);
        GenericsType[] gtypes = new GenericsType[fields.size()];
        ArrayList<Expression> argList = new ArrayList<Expression>();
        for (int i2 = 0; i2 < fields.size(); ++i2) {
            gtypes[i2] = i2 == fieldPos ? new GenericsType(ClassHelper.make(SET.class)) : InitializerStrategy.makePlaceholder(i2);
            argList.add(GeneralUtils.propX((Expression)GeneralUtils.varX("this"), GeneralUtils.constX(fields.get(i2).getName())));
        }
        ClassNode returnType = GenericsUtils.makeClassSafeWithGenerics(builder, gtypes);
        FieldNode fNode = fields.get(fieldPos);
        Map<String, ClassNode> genericsSpec = GenericsUtils.createGenericsSpec(fNode.getDeclaringClass());
        GenericsUtils.extractSuperClassGenerics(fNode.getType(), builder, genericsSpec);
        ClassNode correctedType = GenericsUtils.correctToGenericsSpecRecurse(genericsSpec, fNode.getType());
        return new MethodNode(setterName, 1, returnType, GeneralUtils.params(GeneralUtils.param(correctedType, baseName)), BuilderASTTransformation.NO_EXCEPTIONS, GeneralUtils.block(GeneralUtils.stmt(GeneralUtils.assignX(GeneralUtils.propX((Expression)GeneralUtils.varX("this"), GeneralUtils.constX(fieldName)), GeneralUtils.varX(baseName, correctedType))), GeneralUtils.returnS(GeneralUtils.ctorX(returnType, GeneralUtils.args(argList)))));
    }

    private static GenericsType makePlaceholder(int i2) {
        ClassNode type = ClassHelper.makeWithoutCaching("T" + i2);
        type.setRedirect(ClassHelper.OBJECT_TYPE);
        type.setGenericsPlaceHolder(true);
        return new GenericsType(type);
    }

    private static FieldNode createFieldCopy(ClassNode buildee, FieldNode fNode) {
        Map<String, ClassNode> genericsSpec = GenericsUtils.createGenericsSpec(fNode.getDeclaringClass());
        GenericsUtils.extractSuperClassGenerics(fNode.getType(), buildee, genericsSpec);
        ClassNode correctedType = GenericsUtils.correctToGenericsSpecRecurse(genericsSpec, fNode.getType());
        return new FieldNode("$" + fNode.getName(), fNode.getModifiers(), correctedType, buildee, DEFAULT_INITIAL_VALUE);
    }

    private static List<FieldNode> filterFields(List<FieldNode> fieldNodes, List<String> includes, List<String> excludes, boolean allNames) {
        ArrayList<FieldNode> fields = new ArrayList<FieldNode>();
        for (FieldNode fNode : fieldNodes) {
            if (AbstractASTTransformation.shouldSkipUndefinedAware(fNode.getName(), excludes, includes, allNames)) continue;
            fields.add(fNode);
        }
        return fields;
    }

    private static void initializeFields(List<FieldNode> fields, BlockStatement body2, boolean useSetters, boolean adjustForDollar) {
        for (FieldNode field : fields) {
            String fromName = field.getName().substring(1);
            String toName = adjustForDollar ? fromName : field.getName();
            body2.addStatement(GeneralUtils.stmt(useSetters && !field.isFinal() ? GeneralUtils.callThisX(GeneralUtils.getSetterName(fromName), GeneralUtils.varX(GeneralUtils.param(field.getType(), fromName))) : GeneralUtils.assignX(GeneralUtils.propX((Expression)GeneralUtils.varX("this"), toName), GeneralUtils.varX(GeneralUtils.param(field.getType(), fromName)))));
        }
    }

    public static abstract class UNSET {
    }

    public static abstract class SET {
    }
}

