/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence.store;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.util.Arrays;
import org.apache.ignite.internal.fileio.FileIo;
import org.apache.ignite.internal.fileio.FileIoFactory;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.pagememory.persistence.store.AbstractFilePageStoreIo;
import org.apache.ignite.internal.pagememory.persistence.store.DeltaFilePageStoreIoHeader;
import org.apache.ignite.internal.pagememory.persistence.store.PageStoreUtils;
import org.apache.ignite.internal.pagememory.util.PageIdUtils;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;

public class DeltaFilePageStoreIo
extends AbstractFilePageStoreIo {
    private final DeltaFilePageStoreIoHeader header;
    private final IgniteSpinBusyLock mergedBusyLock = new IgniteSpinBusyLock();

    public DeltaFilePageStoreIo(FileIoFactory ioFactory, Path filePath, DeltaFilePageStoreIoHeader header) {
        super(ioFactory, filePath);
        this.header = header;
    }

    @Override
    public int pageSize() {
        return this.header.pageSize();
    }

    @Override
    public int headerSize() {
        return this.header.headerSize();
    }

    @Override
    public ByteBuffer headerBuffer() {
        return this.header.toByteBuffer();
    }

    @Override
    public void checkHeader(FileIo fileIo) throws IOException {
        DeltaFilePageStoreIoHeader header = DeltaFilePageStoreIoHeader.readHeader(fileIo, ByteBuffer.allocate(this.pageSize()).order(ByteOrder.nativeOrder()));
        if (header == null) {
            throw new IOException("Missing file header");
        }
        PageStoreUtils.checkFileVersion(this.header.version(), header.version());
        DeltaFilePageStoreIoHeader.checkFileIndex(this.header.index(), header.index());
        PageStoreUtils.checkFilePageSize(this.header.pageSize(), header.pageSize());
        DeltaFilePageStoreIoHeader.checkFilePageIndexes(this.header.pageIndexes(), header.pageIndexes());
    }

    @Override
    public long pageOffset(long pageId) {
        return this.pageOffset(PageIdUtils.pageIndex(pageId));
    }

    public long pageOffset(int pageIdx) {
        int searchResult = Arrays.binarySearch(this.header.pageIndexes(), pageIdx);
        if (searchResult < 0) {
            return -1L;
        }
        return (long)searchResult * (long)this.pageSize() + (long)this.headerSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readWithMergedToFilePageStoreCheck(long pageId, long pageOff, ByteBuffer pageBuf, boolean keepCrc) throws IgniteInternalCheckedException {
        if (!this.mergedBusyLock.enterBusy()) {
            return false;
        }
        try {
            super.read(pageId, pageOff, pageBuf, keepCrc);
            boolean bl = true;
            return bl;
        }
        finally {
            this.mergedBusyLock.leaveBusy();
        }
    }

    public int fileIndex() {
        return this.header.index();
    }

    public void markMergedToFilePageStore() {
        this.mergedBusyLock.block();
    }

    public int[] pageIndexes() {
        return this.header.pageIndexes();
    }
}

