/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.nio.charset.Charset;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqlPostfixOperator
extends SqlOperator {
    public SqlPostfixOperator(String name, SqlKind kind, int prec, @Nullable SqlReturnTypeInference returnTypeInference, @Nullable SqlOperandTypeInference operandTypeInference, @Nullable SqlOperandTypeChecker operandTypeChecker) {
        super(name, kind, SqlPostfixOperator.leftPrec(prec, true), SqlPostfixOperator.rightPrec(prec, true), returnTypeInference, operandTypeInference, operandTypeChecker);
    }

    @Override
    public SqlSyntax getSyntax() {
        return SqlSyntax.POSTFIX;
    }

    @Override
    public @Nullable String getSignatureTemplate(int operandsCount) {
        Util.discard(operandsCount);
        return "{1} {0}";
    }

    @Override
    protected RelDataType adjustType(SqlValidator validator, SqlCall call, RelDataType type) {
        if (SqlTypeUtil.inCharFamily(type)) {
            RelDataType operandType = validator.getValidatedNodeType((SqlNode)call.operand(0));
            if (null == operandType) {
                throw new AssertionError((Object)"operand's type should have been derived");
            }
            if (SqlTypeUtil.inCharFamily(operandType)) {
                SqlCollation collation = operandType.getCollation();
                assert (null != collation) : "An implicit or explicit collation should have been set";
                type = validator.getTypeFactory().createTypeWithCharsetAndCollation(type, (Charset)Nullness.castNonNull((Object)type.getCharset()), collation);
            }
        }
        return type;
    }

    @Override
    public boolean validRexOperands(int count, Litmus litmus) {
        if (count != 1) {
            return litmus.fail("wrong operand count {} for {}", count, this);
        }
        return litmus.succeed();
    }
}

