/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler.requests.table;

import java.util.BitSet;
import java.util.List;
import org.apache.ignite.client.handler.requests.table.ClientTableCommon;
import org.apache.ignite.internal.binarytuple.BinaryTupleReader;
import org.apache.ignite.internal.client.table.MutableTupleBinaryTupleAdapter;
import org.apache.ignite.internal.schema.Column;
import org.apache.ignite.internal.schema.SchemaAware;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.lang.util.IgniteNameUtils;
import org.apache.ignite.sql.ColumnType;
import org.apache.ignite.table.Tuple;
import org.jetbrains.annotations.Nullable;

class ClientHandlerTuple
extends MutableTupleBinaryTupleAdapter
implements SchemaAware {
    private final SchemaDescriptor schema;
    private final boolean keyOnly;

    ClientHandlerTuple(SchemaDescriptor schema, @Nullable BitSet noValueSet, BinaryTupleReader tuple, boolean keyOnly) {
        super(tuple, tuple.elementCount(), noValueSet);
        assert (tuple.elementCount() == (keyOnly ? schema.keyColumns().size() : schema.length())) : "Tuple element count mismatch";
        this.schema = schema;
        this.keyOnly = keyOnly;
    }

    @Nullable
    public SchemaDescriptor schema() {
        return this.binaryTuple() != null ? this.schema : null;
    }

    public Tuple set(String columnName, @Nullable Object value) {
        throw new UnsupportedOperationException("Operation not supported.");
    }

    protected String schemaColumnName(int binaryTupleIndex) {
        return this.schema.column(binaryTupleIndex).name();
    }

    protected int binaryTupleIndex(String columnName) {
        Column column = this.schema.column(IgniteNameUtils.parseIdentifier((String)columnName));
        if (column == null) {
            return -1;
        }
        if (this.keyOnly) {
            return column.positionInKey();
        }
        return column.positionInRow();
    }

    protected int binaryTupleIndex(int publicIndex) {
        return this.keyOnly ? ((Column)this.schema.keyColumns().get(publicIndex)).positionInRow() : super.binaryTupleIndex(publicIndex);
    }

    protected int publicIndex(int binaryTupleIndex) {
        if (this.keyOnly) {
            Column col = (Column)this.schema.keyColumns().get(binaryTupleIndex);
            return col.positionInKey();
        }
        return super.publicIndex(binaryTupleIndex);
    }

    protected ColumnType schemaColumnType(int binaryTupleIndex) {
        return this.column(binaryTupleIndex).type().spec();
    }

    protected int schemaDecimalScale(int binaryTupleIndex) {
        return ClientTableCommon.getDecimalScale(this.column(binaryTupleIndex).type());
    }

    private Column column(int binaryTupleIndex) {
        List columns = this.keyOnly ? this.schema.keyColumns() : this.schema.columns();
        return (Column)columns.get(binaryTupleIndex);
    }
}

