/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.fileio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.ignite.internal.fileio.AbstractFileIo;

public class RandomAccessFileIo
extends AbstractFileIo {
    private final FileChannel ch;

    public RandomAccessFileIo(Path filePath, OpenOption ... modes) throws IOException {
        this.ch = FileChannel.open(filePath, modes);
    }

    @Override
    public long position() throws IOException {
        return this.ch.position();
    }

    @Override
    public void position(long newPosition) throws IOException {
        this.ch.position(newPosition);
    }

    @Override
    public int read(ByteBuffer destBuf) throws IOException {
        return this.ch.read(destBuf);
    }

    @Override
    public int read(ByteBuffer destBuf, long position) throws IOException {
        return this.ch.read(destBuf, position);
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        return this.ch.read(ByteBuffer.wrap(buf, off, len));
    }

    @Override
    public int write(ByteBuffer srcBuf) throws IOException {
        return this.ch.write(srcBuf);
    }

    @Override
    public int write(ByteBuffer srcBuf, long position) throws IOException {
        return this.ch.write(srcBuf, position);
    }

    @Override
    public int write(byte[] buf, int off, int len) throws IOException {
        return this.ch.write(ByteBuffer.wrap(buf, off, len));
    }

    @Override
    public void force(boolean withMetadata) throws IOException {
        this.ch.force(withMetadata);
    }

    @Override
    public void force() throws IOException {
        this.force(false);
    }

    @Override
    public long size() throws IOException {
        return this.ch.size();
    }

    @Override
    public void clear() throws IOException {
        this.ch.truncate(0L);
    }

    @Override
    public void close() throws IOException {
        this.ch.close();
    }

    @Override
    public MappedByteBuffer map(int sizeBytes) throws IOException {
        return this.ch.map(FileChannel.MapMode.READ_WRITE, 0L, sizeBytes);
    }
}

