/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.junit;

import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.mockito.internal.junit.JUnitSessionStore;
import org.mockito.junit.MockitoTestRule;
import org.mockito.plugins.MockitoLogger;
import org.mockito.quality.Strictness;

public final class JUnitTestRule
implements MockitoTestRule {
    private final Object testInstance;
    private final JUnitSessionStore sessionStore;

    public JUnitTestRule(MockitoLogger logger, Strictness strictness, Object testInstance) {
        this.sessionStore = new JUnitSessionStore(logger, strictness);
        this.testInstance = testInstance;
    }

    public Statement apply(Statement base, Description description) {
        return this.sessionStore.createStatement(base, description.getDisplayName(), this.testInstance);
    }

    @Override
    public MockitoTestRule silent() {
        return this.strictness(Strictness.LENIENT);
    }

    @Override
    public MockitoTestRule strictness(Strictness strictness) {
        this.sessionStore.setStrictness(strictness);
        return this;
    }
}

