/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kms.model.GrantListEntry;
import com.amazonaws.services.kms.model.transform.GrantConstraintsJsonMarshaller;

public class GrantListEntryJsonMarshaller {
    private static GrantListEntryJsonMarshaller instance;

    public void marshall(GrantListEntry grantListEntry, StructuredJsonGenerator jsonGenerator) {
        if (grantListEntry == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList operationsList;
            jsonGenerator.writeStartObject();
            if (grantListEntry.getKeyId() != null) {
                jsonGenerator.writeFieldName("KeyId").writeValue(grantListEntry.getKeyId());
            }
            if (grantListEntry.getGrantId() != null) {
                jsonGenerator.writeFieldName("GrantId").writeValue(grantListEntry.getGrantId());
            }
            if (grantListEntry.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(grantListEntry.getName());
            }
            if (grantListEntry.getCreationDate() != null) {
                jsonGenerator.writeFieldName("CreationDate").writeValue(grantListEntry.getCreationDate());
            }
            if (grantListEntry.getGranteePrincipal() != null) {
                jsonGenerator.writeFieldName("GranteePrincipal").writeValue(grantListEntry.getGranteePrincipal());
            }
            if (grantListEntry.getRetiringPrincipal() != null) {
                jsonGenerator.writeFieldName("RetiringPrincipal").writeValue(grantListEntry.getRetiringPrincipal());
            }
            if (grantListEntry.getIssuingAccount() != null) {
                jsonGenerator.writeFieldName("IssuingAccount").writeValue(grantListEntry.getIssuingAccount());
            }
            if (!(operationsList = (SdkInternalList)grantListEntry.getOperations()).isEmpty() || !operationsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Operations");
                jsonGenerator.writeStartArray();
                for (String operationsListValue : operationsList) {
                    if (operationsListValue == null) continue;
                    jsonGenerator.writeValue(operationsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (grantListEntry.getConstraints() != null) {
                jsonGenerator.writeFieldName("Constraints");
                GrantConstraintsJsonMarshaller.getInstance().marshall(grantListEntry.getConstraints(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static GrantListEntryJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new GrantListEntryJsonMarshaller();
        }
        return instance;
    }
}

