/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeLoadBalancerPolicyTypesRequestMarshaller
implements Marshaller<Request<DescribeLoadBalancerPolicyTypesRequest>, DescribeLoadBalancerPolicyTypesRequest> {
    public Request<DescribeLoadBalancerPolicyTypesRequest> marshall(DescribeLoadBalancerPolicyTypesRequest describeLoadBalancerPolicyTypesRequest) {
        if (describeLoadBalancerPolicyTypesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeLoadBalancerPolicyTypesRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "DescribeLoadBalancerPolicyTypes");
        request.addParameter("Version", "2012-06-01");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList policyTypeNamesList = (SdkInternalList)describeLoadBalancerPolicyTypesRequest.getPolicyTypeNames();
        if (!policyTypeNamesList.isEmpty() || !policyTypeNamesList.isAutoConstruct()) {
            int policyTypeNamesListIndex = 1;
            for (String policyTypeNamesListValue : policyTypeNamesList) {
                if (policyTypeNamesListValue != null) {
                    request.addParameter("PolicyTypeNames.member." + policyTypeNamesListIndex, StringUtils.fromString((String)policyTypeNamesListValue));
                }
                ++policyTypeNamesListIndex;
            }
        }
        return request;
    }
}

