/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.cassandra.utils;

import com.datastax.dse.driver.api.core.cql.reactive.ReactiveResultSet;
import com.datastax.dse.driver.api.core.cql.reactive.ReactiveRow;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import java.util.Optional;
import javax.inject.Inject;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraAsyncExecutor {
    private final CqlSession session;

    @Inject
    public CassandraAsyncExecutor(CqlSession session) {
        this.session = session;
    }

    private ReactiveResultSet execute(Statement statement) {
        return this.session.executeReactive(statement);
    }

    public Mono<Boolean> executeReturnApplied(Statement statement) {
        return Mono.defer(() -> Mono.from((Publisher)this.execute(statement))).map(ReactiveRow::wasApplied);
    }

    public Mono<Void> executeVoid(Statement statement) {
        return Mono.defer(() -> Mono.from((Publisher)this.execute(statement))).then();
    }

    public Mono<Row> executeSingleRow(Statement statement) {
        return Mono.defer(() -> Mono.from((Publisher)this.execute(statement)));
    }

    public Flux<Row> executeRows(Statement statement) {
        return Flux.defer(() -> Flux.from((Publisher)this.execute(statement)));
    }

    public Mono<Optional<Row>> executeSingleRowOptional(Statement statement) {
        return this.executeSingleRow(statement).map(Optional::ofNullable).switchIfEmpty(Mono.just(Optional.empty()));
    }

    public Mono<Boolean> executeReturnExists(Statement statement) {
        return this.executeSingleRow(statement).hasElement();
    }
}

