/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.mail;

import java.io.Serializable;
import java.util.Collection;
import javax.inject.Inject;
import org.apache.james.jmap.api.model.Size$;
import org.apache.james.jmap.api.projections.MessageFastViewPrecomputedProperties;
import org.apache.james.jmap.api.projections.MessageFastViewProjection;
import org.apache.james.jmap.core.UTCDate;
import org.apache.james.jmap.core.UTCDate$;
import org.apache.james.jmap.mail.BlobId;
import org.apache.james.jmap.mail.BlobId$;
import org.apache.james.jmap.mail.Email$;
import org.apache.james.jmap.mail.EmailBodyMetadata;
import org.apache.james.jmap.mail.EmailFastView;
import org.apache.james.jmap.mail.EmailFastViewReader$;
import org.apache.james.jmap.mail.EmailFullView;
import org.apache.james.jmap.mail.EmailFullViewFactory;
import org.apache.james.jmap.mail.EmailGetRequest;
import org.apache.james.jmap.mail.EmailHeaderValue;
import org.apache.james.jmap.mail.EmailHeaders;
import org.apache.james.jmap.mail.EmailHeaders$;
import org.apache.james.jmap.mail.EmailMetadata;
import org.apache.james.jmap.mail.EmailView;
import org.apache.james.jmap.mail.EmailViewReader;
import org.apache.james.jmap.mail.FastViewAvailable;
import org.apache.james.jmap.mail.FastViewResult;
import org.apache.james.jmap.mail.FastViewUnavailable;
import org.apache.james.jmap.mail.GenericEmailViewReader;
import org.apache.james.jmap.mail.Keywords;
import org.apache.james.jmap.mail.KeywordsFactory$;
import org.apache.james.jmap.mail.MailboxIds;
import org.apache.james.jmap.method.ZoneIdProvider;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.util.html.HtmlTextExtractor;
import org.slf4j.Logger;
import reactor.core.Disposable;
import reactor.core.publisher.SynchronousSink;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono$;
import reactor.core.scheduler.Schedulers;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005%w!B\n\u0015\u0011\u0003yb!B\u0011\u0015\u0011\u0003\u0011\u0003\"B\u0015\u0002\t\u0003Q\u0003bB\u0016\u0002\u0005\u0004%\t\u0001\f\u0005\u0007g\u0005\u0001\u000b\u0011B\u0017\u0007\t\u0005\"B\u0001\u000e\u0005\tw\u0015\u0011\t\u0011)A\u0005y!A!)\u0002B\u0001B\u0003%1\t\u0003\u0005L\u000b\t\u0005\t\u0015!\u0003M\u0011!!VA!A!\u0002\u0013)\u0006\u0002C.\u0006\u0005\u0003\u0005\u000b\u0011\u0002/\t\u000b%*A\u0011A0\t\u000f=,!\u0019!C\u0005a\"1q/\u0002Q\u0001\nEDQ\u0001_\u0003\u0005BeDq!!\u0017\u0006\t\u0013\tY\u0006C\u0004\u0002v\u0015!I!a\u001e\t\u000f\u0005\u0015U\u0001\"\u0003\u0002\b\"9\u00111T\u0003\u0005\n\u0005u\u0015aE#nC&dg)Y:u-&,wOU3bI\u0016\u0014(BA\u000b\u0017\u0003\u0011i\u0017-\u001b7\u000b\u0005]A\u0012\u0001\u00026nCBT!!\u0007\u000e\u0002\u000b)\fW.Z:\u000b\u0005ma\u0012AB1qC\u000eDWMC\u0001\u001e\u0003\ry'oZ\u0002\u0001!\t\u0001\u0013!D\u0001\u0015\u0005M)U.Y5m\r\u0006\u001cHOV5foJ+\u0017\rZ3s'\t\t1\u0005\u0005\u0002%O5\tQEC\u0001'\u0003\u0015\u00198-\u00197b\u0013\tASE\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}\ta\u0001\\8hO\u0016\u0014X#A\u0017\u0011\u00059\nT\"A\u0018\u000b\u0005Ab\u0012!B:mMRR\u0017B\u0001\u001a0\u0005\u0019aunZ4fe\u00069An\\4hKJ\u00043cA\u0003$kA\u0019\u0001E\u000e\u001d\n\u0005]\"\"aD#nC&dg+[3x%\u0016\fG-\u001a:\u0011\u0005\u0001J\u0014B\u0001\u001e\u0015\u0005%)U.Y5m-&,w/\u0001\tnKN\u001c\u0018mZ3JI6\u000bg.Y4feB\u0011Q\bQ\u0007\u0002})\u0011q\bG\u0001\b[\u0006LGNY8y\u0013\t\teH\u0001\tNKN\u001c\u0018mZ3JI6\u000bg.Y4fe\u0006IR.Z:tC\u001e,g)Y:u-&,w\u000f\u0015:pU\u0016\u001cG/[8o!\t!\u0015*D\u0001F\u0015\t1u)A\u0006qe>TWm\u0019;j_:\u001c(B\u0001%\u0017\u0003\r\t\u0007/[\u0005\u0003\u0015\u0016\u0013\u0011$T3tg\u0006<WMR1tiZKWm\u001e)s_*,7\r^5p]\u0006\t\u0002\u000e^7m)\u0016DH/\u0012=ue\u0006\u001cGo\u001c:\u0011\u00055\u0013V\"\u0001(\u000b\u0005=\u0003\u0016\u0001\u00025u[2T!!\u0015\r\u0002\tU$\u0018\u000e\\\u0005\u0003':\u0013\u0011\u0003\u0013;nYR+\u0007\u0010^#yiJ\f7\r^8s\u00039QxN\\3JIB\u0013xN^5eKJ\u0004\"AV-\u000e\u0003]S!\u0001\u0017\f\u0002\r5,G\u000f[8e\u0013\tQvK\u0001\b[_:,\u0017\n\u001a)s_ZLG-\u001a:\u0002\u001f\u0019,H\u000e\u001c,jK^4\u0015m\u0019;pef\u0004\"\u0001I/\n\u0005y#\"\u0001F#nC&dg)\u001e7m-&,wOR1di>\u0014\u0018\u0010\u0006\u0004aC\n\u001cG-\u001a\t\u0003A\u0015AQaO\u0006A\u0002qBQAQ\u0006A\u0002\rCQaS\u0006A\u00021CQ\u0001V\u0006A\u0002UCQaW\u0006A\u0002qC#aC4\u0011\u0005!lW\"A5\u000b\u0005)\\\u0017AB5oU\u0016\u001cGOC\u0001m\u0003\u0015Q\u0017M^1y\u0013\tq\u0017N\u0001\u0004J]*,7\r^\u0001\u000bMVdGNU3bI\u0016\u0014X#A9\u0011\u0007\u0001\u0012H/\u0003\u0002t)\t1r)\u001a8fe&\u001cW)\\1jYZKWm\u001e*fC\u0012,'\u000f\u0005\u0002!k&\u0011a\u000f\u0006\u0002\u000e\u000b6\f\u0017\u000e\u001c$vY24\u0016.Z<\u0002\u0017\u0019,H\u000e\u001c*fC\u0012,'\u000fI\u0001\u0005e\u0016\fG-F\u0002{\u0003#!ra_A\u000f\u0003\u000b\ny\u0005E\u0003}\u0003\u0013\ti!D\u0001~\u0015\tqx0A\u0005qk\nd\u0017n\u001d5fe*\u0019a%!\u0001\u000b\t\u0005\r\u0011QA\u0001\u0005G>\u0014XM\u0003\u0002\u0002\b\u00059!/Z1di>\u0014\u0018bAA\u0006{\n)1K\u00127vqB!\u0011qBA\t\u0019\u0001!q!a\u0005\u000f\u0005\u0004\t)BA\u0001U#\rA\u0014q\u0003\t\u0004I\u0005e\u0011bAA\u000eK\t\u0019\u0011I\\=\t\u000f\u0005}a\u00021\u0001\u0002\"\u0005\u0019\u0011\u000eZ:\u0011\r\u0005\r\u00121GA\u001d\u001d\u0011\t)#a\f\u000f\t\u0005\u001d\u0012QF\u0007\u0003\u0003SQ1!a\u000b\u001f\u0003\u0019a$o\\8u}%\ta%C\u0002\u00022\u0015\nq\u0001]1dW\u0006<W-\u0003\u0003\u00026\u0005]\"aA*fc*\u0019\u0011\u0011G\u0013\u0011\t\u0005m\u0012\u0011I\u0007\u0003\u0003{Q1!a\u0010?\u0003\u0015iw\u000eZ3m\u0013\u0011\t\u0019%!\u0010\u0003\u00135+7o]1hK&#\u0007bBA$\u001d\u0001\u0007\u0011\u0011J\u0001\be\u0016\fX/Z:u!\r\u0001\u00131J\u0005\u0004\u0003\u001b\"\"aD#nC&dw)\u001a;SKF,Xm\u001d;\t\u000f\u0005Ec\u00021\u0001\u0002T\u0005qQ.Y5mE>D8+Z:tS>t\u0007cA\u001f\u0002V%\u0019\u0011q\u000b \u0003\u001d5\u000b\u0017\u000e\u001c2pqN+7o]5p]\u0006aAo\\#nC&dg+[3xgV!\u0011QLA2)!\ty&!\u001a\u0002r\u0005M\u0004#\u0002?\u0002\n\u0005\u0005\u0004\u0003BA\b\u0003G\"q!a\u0005\u0010\u0005\u0004\t)\u0002C\u0004\u0002h=\u0001\r!!\u001b\u0002\u000fI,7/\u001e7ugB1\u00111EA\u001a\u0003W\u00022\u0001IA7\u0013\r\ty\u0007\u0006\u0002\u000f\r\u0006\u001cHOV5foJ+7/\u001e7u\u0011\u001d\t9e\u0004a\u0001\u0003\u0013Bq!!\u0015\u0010\u0001\u0004\t\u0019&\u0001\nti>\u0014Xm\u00148DC\u000eDW-T5tg\u0016\u001cH\u0003BA=\u0003\u0003\u0003B!a\u001f\u0002~5\u0011\u0011\u0011A\u0005\u0005\u0003\u007f\n\tA\u0001\u0006ESN\u0004xn]1cY\u0016Da!a!\u0011\u0001\u0004!\u0018\u0001\u00034vY24\u0016.Z<\u0002\u0017Q|g)Y:u-&,wo\u001d\u000b\t\u0003\u0013\u000bY)a&\u0002\u001aB!A0!\u00039\u0011\u001d\ti)\u0005a\u0001\u0003\u001f\u000b\u0011BZ1tiZKWm^:\u0011\r\u0005\r\u00121GAI!\r\u0001\u00131S\u0005\u0004\u0003+#\"!\u0005$bgR4\u0016.Z<Bm\u0006LG.\u00192mK\"9\u0011qI\tA\u0002\u0005%\u0003bBA)#\u0001\u0007\u00111K\u0001\bi>,U.Y5m)\u0011\ty*a2\u0015\r\u0005\u0005\u00161VA_!\u0015\t\u0019+a*9\u001b\t\t)K\u0003\u0002RK%!\u0011\u0011VAS\u0005\r!&/\u001f\u0005\b\u0003[\u0013\u0002\u0019AAX\u0003\u001diWm]:bO\u0016\u0004r\u0001JAY\u0003s\t),C\u0002\u00024\u0016\u0012a\u0001V;qY\u0016\u0014\u0004CBA\u0012\u0003g\t9\f\u0005\u0003\u0002<\u0005e\u0016\u0002BA^\u0003{\u0011Q\"T3tg\u0006<WMU3tk2$\bbBA`%\u0001\u0007\u0011\u0011Y\u0001\tM\u0006\u001cHOV5foB\u0019A)a1\n\u0007\u0005\u0015WI\u0001\u0013NKN\u001c\u0018mZ3GCN$h+[3x!J,7m\\7qkR,G\r\u0015:pa\u0016\u0014H/[3t\u0011\u001d\t9E\u0005a\u0001\u0003\u0013\u0002")
public class EmailFastViewReader
implements EmailViewReader<EmailView> {
    private final MessageIdManager messageIdManager;
    private final MessageFastViewProjection messageFastViewProjection;
    private final ZoneIdProvider zoneIdProvider;
    private final GenericEmailViewReader<EmailFullView> fullReader;

    public static Logger logger() {
        return EmailFastViewReader$.MODULE$.logger();
    }

    private GenericEmailViewReader<EmailFullView> fullReader() {
        return this.fullReader;
    }

    @Override
    public <T> SFlux<T> read(scala.collection.immutable.Seq<MessageId> ids, EmailGetRequest request, MailboxSession mailboxSession) {
        return SMono$.MODULE$.fromPublisher(this.messageFastViewProjection.retrieve((Collection)CollectionConverters$.MODULE$.SeqHasAsJava(ids).asJava())).map((Function1 & Serializable)x$28 -> CollectionConverters$.MODULE$.MapHasAsScala(x$28).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).map((Function1 & Serializable)fastViews -> (scala.collection.immutable.Seq)ids.map((Function1 & Serializable)id -> (Product)fastViews.get(id).map((Function1 & Serializable)x$29 -> new FastViewAvailable((MessageId)id, (MessageFastViewPrecomputedProperties)x$29)).getOrElse((Function0 & Serializable)() -> new FastViewUnavailable((MessageId)id)))).flatMapMany((Function1 & Serializable)results -> this.toEmailViews((scala.collection.immutable.Seq<FastViewResult>)results, request, mailboxSession));
    }

    private <T> SFlux<T> toEmailViews(scala.collection.immutable.Seq<FastViewResult> results, EmailGetRequest request, MailboxSession mailboxSession) {
        scala.collection.immutable.Seq availables = (scala.collection.immutable.Seq)results.flatMap((Function1 & Serializable)x0$1 -> {
            FastViewResult fastViewResult = x0$1;
            if (fastViewResult instanceof FastViewAvailable) {
                FastViewAvailable fastViewAvailable = (FastViewAvailable)fastViewResult;
                return new Some((Object)fastViewAvailable);
            }
            return None$.MODULE$;
        });
        scala.collection.immutable.Seq unavailables = (scala.collection.immutable.Seq)results.flatMap((Function1 & Serializable)x0$2 -> {
            FastViewResult fastViewResult = x0$2;
            if (fastViewResult instanceof FastViewUnavailable) {
                FastViewUnavailable fastViewUnavailable = (FastViewUnavailable)fastViewResult;
                return new Some((Object)fastViewUnavailable);
            }
            return None$.MODULE$;
        });
        return SFlux$.MODULE$.merge((scala.collection.immutable.Seq)new .colon.colon(this.toFastViews((scala.collection.immutable.Seq<FastViewAvailable>)availables, request, mailboxSession), (List)new .colon.colon((Object)this.fullReader().read((scala.collection.immutable.Seq<MessageId>)((scala.collection.immutable.Seq)unavailables.map((Function1 & Serializable)x$30 -> x$30.id())), request, mailboxSession).doOnNext((Function1 & Serializable)fullView -> {
            this.storeOnCacheMisses(fullView);
            return BoxedUnit.UNIT;
        }), (List)Nil$.MODULE$)), SFlux$.MODULE$.merge$default$2(), SFlux$.MODULE$.merge$default$3());
    }

    private Disposable storeOnCacheMisses(EmailFullView fullView) {
        return SMono$.MODULE$.fromPublisher(this.messageFastViewProjection.store(fullView.metadata().id(), MessageFastViewPrecomputedProperties.builder().preview(fullView.bodyMetadata().preview()).hasAttachment(fullView.bodyMetadata().hasAttachment()).build())).doOnError((Function1 & Serializable)e -> {
            EmailFastViewReader.$anonfun$storeOnCacheMisses$1(fullView, e);
            return BoxedUnit.UNIT;
        }).subscribeOn(Schedulers.parallel()).subscribe();
    }

    private SFlux<EmailView> toFastViews(scala.collection.immutable.Seq<FastViewAvailable> fastViews, EmailGetRequest request, MailboxSession mailboxSession) {
        Map fastViewsAsMap = ((IterableOnceOps)fastViews.map((Function1 & Serializable)e -> new Tuple2((Object)e.id(), (Object)e.fastView()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Seq ids = (scala.collection.immutable.Seq)fastViews.map((Function1 & Serializable)x$31 -> x$31.id());
        return SFlux$.MODULE$.fromPublisher(this.messageIdManager.getMessagesReactive((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ids).asJava(), FetchGroup.HEADERS, mailboxSession)).collectSeq().flatMapIterable((Function1 & Serializable)messages -> messages.groupBy((Function1 & Serializable)x$32 -> x$32.getMessageId()).toSet()).map((Function1 & Serializable)x -> this.toEmail(request, (Tuple2<MessageId, scala.collection.immutable.Seq<MessageResult>>)x, (MessageFastViewPrecomputedProperties)fastViewsAsMap.apply(x._1()))).handle((Function2 & Serializable)(aTry, sink) -> {
            EmailFastViewReader.$anonfun$toFastViews$6(aTry, sink);
            return BoxedUnit.UNIT;
        });
    }

    private Try<EmailView> toEmail(EmailGetRequest request, Tuple2<MessageId, scala.collection.immutable.Seq<MessageResult>> message, MessageFastViewPrecomputedProperties fastView) {
        MessageId messageId = (MessageId)message._1();
        MailboxIds mailboxIds = new MailboxIds((List<MailboxId>)((IterableOnceOps)((IterableOps)message._2()).map((Function1 & Serializable)x$33 -> x$33.getMailboxId())).toList());
        String threadId = ((MessageResult)((IterableOps)message._2()).head()).getThreadId().serialize();
        return ((Try)((IterableOps)message._2()).headOption().map((Function1 & Serializable)x$34 -> new Success(x$34)).getOrElse((Function0 & Serializable)() -> new Failure((Throwable)new IllegalArgumentException("No message supplied")))).flatMap((Function1 & Serializable)firstMessage -> Email$.MODULE$.parseAsMime4JMessage((MessageResult)firstMessage).flatMap((Function1 & Serializable)mime4JMessage -> BlobId$.MODULE$.of(messageId).flatMap((Function1 & Serializable)blobId -> KeywordsFactory$.MODULE$.LENIENT_KEYWORDS_FACTORY().fromFlags(firstMessage.getFlags()).map((Function1 & Serializable)keywords -> {
            MessageId x$1 = messageId;
            BlobId x$2 = blobId;
            String x$3 = threadId;
            MailboxIds x$4 = mailboxIds;
            UTCDate x$5 = UTCDate$.MODULE$.from(firstMessage.getInternalDate(), $this.zoneIdProvider.get());
            Long x$6 = Size$.MODULE$.sanitizeSize(firstMessage.getSize());
            Keywords x$7 = keywords;
            EmailMetadata x$8 = new EmailMetadata(x$1, x$2, x$3, x$7, x$4, x$6, x$5);
            EmailBodyMetadata x$9 = new EmailBodyMetadata(fastView.hasAttachment(), fastView.getPreview());
            EmailHeaders x$10 = EmailHeaders$.MODULE$.from($this.zoneIdProvider.get(), (Message)mime4JMessage);
            Map<String, Option<EmailHeaderValue>> x$11 = EmailHeaders$.MODULE$.extractSpecificHeaders(request.properties(), $this.zoneIdProvider.get(), mime4JMessage.getHeader());
            return new EmailFastView(x$8, x$10, x$9, x$11);
        }))));
    }

    public static final /* synthetic */ void $anonfun$storeOnCacheMisses$1(EmailFullView fullView$1, Throwable e) {
        EmailFastViewReader$.MODULE$.logger().error(new StringBuilder(61).append("Cannot store the projection to MessageFastViewProjection for ").append(fullView$1.metadata().id()).toString(), e);
    }

    public static final /* synthetic */ void $anonfun$toFastViews$6(Try aTry, SynchronousSink sink) {
        Try try_ = aTry;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            EmailView value = (EmailView)success.value();
            sink.next((Object)value);
            return;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            sink.error(e);
            return;
        }
        throw new MatchError((Object)try_);
    }

    @Inject
    public EmailFastViewReader(MessageIdManager messageIdManager, MessageFastViewProjection messageFastViewProjection, HtmlTextExtractor htmlTextExtractor, ZoneIdProvider zoneIdProvider, EmailFullViewFactory fullViewFactory) {
        this.messageIdManager = messageIdManager;
        this.messageFastViewProjection = messageFastViewProjection;
        this.zoneIdProvider = zoneIdProvider;
        this.fullReader = new GenericEmailViewReader<EmailFullView>(messageIdManager, FetchGroup.FULL_CONTENT, htmlTextExtractor, fullViewFactory);
    }
}

