/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DereferencePolicy;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.ldap.sdk.unboundidds.controls.JoinBaseDN;
import com.unboundid.ldap.sdk.unboundidds.controls.JoinRequestValue;
import com.unboundid.ldap.sdk.unboundidds.controls.JoinRule;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONArray;
import com.unboundid.util.json.JSONBoolean;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONNumber;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class JoinRequestControl
extends Control {
    @NotNull
    public static final String JOIN_REQUEST_OID = "1.3.6.1.4.1.30221.2.5.9";
    @NotNull
    private static final String JSON_FIELD_ALIAS_DEREFERENCING_BEHAVIOR = "alias-dereferencing-behavior";
    @NotNull
    private static final String JSON_FIELD_ATTRIBUTES = "attributes";
    @NotNull
    private static final String JSON_FIELD_BASE_DN_TYPE = "base-dn-type";
    @NotNull
    private static final String JSON_FIELD_BASE_DN_VALUE = "base-dn-value";
    @NotNull
    private static final String JSON_FIELD_FILTER = "filter";
    @NotNull
    private static final String JSON_FIELD_JOIN_RULE = "join-rule";
    @NotNull
    private static final String JSON_FIELD_NESTED_JOIN = "nested-join";
    @NotNull
    private static final String JSON_FIELD_REQUIRE_MATCH = "require-match";
    @NotNull
    private static final String JSON_FIELD_SCOPE = "scope";
    @NotNull
    private static final String JSON_FIELD_SIZE_LIMIT = "size-limit";
    @NotNull
    private static final String JSON_ALIAS_BEHAVIOR_ALWAYS = "derefAlways";
    @NotNull
    private static final String JSON_ALIAS_BEHAVIOR_FINDING = "derefInFindingBaseObj";
    @NotNull
    private static final String JSON_ALIAS_BEHAVIOR_NEVER = "neverDerefAliases";
    @NotNull
    private static final String JSON_ALIAS_BEHAVIOR_SEARCHING = "derefInSearching";
    @NotNull
    private static final String JSON_BASE_DN_TYPE_USE_CUSTOM_BASE_DN = "use-custom-base-dn";
    @NotNull
    private static final String JSON_BASE_DN_TYPE_USE_SEARCH_BASE_DN = "use-search-base-dn";
    @NotNull
    private static final String JSON_BASE_DN_TYPE_USE_SOURCE_ENTRY_DN = "use-source-entry-dn";
    @NotNull
    private static final String JSON_SCOPE_BASE_OBJECT = "baseObject";
    @NotNull
    private static final String JSON_SCOPE_SINGLE_LEVEL = "singleLevel";
    @NotNull
    private static final String JSON_SCOPE_SUBORDINATE_SUBTREE = "subordinateSubtree";
    @NotNull
    private static final String JSON_SCOPE_WHOLE_SUBTREE = "wholeSubtree";
    private static final long serialVersionUID = -1321645105838145996L;
    @NotNull
    private final JoinRequestValue joinRequestValue;

    public JoinRequestControl(@NotNull JoinRequestValue joinRequestValue) {
        this(true, joinRequestValue);
    }

    public JoinRequestControl(boolean isCritical, @NotNull JoinRequestValue joinRequestValue) {
        super(JOIN_REQUEST_OID, isCritical, new ASN1OctetString(joinRequestValue.encode().encode()));
        this.joinRequestValue = joinRequestValue;
    }

    public JoinRequestControl(@NotNull Control control) throws LDAPException {
        super(control);
        ASN1Element valueElement;
        ASN1OctetString value = control.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_REQUEST_CONTROL_NO_VALUE.get());
        }
        try {
            valueElement = ASN1Element.decode(value.getValue());
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_REQUEST_VALUE_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
        this.joinRequestValue = JoinRequestValue.decode(valueElement);
    }

    @NotNull
    public JoinRequestValue getJoinRequestValue() {
        return this.joinRequestValue;
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_JOIN_REQUEST.get();
    }

    @Override
    @NotNull
    public JSONObject toJSONControl() {
        return new JSONObject(new JSONField("oid", JOIN_REQUEST_OID), new JSONField("control-name", ControlMessages.INFO_CONTROL_NAME_JOIN_REQUEST.get()), new JSONField("criticality", this.isCritical()), new JSONField("value-json", JoinRequestControl.encodeValueJSON(this.joinRequestValue)));
    }

    @NotNull
    private static JSONObject encodeValueJSON(@NotNull JoinRequestValue value) {
        String[] attributes;
        Filter filter;
        Integer sizeLimit;
        DereferencePolicy derefPolicy;
        LinkedHashMap<String, JSONValue> fields = new LinkedHashMap<String, JSONValue>();
        fields.put(JSON_FIELD_JOIN_RULE, value.getJoinRule().toJSON());
        JoinBaseDN joinBaseDN = value.getBaseDN();
        switch (joinBaseDN.getType()) {
            case -128: {
                fields.put(JSON_FIELD_BASE_DN_TYPE, new JSONString(JSON_BASE_DN_TYPE_USE_SEARCH_BASE_DN));
                break;
            }
            case -127: {
                fields.put(JSON_FIELD_BASE_DN_TYPE, new JSONString(JSON_BASE_DN_TYPE_USE_SOURCE_ENTRY_DN));
                break;
            }
            case -126: {
                fields.put(JSON_FIELD_BASE_DN_TYPE, new JSONString(JSON_BASE_DN_TYPE_USE_CUSTOM_BASE_DN));
                fields.put(JSON_FIELD_BASE_DN_VALUE, new JSONString(joinBaseDN.getCustomBaseDN()));
            }
        }
        SearchScope scope = value.getScope();
        if (scope != null) {
            switch (scope.intValue()) {
                case 0: {
                    fields.put(JSON_FIELD_SCOPE, new JSONString(JSON_SCOPE_BASE_OBJECT));
                    break;
                }
                case 1: {
                    fields.put(JSON_FIELD_SCOPE, new JSONString(JSON_SCOPE_SINGLE_LEVEL));
                    break;
                }
                case 2: {
                    fields.put(JSON_FIELD_SCOPE, new JSONString(JSON_SCOPE_WHOLE_SUBTREE));
                    break;
                }
                case 3: {
                    fields.put(JSON_FIELD_SCOPE, new JSONString(JSON_SCOPE_SUBORDINATE_SUBTREE));
                }
            }
        }
        if ((derefPolicy = value.getDerefPolicy()) != null) {
            switch (derefPolicy.intValue()) {
                case 0: {
                    fields.put(JSON_FIELD_ALIAS_DEREFERENCING_BEHAVIOR, new JSONString(JSON_ALIAS_BEHAVIOR_NEVER));
                    break;
                }
                case 1: {
                    fields.put(JSON_FIELD_ALIAS_DEREFERENCING_BEHAVIOR, new JSONString(JSON_ALIAS_BEHAVIOR_SEARCHING));
                    break;
                }
                case 2: {
                    fields.put(JSON_FIELD_ALIAS_DEREFERENCING_BEHAVIOR, new JSONString(JSON_ALIAS_BEHAVIOR_FINDING));
                    break;
                }
                case 3: {
                    fields.put(JSON_FIELD_ALIAS_DEREFERENCING_BEHAVIOR, new JSONString(JSON_ALIAS_BEHAVIOR_ALWAYS));
                }
            }
        }
        if ((sizeLimit = value.getSizeLimit()) != null) {
            fields.put(JSON_FIELD_SIZE_LIMIT, new JSONNumber(sizeLimit.intValue()));
        }
        if ((filter = value.getFilter()) != null) {
            fields.put(JSON_FIELD_FILTER, new JSONString(filter.toString()));
        }
        if ((attributes = value.getAttributes()) != null && attributes.length > 0) {
            ArrayList<JSONString> attrValues = new ArrayList<JSONString>(attributes.length);
            for (String attr : attributes) {
                attrValues.add(new JSONString(attr));
            }
            fields.put(JSON_FIELD_ATTRIBUTES, new JSONArray(attrValues));
        }
        fields.put(JSON_FIELD_REQUIRE_MATCH, new JSONBoolean(value.requireMatch()));
        JoinRequestValue nestedJoin = value.getNestedJoin();
        if (nestedJoin != null) {
            fields.put(JSON_FIELD_NESTED_JOIN, JoinRequestControl.encodeValueJSON(nestedJoin));
        }
        return new JSONObject(fields);
    }

    @NotNull
    public static JoinRequestControl decodeJSONControl(@NotNull JSONObject controlObject, boolean strict) throws LDAPException {
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, true, true);
        ASN1OctetString rawValue = jsonControl.getRawValue();
        if (rawValue != null) {
            return new JoinRequestControl(new Control(jsonControl.getOID(), jsonControl.getCriticality(), rawValue));
        }
        JoinRequestValue joinRequestValue = JoinRequestControl.decodeJoinRequestValueJSON(controlObject, jsonControl.getValueObject(), strict);
        return new JoinRequestControl(jsonControl.getCriticality(), joinRequestValue);
    }

    @NotNull
    private static JoinRequestValue decodeJoinRequestValueJSON(@NotNull JSONObject controlObject, @NotNull JSONObject valueObject, boolean strict) throws LDAPException {
        List<String> unrecognizedFields;
        String[] attributes;
        Filter filter;
        DereferencePolicy derefPolicy;
        SearchScope scope;
        JoinBaseDN baseDN;
        JoinRule joinRule;
        JSONObject joinRuleObject = valueObject.getFieldAsObject(JSON_FIELD_JOIN_RULE);
        if (joinRuleObject == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_REQUEST_JSON_MISSING_FIELD.get(controlObject.toSingleLineString(), JSON_FIELD_JOIN_RULE));
        }
        try {
            joinRule = JoinRule.decodeJSONJoinRule(joinRuleObject, strict);
        }
        catch (LDAPException e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_REQUEST_JSON_INVALID_JOIN_RULE.get(controlObject.toSingleLineString(), JSON_FIELD_JOIN_RULE, e.getMessage()), e);
        }
        String baseDNType = valueObject.getFieldAsString(JSON_FIELD_BASE_DN_TYPE);
        String baseDNValue = valueObject.getFieldAsString(JSON_FIELD_BASE_DN_VALUE);
        if (baseDNType == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_REQUEST_JSON_MISSING_FIELD.get(controlObject.toSingleLineString(), JSON_FIELD_BASE_DN_TYPE));
        }
        switch (baseDNType) {
            case "use-search-base-dn": {
                if (baseDNValue != null) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_REQUEST_JSON_DISALLOWED_BASE_DN_VALUE.get(controlObject.toSingleLineString(), JSON_FIELD_BASE_DN_VALUE, JSON_FIELD_BASE_DN_TYPE, baseDNType));
                }
                baseDN = JoinBaseDN.createUseSearchBaseDN();
                break;
            }
            case "use-source-entry-dn": {
                if (baseDNValue != null) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_REQUEST_JSON_DISALLOWED_BASE_DN_VALUE.get(controlObject.toSingleLineString(), JSON_FIELD_BASE_DN_VALUE, JSON_FIELD_BASE_DN_TYPE, baseDNType));
                }
                baseDN = JoinBaseDN.createUseSourceEntryDN();
                break;
            }
            case "use-custom-base-dn": {
                if (baseDNValue == null) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_REQUEST_JSON_MISSING_BASE_DN_VALUE.get(controlObject.toSingleLineString(), JSON_FIELD_BASE_DN_VALUE, JSON_FIELD_BASE_DN_TYPE, baseDNType));
                }
                baseDN = JoinBaseDN.createUseCustomBaseDN(baseDNValue);
                break;
            }
            default: {
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_REQUEST_JSON_INVALID_BASE_DN_TYPE.get(controlObject.toSingleLineString(), baseDNType, JSON_FIELD_BASE_DN_TYPE, JSON_BASE_DN_TYPE_USE_SEARCH_BASE_DN, JSON_BASE_DN_TYPE_USE_SOURCE_ENTRY_DN, JSON_BASE_DN_TYPE_USE_CUSTOM_BASE_DN));
            }
        }
        String scopeStr = valueObject.getFieldAsString(JSON_FIELD_SCOPE);
        if (scopeStr == null) {
            scope = null;
        } else {
            switch (scopeStr) {
                case "baseObject": {
                    scope = SearchScope.BASE;
                    break;
                }
                case "singleLevel": {
                    scope = SearchScope.ONE;
                    break;
                }
                case "wholeSubtree": {
                    scope = SearchScope.SUB;
                    break;
                }
                case "subordinateSubtree": {
                    scope = SearchScope.SUBORDINATE_SUBTREE;
                    break;
                }
                default: {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_REQUEST_JSON_INVALID_SCOPE.get(controlObject.toSingleLineString(), scopeStr, JSON_FIELD_SCOPE, JSON_SCOPE_BASE_OBJECT, JSON_SCOPE_SINGLE_LEVEL, JSON_SCOPE_WHOLE_SUBTREE, JSON_SCOPE_SUBORDINATE_SUBTREE));
                }
            }
        }
        String derefStr = valueObject.getFieldAsString(JSON_FIELD_ALIAS_DEREFERENCING_BEHAVIOR);
        if (derefStr == null) {
            derefPolicy = null;
        } else {
            switch (derefStr) {
                case "neverDerefAliases": {
                    derefPolicy = DereferencePolicy.NEVER;
                    break;
                }
                case "derefInSearching": {
                    derefPolicy = DereferencePolicy.SEARCHING;
                    break;
                }
                case "derefInFindingBaseObj": {
                    derefPolicy = DereferencePolicy.FINDING;
                    break;
                }
                case "derefAlways": {
                    derefPolicy = DereferencePolicy.ALWAYS;
                    break;
                }
                default: {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_REQUEST_JSON_INVALID_DEREF.get(controlObject.toSingleLineString(), derefStr, JSON_FIELD_ALIAS_DEREFERENCING_BEHAVIOR, JSON_ALIAS_BEHAVIOR_NEVER, JSON_ALIAS_BEHAVIOR_SEARCHING, JSON_ALIAS_BEHAVIOR_FINDING, JSON_ALIAS_BEHAVIOR_ALWAYS));
                }
            }
        }
        Integer sizeLimit = valueObject.getFieldAsInteger(JSON_FIELD_SIZE_LIMIT);
        String filterStr = valueObject.getFieldAsString(JSON_FIELD_FILTER);
        if (filterStr == null) {
            filter = null;
        } else {
            try {
                filter = Filter.create(filterStr);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_REQUEST_JSON_INVALID_FILTER.get(controlObject.toSingleLineString(), filterStr, JSON_FIELD_FILTER), e);
            }
        }
        List<JSONValue> attrValues = valueObject.getFieldAsArray(JSON_FIELD_ATTRIBUTES);
        if (attrValues == null) {
            attributes = null;
        } else {
            attributes = new String[attrValues.size()];
            for (int i = 0; i < attributes.length; ++i) {
                JSONValue v = attrValues.get(i);
                if (!(v instanceof JSONString)) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_REQUEST_JSON_ATTR_NOT_STRING.get(controlObject.toSingleLineString(), JSON_FIELD_ATTRIBUTES));
                }
                attributes[i] = ((JSONString)v).stringValue();
            }
        }
        Boolean requireMatch = valueObject.getFieldAsBoolean(JSON_FIELD_REQUIRE_MATCH);
        if (requireMatch == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_REQUEST_JSON_MISSING_FIELD.get(controlObject.toSingleLineString(), JSON_FIELD_REQUIRE_MATCH));
        }
        JSONObject nestedJoinObject = valueObject.getFieldAsObject(JSON_FIELD_NESTED_JOIN);
        JoinRequestValue nestedJoin = nestedJoinObject == null ? null : JoinRequestControl.decodeJoinRequestValueJSON(controlObject, nestedJoinObject, strict);
        if (strict && !(unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(valueObject, JSON_FIELD_JOIN_RULE, JSON_FIELD_BASE_DN_TYPE, JSON_FIELD_BASE_DN_VALUE, JSON_FIELD_SCOPE, JSON_FIELD_ALIAS_DEREFERENCING_BEHAVIOR, JSON_FIELD_SIZE_LIMIT, JSON_FIELD_FILTER, JSON_FIELD_ATTRIBUTES, JSON_FIELD_REQUIRE_MATCH, JSON_FIELD_NESTED_JOIN)).isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_REQUEST_JSON_UNRECOGNIZED_FIELD.get(controlObject.toSingleLineString(), unrecognizedFields.get(0)));
        }
        return new JoinRequestValue(joinRule, baseDN, scope, derefPolicy, sizeLimit, filter, attributes, requireMatch, nestedJoin);
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("JoinRequestControl(value=");
        this.joinRequestValue.toString(buffer);
        buffer.append(')');
    }
}

