/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.cassandra.change;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.metadata.schema.ClusteringOrder;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.internal.core.type.codec.BooleanCodec;
import com.datastax.oss.driver.internal.querybuilder.DefaultLiteral;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.init.CassandraTypesProvider;
import org.apache.james.backends.cassandra.init.CassandraZonedDateTimeModule;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.jmap.api.change.MailboxChange;
import org.apache.james.jmap.api.change.State;
import org.apache.james.jmap.api.model.AccountId;
import org.apache.james.jmap.cassandra.change.tables.CassandraMailboxChangeTable;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.model.MailboxId;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MailboxChangeRepositoryDAO {
    private static final TypeCodec<Set<UUID>> SET_OF_UUIDS_CODEC = CodecRegistry.DEFAULT.codecFor((DataType)DataTypes.frozenSetOf((DataType)DataTypes.UUID), GenericType.setOf(UUID.class));
    private final CassandraAsyncExecutor executor;
    private final UserDefinedType zonedDateTimeUserType;
    private final PreparedStatement insertStatement;
    private final PreparedStatement selectAllStatement;
    private final PreparedStatement selectFromStatement;
    private final PreparedStatement selectLatestStatement;
    private final PreparedStatement selectLatestNotDelegatedStatement;

    @Inject
    public MailboxChangeRepositoryDAO(CqlSession session, CassandraTypesProvider cassandraTypesProvider) {
        this.executor = new CassandraAsyncExecutor(session);
        this.zonedDateTimeUserType = cassandraTypesProvider.getDefinedUserType("zonedDateTime");
        this.insertStatement = session.prepare(QueryBuilder.insertInto((String)"mailbox_change").value(CassandraMailboxChangeTable.ACCOUNT_ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxChangeTable.ACCOUNT_ID)).value(CassandraMailboxChangeTable.STATE, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxChangeTable.STATE)).value(CassandraMailboxChangeTable.DATE, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxChangeTable.DATE)).value(CassandraMailboxChangeTable.IS_DELEGATED, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxChangeTable.IS_DELEGATED)).value(CassandraMailboxChangeTable.IS_COUNT_CHANGE, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxChangeTable.IS_COUNT_CHANGE)).value(CassandraMailboxChangeTable.CREATED, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxChangeTable.CREATED)).value(CassandraMailboxChangeTable.UPDATED, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxChangeTable.UPDATED)).value(CassandraMailboxChangeTable.DESTROYED, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxChangeTable.DESTROYED)).build());
        this.selectAllStatement = session.prepare(((Select)QueryBuilder.selectFrom((String)"mailbox_change").all().whereColumn(CassandraMailboxChangeTable.ACCOUNT_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxChangeTable.ACCOUNT_ID))).orderBy(CassandraMailboxChangeTable.STATE, ClusteringOrder.ASC).build());
        this.selectFromStatement = session.prepare(((Select)((Select)QueryBuilder.selectFrom((String)"mailbox_change").all().whereColumn(CassandraMailboxChangeTable.ACCOUNT_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxChangeTable.ACCOUNT_ID))).whereColumn(CassandraMailboxChangeTable.STATE).isGreaterThanOrEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxChangeTable.STATE))).orderBy(CassandraMailboxChangeTable.STATE, ClusteringOrder.ASC).build());
        this.selectLatestStatement = session.prepare(((Select)QueryBuilder.selectFrom((String)"mailbox_change").column(CassandraMailboxChangeTable.STATE).whereColumn(CassandraMailboxChangeTable.ACCOUNT_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxChangeTable.ACCOUNT_ID))).orderBy(CassandraMailboxChangeTable.STATE, ClusteringOrder.DESC).limit(1).build());
        this.selectLatestNotDelegatedStatement = session.prepare(((Select)((Select)QueryBuilder.selectFrom((String)"mailbox_change").column(CassandraMailboxChangeTable.STATE).whereColumn(CassandraMailboxChangeTable.ACCOUNT_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxChangeTable.ACCOUNT_ID))).whereColumn(CassandraMailboxChangeTable.IS_DELEGATED).isEqualTo((Term)new DefaultLiteral((Object)false, (TypeCodec)new BooleanCodec()))).orderBy(CassandraMailboxChangeTable.STATE, ClusteringOrder.DESC).limit(1).allowFiltering().build());
    }

    Mono<Void> insert(MailboxChange change) {
        return this.executor.executeVoid((Statement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)this.insertStatement.bind(new Object[0]).setString(CassandraMailboxChangeTable.ACCOUNT_ID, change.getAccountId().getIdentifier())).setUuid(CassandraMailboxChangeTable.STATE, change.getState().getValue())).setBoolean(CassandraMailboxChangeTable.IS_COUNT_CHANGE, change.isCountChange())).setBoolean(CassandraMailboxChangeTable.IS_DELEGATED, change.isDelegated())).set(CassandraMailboxChangeTable.CREATED, this.toUuidSet(change.getCreated()), SET_OF_UUIDS_CODEC)).set(CassandraMailboxChangeTable.UPDATED, this.toUuidSet(change.getUpdated()), SET_OF_UUIDS_CODEC)).set(CassandraMailboxChangeTable.DESTROYED, this.toUuidSet(change.getDestroyed()), SET_OF_UUIDS_CODEC)).setUdtValue(CassandraMailboxChangeTable.DATE, CassandraZonedDateTimeModule.toUDT((UserDefinedType)this.zonedDateTimeUserType, (ZonedDateTime)change.getDate())));
    }

    private ImmutableSet<UUID> toUuidSet(List<MailboxId> idSet) {
        return (ImmutableSet)idSet.stream().filter(CassandraId.class::isInstance).map(CassandraId.class::cast).map(CassandraId::asUuid).collect(ImmutableSet.toImmutableSet());
    }

    Flux<MailboxChange> getAllChanges(AccountId accountId) {
        return this.executor.executeRows((Statement)this.selectAllStatement.bind(new Object[0]).set(CassandraMailboxChangeTable.ACCOUNT_ID, (Object)accountId.getIdentifier(), TypeCodecs.TEXT)).map(row -> this.readRow((Row)row, accountId));
    }

    Flux<MailboxChange> getChangesSince(AccountId accountId, State state) {
        return this.executor.executeRows((Statement)((BoundStatement)this.selectFromStatement.bind(new Object[0]).set(CassandraMailboxChangeTable.ACCOUNT_ID, (Object)accountId.getIdentifier(), TypeCodecs.TEXT)).setUuid(CassandraMailboxChangeTable.STATE, state.getValue())).map(row -> this.readRow((Row)row, accountId));
    }

    Mono<State> latestState(AccountId accountId) {
        return this.executor.executeSingleRow((Statement)this.selectLatestStatement.bind(new Object[0]).set(CassandraMailboxChangeTable.ACCOUNT_ID, (Object)accountId.getIdentifier(), TypeCodecs.TEXT)).map(row -> State.of((UUID)row.getUuid(0)));
    }

    Mono<State> latestStateNotDelegated(AccountId accountId) {
        return this.executor.executeSingleRow((Statement)this.selectLatestNotDelegatedStatement.bind(new Object[0]).set(CassandraMailboxChangeTable.ACCOUNT_ID, (Object)accountId.getIdentifier(), TypeCodecs.TEXT)).map(row -> State.of((UUID)row.getUuid(0)));
    }

    private MailboxChange readRow(Row row, AccountId accountId) {
        return MailboxChange.builder().accountId(accountId).state(State.of((UUID)row.getUuid(CassandraMailboxChangeTable.STATE))).date(CassandraZonedDateTimeModule.fromUDT((UdtValue)row.getUdtValue(CassandraMailboxChangeTable.DATE))).isCountChange(row.getBoolean(CassandraMailboxChangeTable.IS_COUNT_CHANGE)).delegated(row.getBoolean(CassandraMailboxChangeTable.IS_DELEGATED)).created(this.toIdSet((Set)row.get(CassandraMailboxChangeTable.CREATED, SET_OF_UUIDS_CODEC))).updated(this.toIdSet((Set)row.get(CassandraMailboxChangeTable.UPDATED, SET_OF_UUIDS_CODEC))).destroyed(this.toIdSet((Set)row.get(CassandraMailboxChangeTable.DESTROYED, SET_OF_UUIDS_CODEC))).build();
    }

    private ImmutableList<MailboxId> toIdSet(Set<UUID> uuidSet) {
        return (ImmutableList)uuidSet.stream().map(CassandraId::of).collect(ImmutableList.toImmutableList());
    }
}

