/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Objects;
import org.apache.jena.fuseki.servlets.ActionExecLib;
import org.apache.jena.fuseki.servlets.ActionProcessor;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.system.ActionCategory;
import org.slf4j.Logger;

public class ServletAction
extends HttpServlet {
    private final Logger log;
    private final ActionProcessor actionProcessor;

    public ServletAction(ActionProcessor actionProcessor, Logger log2) {
        this.actionProcessor = Objects.requireNonNull(actionProcessor, "actionProcessor is null");
        this.log = log2;
    }

    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response) {
        HttpAction action = this.allocHttpActionServlet(request, response);
        ActionExecLib.execAction(action, this.actionProcessor);
    }

    private HttpAction allocHttpActionServlet(HttpServletRequest request, HttpServletResponse response) {
        return ActionExecLib.allocHttpAction(null, this.log, ActionCategory.ACTION, request, response);
    }
}

