/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.behavior;

import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessManagedBean;
import jakarta.faces.component.behavior.FacesBehavior;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import org.apache.myfaces.cdi.behavior.FacesBehaviorInfo;
import org.apache.myfaces.cdi.behavior.FacesBehaviorProducer;

public class FacesBehaviorExtension
implements Extension {
    private Set<FacesBehaviorInfo> types = new HashSet<FacesBehaviorInfo>();

    public <T> void collect(@Observes ProcessManagedBean<T> event) {
        if (event.getAnnotatedBeanClass().isAnnotationPresent(FacesBehavior.class)) {
            AnnotatedType annotated = event.getAnnotatedBeanClass();
            Type type = annotated.getBaseType();
            FacesBehavior conv = (FacesBehavior)annotated.getAnnotation(FacesBehavior.class);
            if (conv.managed()) {
                boolean hasValue;
                boolean bl = hasValue = conv.value().length() > 0;
                if (hasValue) {
                    this.types.add(new FacesBehaviorInfo(type, conv.value()));
                }
            }
        }
    }

    public void afterBean(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        for (FacesBehaviorInfo typeInfo : this.types) {
            afterBeanDiscovery.addBean((Bean)new FacesBehaviorProducer(beanManager, typeInfo));
        }
    }
}

