/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote.codec;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.nifi.remote.StandardVersionNegotiator;
import org.apache.nifi.remote.VersionNegotiator;
import org.apache.nifi.remote.codec.FlowFileCodec;
import org.apache.nifi.remote.exception.ProtocolException;
import org.apache.nifi.remote.protocol.DataPacket;
import org.apache.nifi.remote.util.StandardDataPacket;
import org.apache.nifi.stream.io.StreamUtils;

public class StandardFlowFileCodec
implements FlowFileCodec {
    public static final int MAX_NUM_ATTRIBUTES = 25000;
    public static final String DEFAULT_FLOWFILE_PATH = "./";
    private final VersionNegotiator versionNegotiator = new StandardVersionNegotiator(new int[]{1});

    @Override
    public void encode(DataPacket dataPacket, OutputStream encodedOut) throws IOException {
        DataOutputStream out = new DataOutputStream(encodedOut);
        Map<String, String> attributes = dataPacket.getAttributes();
        out.writeInt(attributes.size());
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            this.writeString(entry.getKey(), out);
            this.writeString(entry.getValue(), out);
        }
        out.writeLong(dataPacket.getSize());
        InputStream in = dataPacket.getData();
        StreamUtils.copy((InputStream)in, (OutputStream)encodedOut);
    }

    @Override
    public DataPacket decode(InputStream stream) throws IOException, ProtocolException {
        int numAttributes;
        DataInputStream in = new DataInputStream(stream);
        try {
            numAttributes = in.readInt();
        }
        catch (EOFException e) {
            return null;
        }
        if (numAttributes > 25000) {
            throw new ProtocolException("FlowFile exceeds maximum number of attributes with a total of " + numAttributes);
        }
        HashMap<String, String> attributes = new HashMap<String, String>(numAttributes);
        for (int i = 0; i < numAttributes; ++i) {
            String attrName = this.readString(in);
            String attrValue = this.readString(in);
            attributes.put(attrName, attrValue);
        }
        long numBytes = in.readLong();
        return new StandardDataPacket(attributes, stream, numBytes);
    }

    private void writeString(String val, DataOutputStream out) throws IOException {
        byte[] bytes = val.getBytes(StandardCharsets.UTF_8);
        out.writeInt(bytes.length);
        out.write(bytes);
    }

    private String readString(DataInputStream in) throws IOException {
        int numBytes = in.readInt();
        byte[] bytes = new byte[numBytes];
        StreamUtils.fillBuffer((InputStream)in, (byte[])bytes, (boolean)true);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    @Override
    public List<Integer> getSupportedVersions() {
        return this.versionNegotiator.getSupportedVersions();
    }

    @Override
    public VersionNegotiator getVersionNegotiator() {
        return this.versionNegotiator;
    }

    public String toString() {
        return "Standard FlowFile Codec, Version " + this.versionNegotiator.getVersion();
    }

    @Override
    public String getResourceName() {
        return "StandardFlowFileCodec";
    }
}

