/*
 * Decompiled with CFR 0.152.
 */
package com.barchart.udt.net;

import com.barchart.udt.ExceptionUDT;
import com.barchart.udt.SocketUDT;
import com.barchart.udt.TypeUDT;
import com.barchart.udt.net.IceCommon;
import com.barchart.udt.net.IceServerSocket;
import com.barchart.udt.net.NetSocketUDT;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;

public class NetServerSocketUDT
extends ServerSocket
implements IceServerSocket,
IceCommon {
    protected final SocketUDT socketUDT;

    public NetServerSocketUDT() throws IOException {
        this(new SocketUDT(TypeUDT.STREAM));
        this.socketUDT.setBlocking(true);
    }

    protected NetServerSocketUDT(SocketUDT socketUDT) throws IOException {
        this.socketUDT = socketUDT;
    }

    @Override
    public Socket accept() throws IOException {
        SocketUDT clientUDT = this.socketUDT.accept();
        return new NetSocketUDT(clientUDT);
    }

    @Override
    public void bind(SocketAddress endpoint) throws IOException {
        int backlog = 256;
        this.bind(endpoint, 256);
    }

    @Override
    public void bind(SocketAddress bindpoint, int backlog) throws IOException {
        if (bindpoint == null) {
            bindpoint = new InetSocketAddress(0);
        }
        if (backlog <= 0) {
            backlog = 256;
        }
        this.socketUDT.bind((InetSocketAddress)bindpoint);
        this.socketUDT.listen(backlog);
    }

    @Override
    public void close() throws IOException {
        this.socketUDT.close();
    }

    @Override
    public ServerSocketChannel getChannel() {
        throw new UnsupportedOperationException("feature not available");
    }

    @Override
    public InetAddress getInetAddress() {
        return this.socketUDT.getLocalInetAddress();
    }

    @Override
    public int getLocalPort() {
        return this.socketUDT.getLocalInetPort();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        try {
            return this.socketUDT.getLocalSocketAddress();
        }
        catch (ExceptionUDT e) {
            return null;
        }
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        return this.socketUDT.getReceiveBufferSize();
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this.socketUDT.getReuseAddress();
    }

    @Override
    public int getSoTimeout() throws IOException {
        return this.socketUDT.getSoTimeout();
    }

    @Override
    public boolean isBound() {
        return this.socketUDT.isBound();
    }

    @Override
    public boolean isClosed() {
        return this.socketUDT.isClosed();
    }

    @Override
    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        throw new UnsupportedOperationException("feature not available");
    }

    @Override
    public void setReceiveBufferSize(int size) throws SocketException {
        this.socketUDT.setReceiveBufferSize(size);
        this.socketUDT.setSendBufferSize(size);
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        this.socketUDT.setReuseAddress(on);
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        this.socketUDT.setSoTimeout(timeout);
    }

    @Override
    public SocketUDT socketUDT() {
        return this.socketUDT;
    }
}

