/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import kafka.server.ControllerRegistrationManager$;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ControllerRegistrationRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ControllerRegistrationRequest;
import org.apache.kafka.common.requests.ControllerRegistrationResponse;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.publisher.MetadataPublisher;
import org.apache.kafka.metadata.ControllerRegistration;
import org.apache.kafka.metadata.ListenerInfo;
import org.apache.kafka.metadata.VersionRange;
import org.apache.kafka.queue.EventQueue;
import org.apache.kafka.queue.KafkaEventQueue;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.server.ControllerRequestCompletionHandler;
import org.apache.kafka.server.NodeToControllerChannelManager;
import org.apache.kafka.server.common.MetadataVersion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.mutable.StringBuilder;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tmf\u0001\u0002#F\u0001)C\u0001\u0002\u001a\u0001\u0003\u0006\u0004%\t!\u001a\u0005\tS\u0002\u0011\t\u0011)A\u0005M\"A!\u000e\u0001BC\u0002\u0013\u00051\u000e\u0003\u0005x\u0001\t\u0005\t\u0015!\u0003m\u0011!A\bA!b\u0001\n\u0003I\b\"CA\u0002\u0001\t\u0005\t\u0015!\u0003{\u0011%\t)\u0001\u0001BC\u0002\u0013\u00051\u000eC\u0005\u0002\b\u0001\u0011\t\u0011)A\u0005Y\"Q\u0011\u0011\u0002\u0001\u0003\u0006\u0004%\t!a\u0003\t\u0015\u0005%\u0002A!A!\u0002\u0013\ti\u0001\u0003\u0006\u0002,\u0001\u0011)\u0019!C\u0001\u0003[A!\"!\u000e\u0001\u0005\u0003\u0005\u000b\u0011BA\u0018\u0011)\t9\u0004\u0001BC\u0002\u0013\u0005\u0011\u0011\b\u0005\u000b\u0003\u0007\u0002!\u0011!Q\u0001\n\u0005m\u0002BCA#\u0001\t\u0015\r\u0011\"\u0001\u0002H!Q\u0011q\n\u0001\u0003\u0002\u0003\u0006I!!\u0013\t\u0015\u0005E\u0003A!b\u0001\n\u0003\t\u0019\u0006\u0003\u0006\u0002\\\u0001\u0011\t\u0011)A\u0005\u0003+Bq!!\u0018\u0001\t\u0003\ty\u0006C\u0004\u0002x\u0001!\t%!\u001f\t\u000f\u0005m\u0004\u0001\"\u0003\u0002z!I\u0011Q\u0010\u0001C\u0002\u0013\u0005\u0011q\u0010\u0005\t\u0003\u000f\u0003\u0001\u0015!\u0003\u0002\u0002\"I\u0011\u0011\u0012\u0001A\u0002\u0013\u0005\u0011Q\u0006\u0005\n\u0003\u0017\u0003\u0001\u0019!C\u0001\u0003\u001bC\u0001\"!'\u0001A\u0003&\u0011q\u0006\u0005\n\u00037\u0003\u0001\u0019!C\u0001\u0003;C\u0011\"!*\u0001\u0001\u0004%\t!a*\t\u0011\u0005-\u0006\u0001)Q\u0005\u0003?C\u0011\"!,\u0001\u0001\u0004%\t!!(\t\u0013\u0005=\u0006\u00011A\u0005\u0002\u0005E\u0006\u0002CA[\u0001\u0001\u0006K!a(\t\u0013\u0005]\u0006\u00011A\u0005\n\u0005e\u0006\"CAd\u0001\u0001\u0007I\u0011BAe\u0011!\ti\r\u0001Q!\n\u0005m\u0006\"CAh\u0001\u0001\u0007I\u0011AA\u0017\u0011%\t\t\u000e\u0001a\u0001\n\u0003\t\u0019\u000e\u0003\u0005\u0002X\u0002\u0001\u000b\u0015BA\u0018\u0011-\tI\u000e\u0001a\u0001\u0002\u0004%I!a7\t\u0017\u0005\u0015\b\u00011AA\u0002\u0013%\u0011q\u001d\u0005\f\u0003W\u0004\u0001\u0019!A!B\u0013\ti\u000e\u0003\u0006\u0002n\u0002\u0011\r\u0011\"\u0001F\u0003_D\u0001\"!@\u0001A\u0003%\u0011\u0011\u001f\u0004\u0007\u0003\u007f\u0004AA!\u0001\t\u000f\u0005uC\u0006\"\u0001\u0003\u001e!9!1\u0005\u0017\u0005B\t\u0015\u0002b\u0002B\u0014\u0001\u0011\u0005!\u0011\u0006\u0005\b\u0005_\u0001A\u0011\u0001B\u0013\u0011\u001d\u0011\t\u0004\u0001C!\u0005KAqAa\r\u0001\t\u0003\u0012)D\u0002\u0004\u0003^\u0001!!q\f\u0005\u000b\u0005s\u0019$\u0011!Q\u0001\n\tm\u0002B\u0003B#g\t\u0005\t\u0015!\u0003\u0003H!9\u0011QL\u001a\u0005\u0002\t\u0005\u0004b\u0002B\u0012g\u0011\u0005#Q\u0005\u0005\b\u0005S\u0002A\u0011\u0002B\u0013\u0011\u001d\u0011Y\u0007\u0001C\u0005\u0005K1aA!\u001c\u0001\t\t=\u0004bBA/u\u0011\u0005!q\u000f\u0005\b\u0005wRD\u0011\tB?\u0011\u001d\u0011yI\u000fC!\u0005KAqA!%\u0001\t\u0013\u0011)\u0003C\u0004\u0003\u0014\u0002!IA!&\b\u0013\tmU)!A\t\u0002\tue\u0001\u0003#F\u0003\u0003E\tAa(\t\u000f\u0005u\u0013\t\"\u0001\u0003\"\"I!1U!\u0012\u0002\u0013\u0005!Q\u0015\u0002\u001e\u0007>tGO]8mY\u0016\u0014(+Z4jgR\u0014\u0018\r^5p]6\u000bg.Y4fe*\u0011aiR\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003!\u000bQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001\u0017F;\u0006C\u0001'P\u001b\u0005i%\"\u0001(\u0002\u000bM\u001c\u0017\r\\1\n\u0005Ak%AB!osJ+g\r\u0005\u0002S+6\t1K\u0003\u0002U\u000f\u0006)Q\u000f^5mg&\u0011ak\u0015\u0002\b\u0019><w-\u001b8h!\tA&-D\u0001Z\u0015\tQ6,A\u0005qk\nd\u0017n\u001d5fe*\u0011A,X\u0001\u0006S6\fw-\u001a\u0006\u0003\u0011zS!a\u00181\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0017aA8sO&\u00111-\u0017\u0002\u0012\u001b\u0016$\u0018\rZ1uCB+(\r\\5tQ\u0016\u0014\u0018A\u00028pI\u0016LE-F\u0001g!\tau-\u0003\u0002i\u001b\n\u0019\u0011J\u001c;\u0002\u000f9|G-Z%eA\u0005I1\r\\;ti\u0016\u0014\u0018\nZ\u000b\u0002YB\u0011Q\u000e\u001e\b\u0003]J\u0004\"a\\'\u000e\u0003AT!!]%\u0002\rq\u0012xn\u001c;?\u0013\t\u0019X*\u0001\u0004Qe\u0016$WMZ\u0005\u0003kZ\u0014aa\u0015;sS:<'BA:N\u0003)\u0019G.^:uKJLE\rI\u0001\u0005i&lW-F\u0001{!\tYx0D\u0001}\u0015\t!VP\u0003\u0002\u007f;\u000611m\\7n_:L1!!\u0001}\u0005\u0011!\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002!QD'/Z1e\u001d\u0006lW\r\u0015:fM&D\u0018!\u0005;ie\u0016\fGMT1nKB\u0013XMZ5yA\u0005\t2/\u001e9q_J$X\r\u001a$fCR,(/Z:\u0016\u0005\u00055\u0001cBA\b\u00033a\u0017QD\u0007\u0003\u0003#QA!a\u0005\u0002\u0016\u0005!Q\u000f^5m\u0015\t\t9\"\u0001\u0003kCZ\f\u0017\u0002BA\u000e\u0003#\u00111!T1q!\u0011\ty\"!\n\u000e\u0005\u0005\u0005\"bAA\u0012;\u0006AQ.\u001a;bI\u0006$\u0018-\u0003\u0003\u0002(\u0005\u0005\"\u0001\u0004,feNLwN\u001c*b]\u001e,\u0017AE:vaB|'\u000f^3e\r\u0016\fG/\u001e:fg\u0002\n!C_6NS\u001e\u0014\u0018\r^5p]\u0016s\u0017M\u00197fIV\u0011\u0011q\u0006\t\u0004\u0019\u0006E\u0012bAA\u001a\u001b\n9!i\\8mK\u0006t\u0017a\u0005>l\u001b&<'/\u0019;j_:,e.\u00192mK\u0012\u0004\u0013!D5oG\u0006\u0014h.\u0019;j_:LE-\u0006\u0002\u0002<A!\u0011QHA \u001b\u0005i\u0018bAA!{\n!Q+^5e\u00039IgnY1s]\u0006$\u0018n\u001c8JI\u0002\nA\u0002\\5ti\u0016tWM]%oM>,\"!!\u0013\u0011\t\u0005}\u00111J\u0005\u0005\u0003\u001b\n\tC\u0001\u0007MSN$XM\\3s\u0013:4w.A\u0007mSN$XM\\3s\u0013:4w\u000eI\u0001\u0019e\u0016\u001cXM\u001c3FqB|g.\u001a8uS\u0006d')Y2l_\u001a4WCAA+!\rY\u0018qK\u0005\u0004\u00033b(AE#ya>tWM\u001c;jC2\u0014\u0015mY6pM\u001a\f\u0011D]3tK:$W\t\u001f9p]\u0016tG/[1m\u0005\u0006\u001c7n\u001c4gA\u00051A(\u001b8jiz\"B#!\u0019\u0002f\u0005\u001d\u0014\u0011NA6\u0003[\ny'!\u001d\u0002t\u0005U\u0004cAA2\u00015\tQ\tC\u0003e'\u0001\u0007a\rC\u0003k'\u0001\u0007A\u000eC\u0003y'\u0001\u0007!\u0010\u0003\u0004\u0002\u0006M\u0001\r\u0001\u001c\u0005\b\u0003\u0013\u0019\u0002\u0019AA\u0007\u0011\u001d\tYc\u0005a\u0001\u0003_Aq!a\u000e\u0014\u0001\u0004\tY\u0004C\u0004\u0002FM\u0001\r!!\u0013\t\u0013\u0005E3\u0003%AA\u0002\u0005U\u0013\u0001\u00028b[\u0016$\u0012\u0001\\\u0001\nY><\u0007K]3gSb\f!\u0002\\8h\u0007>tG/\u001a=u+\t\t\t\tE\u0002|\u0003\u0007K1!!\"}\u0005)aunZ\"p]R,\u0007\u0010^\u0001\fY><7i\u001c8uKb$\b%\u0001\u0006qK:$\u0017N\\4Sa\u000e\fa\u0002]3oI&twM\u00159d?\u0012*\u0017\u000f\u0006\u0003\u0002\u0010\u0006U\u0005c\u0001'\u0002\u0012&\u0019\u00111S'\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003/K\u0012\u0011!a\u0001\u0003_\t1\u0001\u001f\u00132\u0003-\u0001XM\u001c3j]\u001e\u0014\u0006o\u0019\u0011\u0002\u001dM,8mY3tg\u001a,HN\u00159dgV\u0011\u0011q\u0014\t\u0004\u0019\u0006\u0005\u0016bAAR\u001b\n!Aj\u001c8h\u0003I\u0019XoY2fgN4W\u000f\u001c*qGN|F%Z9\u0015\t\u0005=\u0015\u0011\u0016\u0005\n\u0003/c\u0012\u0011!a\u0001\u0003?\u000bqb];dG\u0016\u001c8OZ;m%B\u001c7\u000fI\u0001\u000bM\u0006LG.\u001a3Sa\u000e\u001c\u0018A\u00044bS2,GM\u00159dg~#S-\u001d\u000b\u0005\u0003\u001f\u000b\u0019\fC\u0005\u0002\u0018~\t\t\u00111\u0001\u0002 \u0006Ya-Y5mK\u0012\u0014\u0006oY:!\u0003=iW\r^1eCR\fg+\u001a:tS>tWCAA^!\u0011\ti,a1\u000e\u0005\u0005}&b\u0001@\u0002B*\u0011a)X\u0005\u0005\u0003\u000b\fyLA\bNKR\fG-\u0019;b-\u0016\u00148/[8o\u0003MiW\r^1eCR\fg+\u001a:tS>tw\fJ3r)\u0011\ty)a3\t\u0013\u0005]%%!AA\u0002\u0005m\u0016\u0001E7fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8!\u0003=\u0011XmZ5ti\u0016\u0014X\rZ%o\u0019><\u0017a\u0005:fO&\u001cH/\u001a:fI&sGj\\4`I\u0015\fH\u0003BAH\u0003+D\u0011\"a&&\u0003\u0003\u0005\r!a\f\u0002!I,w-[:uKJ,G-\u00138M_\u001e\u0004\u0013aD0dQ\u0006tg.\u001a7NC:\fw-\u001a:\u0016\u0005\u0005u\u0007\u0003BAp\u0003Cl!!!1\n\t\u0005\r\u0018\u0011\u0019\u0002\u001f\u001d>$W\rV8D_:$(o\u001c7mKJ\u001c\u0005.\u00198oK2l\u0015M\\1hKJ\f1cX2iC:tW\r\\'b]\u0006<WM]0%KF$B!a$\u0002j\"I\u0011q\u0013\u0015\u0002\u0002\u0003\u0007\u0011Q\\\u0001\u0011?\u000eD\u0017M\u001c8fY6\u000bg.Y4fe\u0002\n!\"\u001a<f]R\fV/Z;f+\t\t\t\u0010\u0005\u0003\u0002t\u0006eXBAA{\u0015\r\t90X\u0001\u0006cV,W/Z\u0005\u0005\u0003w\f)PA\bLC\u001a\\\u0017-\u0012<f]R\fV/Z;f\u0003-)g/\u001a8u#V,W/\u001a\u0011\u0003\u001bMCW\u000f\u001e3po:,e/\u001a8u'\u0015a#1\u0001B\b!\u0011\u0011)Aa\u0003\u000e\u0005\t\u001d!\u0002\u0002B\u0005\u0003+\tA\u0001\\1oO&!!Q\u0002B\u0004\u0005\u0019y%M[3diB!!\u0011\u0003B\f\u001d\u0011\t\u0019Pa\u0005\n\t\tU\u0011Q_\u0001\u000b\u000bZ,g\u000e^)vKV,\u0017\u0002\u0002B\r\u00057\u0011Q!\u0012<f]RTAA!\u0006\u0002vR\u0011!q\u0004\t\u0004\u0005CaS\"\u0001\u0001\u0002\u0007I,h\u000e\u0006\u0002\u0002\u0010\u0006)1\u000f^1siR!\u0011q\u0012B\u0016\u0011\u001d\u0011ic\fa\u0001\u0003;\fab\u00195b]:,G.T1oC\u001e,'/A\u0007cK\u001eLgn\u00155vi\u0012|wO\\\u0001\u0006G2|7/Z\u0001\u0011_:lU\r^1eCR\fW\u000b\u001d3bi\u0016$\u0002\"a$\u00038\t\r#Q\n\u0005\b\u0005s\u0011\u0004\u0019\u0001B\u001e\u0003\u0015!W\r\u001c;b!\u0011\u0011iDa\u0010\u000e\u0003mK1A!\u0011\\\u00055iU\r^1eCR\fG)\u001a7uC\"9!Q\t\u001aA\u0002\t\u001d\u0013\u0001\u00038fo&k\u0017mZ3\u0011\t\tu\"\u0011J\u0005\u0004\u0005\u0017Z&!D'fi\u0006$\u0017\r^1J[\u0006<W\rC\u0004\u0003PI\u0002\rA!\u0015\u0002\u00115\fg.\u001b4fgR\u0004BAa\u0015\u0003Z5\u0011!Q\u000b\u0006\u0004\u0005/Z\u0016A\u00027pC\u0012,'/\u0003\u0003\u0003\\\tU#A\u0004'pC\u0012,'/T1oS\u001a,7\u000f\u001e\u0002\u0014\u001b\u0016$\u0018\rZ1uCV\u0003H-\u0019;f\u000bZ,g\u000e^\n\u0006g\t\r!q\u0002\u000b\u0007\u0005G\u0012)Ga\u001a\u0011\u0007\t\u00052\u0007C\u0004\u0003:Y\u0002\rAa\u000f\t\u000f\t\u0015c\u00071\u0001\u0003H\u0005yR.Y=cKN+g\u000eZ\"p]R\u0014x\u000e\u001c7feJ+w-[:ue\u0006$\u0018n\u001c8\u00025M,g\u000eZ\"p]R\u0014x\u000e\u001c7feJ+w-[:ue\u0006$\u0018n\u001c8\u00037I+w-[:ue\u0006$\u0018n\u001c8SKN\u0004xN\\:f\u0011\u0006tG\r\\3s'\u0015Q$1\u0001B9!\u0011\tyNa\u001d\n\t\tU\u0014\u0011\u0019\u0002#\u0007>tGO]8mY\u0016\u0014(+Z9vKN$8i\\7qY\u0016$\u0018n\u001c8IC:$G.\u001a:\u0015\u0005\te\u0004c\u0001B\u0011u\u0005QqN\\\"p[BdW\r^3\u0015\t\u0005=%q\u0010\u0005\b\u0005\u0003c\u0004\u0019\u0001BB\u0003!\u0011Xm\u001d9p]N,\u0007\u0003\u0002BC\u0005\u0017k!Aa\"\u000b\u0007\t%U,A\u0004dY&,g\u000e^:\n\t\t5%q\u0011\u0002\u000f\u00072LWM\u001c;SKN\u0004xN\\:f\u0003%yg\u000eV5nK>,H/A\u0013tG\",G-\u001e7f\u001d\u0016DHoQ8n[Vt\u0017nY1uS>t\u0017I\u001a;fe\u001a\u000b\u0017\u000e\\;sK\u0006I2o\u00195fIVdWMT3yi\u000e{W.\\;oS\u000e\fG/[8o)\u0011\tyIa&\t\u000f\teu\b1\u0001\u0002 \u0006Q\u0011N\u001c;feZ\fG.T:\u0002;\r{g\u000e\u001e:pY2,'OU3hSN$(/\u0019;j_:l\u0015M\\1hKJ\u00042!a\u0019B'\t\t5\n\u0006\u0002\u0003\u001e\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIe*\"Aa*+\t\u0005U#\u0011V\u0016\u0003\u0005W\u0003BA!,\u000386\u0011!q\u0016\u0006\u0005\u0005c\u0013\u0019,A\u0005v]\u000eDWmY6fI*\u0019!QW'\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003:\n=&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class ControllerRegistrationManager
implements Logging,
MetadataPublisher {
    private final int nodeId;
    private final String clusterId;
    private final Time time;
    private final String threadNamePrefix;
    private final Map<String, VersionRange> supportedFeatures;
    private final boolean zkMigrationEnabled;
    private final Uuid incarnationId;
    private final ListenerInfo listenerInfo;
    private final ExponentialBackoff resendExponentialBackoff;
    private final LogContext logContext;
    private boolean pendingRpc;
    private long successfulRpcs;
    private long failedRpcs;
    private MetadataVersion kafka$server$ControllerRegistrationManager$$metadataVersion;
    private boolean registeredInLog;
    private NodeToControllerChannelManager kafka$server$ControllerRegistrationManager$$_channelManager;
    private final KafkaEventQueue eventQueue;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static ExponentialBackoff $lessinit$greater$default$9() {
        return ControllerRegistrationManager$.MODULE$.$lessinit$greater$default$9();
    }

    public void onControllerChange(LeaderAndEpoch x$1) {
        super.onControllerChange(x$1);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int nodeId() {
        return this.nodeId;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public Time time() {
        return this.time;
    }

    public String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    public Map<String, VersionRange> supportedFeatures() {
        return this.supportedFeatures;
    }

    public boolean zkMigrationEnabled() {
        return this.zkMigrationEnabled;
    }

    public Uuid incarnationId() {
        return this.incarnationId;
    }

    public ListenerInfo listenerInfo() {
        return this.listenerInfo;
    }

    public ExponentialBackoff resendExponentialBackoff() {
        return this.resendExponentialBackoff;
    }

    public String name() {
        return "ControllerRegistrationManager";
    }

    private String logPrefix() {
        StringBuilder builder = new StringBuilder("[ControllerRegistrationManager");
        builder.append(" id=").append(this.nodeId());
        builder.append(" incarnation=").append((Object)this.incarnationId());
        builder.append("] ");
        return builder.toString();
    }

    public LogContext logContext() {
        return this.logContext;
    }

    public boolean pendingRpc() {
        return this.pendingRpc;
    }

    public void pendingRpc_$eq(boolean x$1) {
        this.pendingRpc = x$1;
    }

    public long successfulRpcs() {
        return this.successfulRpcs;
    }

    public void successfulRpcs_$eq(long x$1) {
        this.successfulRpcs = x$1;
    }

    public long failedRpcs() {
        return this.failedRpcs;
    }

    public void failedRpcs_$eq(long x$1) {
        this.failedRpcs = x$1;
    }

    private MetadataVersion kafka$server$ControllerRegistrationManager$$metadataVersion() {
        return this.kafka$server$ControllerRegistrationManager$$metadataVersion;
    }

    public void kafka$server$ControllerRegistrationManager$$metadataVersion_$eq(MetadataVersion x$1) {
        this.kafka$server$ControllerRegistrationManager$$metadataVersion = x$1;
    }

    public boolean registeredInLog() {
        return this.registeredInLog;
    }

    public void registeredInLog_$eq(boolean x$1) {
        this.registeredInLog = x$1;
    }

    public NodeToControllerChannelManager kafka$server$ControllerRegistrationManager$$_channelManager() {
        return this.kafka$server$ControllerRegistrationManager$$_channelManager;
    }

    public void kafka$server$ControllerRegistrationManager$$_channelManager_$eq(NodeToControllerChannelManager x$1) {
        this.kafka$server$ControllerRegistrationManager$$_channelManager = x$1;
    }

    public KafkaEventQueue eventQueue() {
        return this.eventQueue;
    }

    public void start(NodeToControllerChannelManager channelManager) {
        this.eventQueue().append(() -> {
            try {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "initialized channel manager.");
                this.kafka$server$ControllerRegistrationManager$$_channelManager_$eq(channelManager);
                this.kafka$server$ControllerRegistrationManager$$maybeSendControllerRegistration();
                return;
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "start error", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
                return;
            }
        });
    }

    public void beginShutdown() {
        this.eventQueue().beginShutdown("beginShutdown");
    }

    public void close() {
        this.beginShutdown();
        this.eventQueue().close();
    }

    public void onMetadataUpdate(MetadataDelta delta, MetadataImage newImage, LoaderManifest manifest) {
        if (delta.featuresDelta() != null || delta.clusterDelta() != null && delta.clusterDelta().changedControllers().containsKey(BoxesRunTime.boxToInteger((int)this.nodeId()))) {
            this.eventQueue().append((EventQueue.Event)new MetadataUpdateEvent(this, delta, newImage));
            return;
        }
    }

    public void kafka$server$ControllerRegistrationManager$$maybeSendControllerRegistration() {
        if (this.registeredInLog()) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "maybeSendControllerRegistration: controller is already registered.");
            return;
        }
        if (this.kafka$server$ControllerRegistrationManager$$_channelManager() == null) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "maybeSendControllerRegistration: cannot register yet because the channel manager has not been initialized.");
            return;
        }
        if (!this.kafka$server$ControllerRegistrationManager$$metadataVersion().isControllerRegistrationSupported()) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(148).append("maybeSendControllerRegistration: cannot register yet because the metadata version is ").append("still ").append(this.kafka$server$ControllerRegistrationManager$$metadataVersion()).append(", which does not support KIP-919 controller registration.").toString());
            return;
        }
        if (this.pendingRpc()) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "maybeSendControllerRegistration: waiting for the previous RPC to complete.");
            return;
        }
        this.sendControllerRegistration();
    }

    private void sendControllerRegistration() {
        ControllerRegistrationRequestData.FeatureCollection features = new ControllerRegistrationRequestData.FeatureCollection();
        ((IterableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(this.supportedFeatures()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ControllerRegistrationManager.$anonfun$sendControllerRegistration$1(features, x0$1)));
        ControllerRegistrationRequestData data = new ControllerRegistrationRequestData().setControllerId(this.nodeId()).setFeatures(features).setIncarnationId(this.incarnationId()).setListeners(this.listenerInfo().toControllerRegistrationRequest()).setZkMigrationReady(this.zkMigrationEnabled());
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(47).append("sendControllerRegistration: attempting to send ").append(data).toString());
        this.kafka$server$ControllerRegistrationManager$$_channelManager().sendRequest((AbstractRequest.Builder)new ControllerRegistrationRequest.Builder(data), (ControllerRequestCompletionHandler)new RegistrationResponseHandler());
        this.pendingRpc_$eq(true);
    }

    public void kafka$server$ControllerRegistrationManager$$scheduleNextCommunicationAfterFailure() {
        long delayMs = this.resendExponentialBackoff().backoff(this.failedRpcs());
        this.failedRpcs_$eq(this.failedRpcs() + 1L);
        this.scheduleNextCommunication(delayMs);
    }

    private void scheduleNextCommunication(long intervalMs) {
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(46).append("Scheduling next communication at ").append(intervalMs).append(" ms from now.").toString());
        long deadlineNs = this.time().nanoseconds() + TimeUnit.MILLISECONDS.toNanos(intervalMs);
        this.eventQueue().scheduleDeferred("communication", (Function)new EventQueue.DeadlineFunction(deadlineNs), () -> this.kafka$server$ControllerRegistrationManager$$maybeSendControllerRegistration());
    }

    public static final /* synthetic */ boolean $anonfun$sendControllerRegistration$1(ControllerRegistrationRequestData.FeatureCollection features$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String name = (String)x0$1._1();
            VersionRange range = (VersionRange)x0$1._2();
            return features$1.add((ImplicitLinkedHashCollection.Element)new ControllerRegistrationRequestData.Feature().setName(name).setMinSupportedVersion(range.min()).setMaxSupportedVersion(range.max()));
        }
        throw new MatchError(null);
    }

    public ControllerRegistrationManager(int nodeId, String clusterId, Time time, String threadNamePrefix, Map<String, VersionRange> supportedFeatures, boolean zkMigrationEnabled, Uuid incarnationId, ListenerInfo listenerInfo, ExponentialBackoff resendExponentialBackoff) {
        this.nodeId = nodeId;
        this.clusterId = clusterId;
        this.time = time;
        this.threadNamePrefix = threadNamePrefix;
        this.supportedFeatures = supportedFeatures;
        this.zkMigrationEnabled = zkMigrationEnabled;
        this.incarnationId = incarnationId;
        this.listenerInfo = listenerInfo;
        this.resendExponentialBackoff = resendExponentialBackoff;
        Logging.$init$(this);
        this.logContext = new LogContext(this.logPrefix());
        this.logIdent_$eq(this.logContext().logPrefix());
        this.pendingRpc = false;
        this.successfulRpcs = 0L;
        this.failedRpcs = 0L;
        this.kafka$server$ControllerRegistrationManager$$metadataVersion = MetadataVersion.MINIMUM_KRAFT_VERSION;
        this.registeredInLog = false;
        this.eventQueue = new KafkaEventQueue(time, this.logContext(), new java.lang.StringBuilder(21).append(threadNamePrefix).append("registration-manager-").toString(), (EventQueue.Event)new ShutdownEvent());
    }

    private class MetadataUpdateEvent
    implements EventQueue.Event {
        private final MetadataDelta delta;
        private final MetadataImage newImage;
        public final /* synthetic */ ControllerRegistrationManager $outer;

        public void handleException(Throwable x$1) {
            super.handleException(x$1);
        }

        public void run() {
            try {
                if (this.delta.featuresDelta() != null) {
                    this.kafka$server$ControllerRegistrationManager$MetadataUpdateEvent$$$outer().kafka$server$ControllerRegistrationManager$$metadataVersion_$eq(this.newImage.features().metadataVersion());
                }
                if (this.delta.clusterDelta() != null && this.delta.clusterDelta().changedControllers().containsKey(BoxesRunTime.boxToInteger((int)this.kafka$server$ControllerRegistrationManager$MetadataUpdateEvent$$$outer().nodeId()))) {
                    ControllerRegistration curRegistration = (ControllerRegistration)this.newImage.cluster().controllers().get(BoxesRunTime.boxToInteger((int)this.kafka$server$ControllerRegistrationManager$MetadataUpdateEvent$$$outer().nodeId()));
                    if (curRegistration == null) {
                        this.kafka$server$ControllerRegistrationManager$MetadataUpdateEvent$$$outer().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Registration removed for this node ID.");
                        this.kafka$server$ControllerRegistrationManager$MetadataUpdateEvent$$$outer().registeredInLog_$eq(false);
                    } else if (!curRegistration.incarnationId().equals((Object)this.kafka$server$ControllerRegistrationManager$MetadataUpdateEvent$$$outer().incarnationId())) {
                        this.kafka$server$ControllerRegistrationManager$MetadataUpdateEvent$$$outer().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(51).append("Found registration for ").append(curRegistration.incarnationId()).append(" instead of our incarnation.").toString());
                        this.kafka$server$ControllerRegistrationManager$MetadataUpdateEvent$$$outer().registeredInLog_$eq(false);
                    } else {
                        this.kafka$server$ControllerRegistrationManager$MetadataUpdateEvent$$$outer().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Our registration has been persisted to the metadata log.");
                        this.kafka$server$ControllerRegistrationManager$MetadataUpdateEvent$$$outer().registeredInLog_$eq(true);
                    }
                }
                this.kafka$server$ControllerRegistrationManager$MetadataUpdateEvent$$$outer().kafka$server$ControllerRegistrationManager$$maybeSendControllerRegistration();
                return;
            }
            catch (Throwable t) {
                this.kafka$server$ControllerRegistrationManager$MetadataUpdateEvent$$$outer().error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "onMetadataUpdate error", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
                return;
            }
        }

        public /* synthetic */ ControllerRegistrationManager kafka$server$ControllerRegistrationManager$MetadataUpdateEvent$$$outer() {
            return this.$outer;
        }

        public MetadataUpdateEvent(ControllerRegistrationManager $outer, MetadataDelta delta, MetadataImage newImage) {
            this.delta = delta;
            this.newImage = newImage;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    private class RegistrationResponseHandler
    implements ControllerRequestCompletionHandler {
        public void onComplete(ClientResponse response) {
            Errors errorCode;
            this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().pendingRpc_$eq(false);
            if (response.authenticationException() != null) {
                this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "RegistrationResponseHandler: authentication error", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> response.authenticationException());
                this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().kafka$server$ControllerRegistrationManager$$scheduleNextCommunicationAfterFailure();
                return;
            }
            if (response.versionMismatch() != null) {
                this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "RegistrationResponseHandler: unsupported API version error", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> response.versionMismatch());
                this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().kafka$server$ControllerRegistrationManager$$scheduleNextCommunicationAfterFailure();
                return;
            }
            if (response.responseBody() == null) {
                this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "RegistrationResponseHandler: unknown error");
                this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().kafka$server$ControllerRegistrationManager$$scheduleNextCommunicationAfterFailure();
                return;
            }
            if (!(response.responseBody() instanceof ControllerRegistrationResponse)) {
                this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "RegistrationResponseHandler: invalid response type error");
                this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().kafka$server$ControllerRegistrationManager$$scheduleNextCommunicationAfterFailure();
                return;
            }
            ControllerRegistrationResponse message = (ControllerRegistrationResponse)response.responseBody();
            Errors errors = errorCode = Errors.forCode((short)message.data().errorCode());
            Errors errors2 = Errors.NONE;
            if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().successfulRpcs_$eq(this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().successfulRpcs() + 1L);
                this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().failedRpcs_$eq(0L);
                this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "RegistrationResponseHandler: controller acknowledged ControllerRegistrationRequest.");
                return;
            }
            this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(58).append("RegistrationResponseHandler: controller returned error ").append(errorCode).append(" ").append("(").append(message.data().errorMessage()).append(")").toString());
            this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().kafka$server$ControllerRegistrationManager$$scheduleNextCommunicationAfterFailure();
        }

        public void onTimeout() {
            this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "RegistrationResponseHandler: channel manager timed out before sending the request.");
            this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().kafka$server$ControllerRegistrationManager$$scheduleNextCommunicationAfterFailure();
        }

        public /* synthetic */ ControllerRegistrationManager kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer() {
            return ControllerRegistrationManager.this;
        }

        public RegistrationResponseHandler() {
            if (ControllerRegistrationManager.this == null) {
                throw null;
            }
        }
    }

    private class ShutdownEvent
    implements EventQueue.Event {
        public void handleException(Throwable x$1) {
            super.handleException(x$1);
        }

        public void run() {
            try {
                this.kafka$server$ControllerRegistrationManager$ShutdownEvent$$$outer().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "shutting down.");
                if (this.kafka$server$ControllerRegistrationManager$ShutdownEvent$$$outer().kafka$server$ControllerRegistrationManager$$_channelManager() != null) {
                    this.kafka$server$ControllerRegistrationManager$ShutdownEvent$$$outer().kafka$server$ControllerRegistrationManager$$_channelManager().shutdown();
                    this.kafka$server$ControllerRegistrationManager$ShutdownEvent$$$outer().kafka$server$ControllerRegistrationManager$$_channelManager_$eq(null);
                }
            }
            catch (Throwable t) {
                this.kafka$server$ControllerRegistrationManager$ShutdownEvent$$$outer().error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "ControllerRegistrationManager.stop error", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            }
        }

        public /* synthetic */ ControllerRegistrationManager kafka$server$ControllerRegistrationManager$ShutdownEvent$$$outer() {
            return ControllerRegistrationManager.this;
        }

        public ShutdownEvent() {
            if (ControllerRegistrationManager.this == null) {
                throw null;
            }
        }
    }
}

