/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.MissingNode;
import kafka.utils.json.JsonValue;
import kafka.utils.json.JsonValue$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.package$;
import scala.reflect.ClassTag;
import scala.util.Either;

public final class Json$ {
    public static Json$ MODULE$;
    private final ObjectMapper mapper;

    static {
        new Json$();
    }

    private ObjectMapper mapper() {
        return this.mapper;
    }

    public Option<JsonValue> parseFull(String input) {
        return this.tryParseFull(input).toOption();
    }

    public <T> Either<JsonProcessingException, T> parseStringAs(String input, ClassTag<T> tag) {
        try {
            return package$.MODULE$.Right().apply(this.mapper().readValue(input, tag.runtimeClass()));
        }
        catch (JsonProcessingException e) {
            return package$.MODULE$.Left().apply((Object)e);
        }
    }

    public Option<JsonValue> parseBytes(byte[] input) {
        try {
            return Option$.MODULE$.apply((Object)this.mapper().readTree(input)).map((Function1 & java.io.Serializable & Serializable)x$1 -> JsonValue$.MODULE$.apply((JsonNode)x$1));
        }
        catch (JsonProcessingException jsonProcessingException) {
            return None$.MODULE$;
        }
    }

    public Either<JsonProcessingException, JsonValue> tryParseBytes(byte[] input) {
        try {
            return package$.MODULE$.Right().apply((Object)this.mapper().readTree(input)).map((Function1 & java.io.Serializable & Serializable)x$2 -> JsonValue$.MODULE$.apply((JsonNode)x$2));
        }
        catch (JsonProcessingException e) {
            return package$.MODULE$.Left().apply((Object)e);
        }
    }

    public <T> Either<JsonProcessingException, T> parseBytesAs(byte[] input, ClassTag<T> tag) {
        try {
            return package$.MODULE$.Right().apply(this.mapper().readValue(input, tag.runtimeClass()));
        }
        catch (JsonProcessingException e) {
            return package$.MODULE$.Left().apply((Object)e);
        }
    }

    public Either<JsonProcessingException, JsonValue> tryParseFull(String input) {
        if (input == null || input.isEmpty()) {
            return package$.MODULE$.Left().apply((Object)new JsonParseException(MissingNode.getInstance().traverse(), "The input string shouldn't be empty"));
        }
        try {
            return package$.MODULE$.Right().apply((Object)this.mapper().readTree(input)).map((Function1 & java.io.Serializable & Serializable)x$3 -> JsonValue$.MODULE$.apply((JsonNode)x$3));
        }
        catch (JsonProcessingException e) {
            return package$.MODULE$.Left().apply((Object)e);
        }
    }

    public String encodeAsString(Object obj) {
        return this.mapper().writeValueAsString(obj);
    }

    public byte[] encodeAsBytes(Object obj) {
        return this.mapper().writeValueAsBytes(obj);
    }

    private Json$() {
        MODULE$ = this;
        this.mapper = new ObjectMapper();
    }
}

