/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class Endian {
    private Endian() {
    }

    public static char littleChar(InputStream input) throws IOException {
        int lo = input.read();
        if (lo < 0) {
            throw new EOFException();
        }
        int hi = input.read();
        if (hi < 0) {
            throw new EOFException();
        }
        return (char)(hi << 8 | lo);
    }

    public static short littleShort(InputStream input) throws IOException {
        return (short)Endian.littleChar(input);
    }

    public static int littleInt(InputStream input) throws IOException {
        char lo = Endian.littleChar(input);
        char hi = Endian.littleChar(input);
        return hi << 16 | lo;
    }

    public static char bigChar(InputStream input) throws IOException {
        int hi = input.read();
        if (hi < 0) {
            throw new EOFException();
        }
        int lo = input.read();
        if (lo < 0) {
            throw new EOFException();
        }
        return (char)(hi << 8 | lo);
    }

    public static int bigInt(InputStream input) throws IOException {
        char hi = Endian.bigChar(input);
        char lo = Endian.bigChar(input);
        return hi << 16 | lo;
    }
}

