/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.css.ComputedCssStyleDeclaration;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import java.util.Map;

public class HtmlBody
extends HtmlElement {
    public static final String TAG_NAME = "body";
    private final boolean temporary_;

    public HtmlBody(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes, boolean temporary) {
        super(qualifiedName, page, attributes);
        this.temporary_ = temporary;
    }

    public final String getOnLoadAttribute() {
        return this.getAttributeDirect("onload");
    }

    public final String getOnUnloadAttribute() {
        return this.getAttributeDirect("onunload");
    }

    public final String getBackgroundAttribute() {
        return this.getAttributeDirect("background");
    }

    public final String getBgcolorAttribute() {
        return this.getAttributeDirect("bgcolor");
    }

    public final String getTextAttribute() {
        return this.getAttributeDirect("text");
    }

    public final String getLinkAttribute() {
        return this.getAttributeDirect("link");
    }

    public final String getVlinkAttribute() {
        return this.getAttributeDirect("vlink");
    }

    public final String getAlinkAttribute() {
        return this.getAttributeDirect("alink");
    }

    public final boolean isTemporary() {
        return this.temporary_;
    }

    @Override
    public boolean handles(Event event) {
        if ("blur".equals(event.getType()) || "focus".equals(event.getType())) {
            return true;
        }
        return super.handles(event);
    }

    @Override
    public void setDefaults(ComputedCssStyleDeclaration style) {
        if (this.getPage().getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_BODY_MARGINS_8)) {
            style.setDefaultLocalStyleAttribute("margin", "8px");
            style.setDefaultLocalStyleAttribute("padding", "0px");
        } else {
            style.setDefaultLocalStyleAttribute("margin-left", "8px");
            style.setDefaultLocalStyleAttribute("margin-right", "8px");
            style.setDefaultLocalStyleAttribute("margin-top", "8px");
            style.setDefaultLocalStyleAttribute("margin-bottom", "8px");
        }
    }
}

