/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp.parser;

import org.apache.commons.net.ftp.FTPFileEntryParser;
import org.apache.commons.net.ftp.parser.CompositeFileEntryParser;
import org.apache.commons.net.ftp.parser.FTPFileEntryParserFactory;
import org.apache.commons.net.ftp.parser.NTFTPEntryParser;
import org.apache.commons.net.ftp.parser.OS2FTPEntryParser;
import org.apache.commons.net.ftp.parser.OS400FTPEntryParser;
import org.apache.commons.net.ftp.parser.ParserInitializationException;
import org.apache.commons.net.ftp.parser.UnixFTPEntryParser;
import org.apache.commons.net.ftp.parser.VMSVersioningFTPEntryParser;

public class DefaultFTPFileEntryParserFactory
implements FTPFileEntryParserFactory {
    public FTPFileEntryParser createFileEntryParser(String key) {
        Class<?> parserClass = null;
        try {
            parserClass = Class.forName(key);
            return (FTPFileEntryParser)parserClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            String ukey = null;
            if (null != key) {
                ukey = key.toUpperCase();
            }
            if (ukey.indexOf("UNIX") >= 0) {
                return this.createUnixFTPEntryParser();
            }
            if (ukey.indexOf("VMS") >= 0) {
                return this.createVMSVersioningFTPEntryParser();
            }
            if (ukey.indexOf("WINDOWS") >= 0) {
                return this.createNTFTPEntryParser();
            }
            if (ukey.indexOf("OS/2") >= 0) {
                return this.createOS2FTPEntryParser();
            }
            if (ukey.indexOf("OS/400") >= 0) {
                return this.createOS400FTPEntryParser();
            }
            throw new ParserInitializationException("Unknown parser type: " + key);
        }
        catch (ClassCastException e) {
            throw new ParserInitializationException(parserClass.getName() + " does not implement the interface " + "org.apache.commons.net.ftp.FTPFileEntryParser.", e);
        }
        catch (Throwable e) {
            throw new ParserInitializationException("Error initializing parser", e);
        }
    }

    public FTPFileEntryParser createUnixFTPEntryParser() {
        return new UnixFTPEntryParser();
    }

    public FTPFileEntryParser createVMSVersioningFTPEntryParser() {
        return new VMSVersioningFTPEntryParser();
    }

    public FTPFileEntryParser createNTFTPEntryParser() {
        return new CompositeFileEntryParser(new FTPFileEntryParser[]{new NTFTPEntryParser(), new UnixFTPEntryParser()});
    }

    public FTPFileEntryParser createOS2FTPEntryParser() {
        return new OS2FTPEntryParser();
    }

    public FTPFileEntryParser createOS400FTPEntryParser() {
        return new CompositeFileEntryParser(new FTPFileEntryParser[]{new OS400FTPEntryParser(), new UnixFTPEntryParser()});
    }
}

