/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.metadata.PartitionRegistration;

public final class LocalReplicaChanges {
    private final Set<TopicPartition> deletes;
    private final Map<TopicPartition, PartitionInfo> leaders;
    private final Map<TopicPartition, PartitionInfo> followers;
    private final Map<String, Uuid> topicIds;
    private final Map<TopicIdPartition, Uuid> directoryIds;

    LocalReplicaChanges(Set<TopicPartition> deletes, Map<TopicPartition, PartitionInfo> leaders, Map<TopicPartition, PartitionInfo> followers, Map<String, Uuid> topicIds, Map<TopicIdPartition, Uuid> directoryIds) {
        this.deletes = deletes;
        this.leaders = leaders;
        this.followers = followers;
        this.topicIds = topicIds;
        this.directoryIds = directoryIds;
    }

    public Set<TopicPartition> deletes() {
        return this.deletes;
    }

    public Map<TopicPartition, PartitionInfo> leaders() {
        return this.leaders;
    }

    public Map<TopicPartition, PartitionInfo> followers() {
        return this.followers;
    }

    public Map<String, Uuid> topicIds() {
        return this.topicIds;
    }

    public String toString() {
        return String.format("LocalReplicaChanges(deletes = %s, leaders = %s, followers = %s)", this.deletes, this.leaders, this.followers);
    }

    public Map<TopicIdPartition, Uuid> directoryIds() {
        return this.directoryIds;
    }

    public static final class PartitionInfo {
        private final Uuid topicId;
        private final PartitionRegistration partition;

        public PartitionInfo(Uuid topicId, PartitionRegistration partition) {
            this.topicId = topicId;
            this.partition = partition;
        }

        public String toString() {
            return String.format("PartitionInfo(topicId = %s, partition = %s)", this.topicId, this.partition);
        }

        public Uuid topicId() {
            return this.topicId;
        }

        public PartitionRegistration partition() {
            return this.partition;
        }
    }
}

