/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chromium;

import java.util.Map;
import java.util.logging.Level;

public enum ChromiumDriverLogLevel {
    ALL,
    INFO,
    DEBUG,
    WARNING,
    SEVERE,
    OFF;

    private static final Map<Level, ChromiumDriverLogLevel> logLevelToChromeLevelMap;

    public String toString() {
        return super.toString().toLowerCase();
    }

    public static ChromiumDriverLogLevel fromString(String text) {
        if (text != null) {
            for (ChromiumDriverLogLevel b : ChromiumDriverLogLevel.values()) {
                if (!text.equalsIgnoreCase(b.toString())) continue;
                return b;
            }
        }
        return null;
    }

    public static ChromiumDriverLogLevel fromLevel(Level level) {
        return logLevelToChromeLevelMap.getOrDefault(level, ALL);
    }

    static {
        logLevelToChromeLevelMap = Map.of(Level.ALL, ALL, Level.FINEST, DEBUG, Level.FINER, DEBUG, Level.FINE, DEBUG, Level.INFO, INFO, Level.WARNING, WARNING, Level.SEVERE, SEVERE, Level.OFF, OFF);
    }
}

