/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.tools;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Properties;

public class CommonCrawlConfig
implements Serializable {
    private static final long serialVersionUID = 5235013733207799661L;
    private String keyPrefix = "";
    private boolean simpleDateFormat = false;
    private boolean jsonArray = false;
    private boolean reverseKey = false;
    private String reverseKeyValue = "";
    private boolean compressed = false;
    private long warcSize = 0L;
    private String outputDir;

    public CommonCrawlConfig() {
    }

    public CommonCrawlConfig(InputStream stream) {
        this.init(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(InputStream stream) {
        if (stream == null) {
            return;
        }
        Properties properties = new Properties();
        try {
            properties.load(stream);
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        this.setKeyPrefix(properties.getProperty("keyPrefix", ""));
        this.setSimpleDateFormat(Boolean.parseBoolean(properties.getProperty("simpleDateFormat", "False")));
        this.setJsonArray(Boolean.parseBoolean(properties.getProperty("jsonArray", "False")));
        this.setReverseKey(Boolean.parseBoolean(properties.getProperty("reverseKey", "False")));
    }

    public void setKeyPrefix(String keyPrefix) {
        this.keyPrefix = keyPrefix;
    }

    public void setSimpleDateFormat(boolean simpleDateFormat) {
        this.simpleDateFormat = simpleDateFormat;
    }

    public void setJsonArray(boolean jsonArray) {
        this.jsonArray = jsonArray;
    }

    public void setReverseKey(boolean reverseKey) {
        this.reverseKey = reverseKey;
    }

    public void setReverseKeyValue(String reverseKeyValue) {
        this.reverseKeyValue = reverseKeyValue;
    }

    public String getKeyPrefix() {
        return this.keyPrefix;
    }

    public boolean getSimpleDateFormat() {
        return this.simpleDateFormat;
    }

    public boolean getJsonArray() {
        return this.jsonArray;
    }

    public boolean getReverseKey() {
        return this.reverseKey;
    }

    public String getReverseKeyValue() {
        return this.reverseKeyValue;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    public long getWarcSize() {
        return this.warcSize;
    }

    public void setWarcSize(long warcSize) {
        this.warcSize = warcSize;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(String outputDir) {
        this.outputDir = outputDir;
    }
}

