/*
 * Decompiled with CFR 0.152.
 */
package crawlercommons.domains;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SuffixTrie<V> {
    protected Node<V> root = new Node();

    public V put(String suffix, V value) {
        V res = null;
        if (suffix.isEmpty()) {
            res = this.root.value;
            this.root.value = value;
            return res;
        }
        Node<Object> node = this.root;
        for (int i = suffix.length() - 1; i > 0; --i) {
            node = node.addChild(suffix.charAt(i), null);
        }
        Node<V> resNode = node.getChild(suffix.charAt(0));
        if (resNode == null) {
            node.addChild(suffix.charAt(0), value);
            return null;
        }
        node.addChild(suffix.charAt(0), value);
        return resNode.value;
    }

    public V get(String suffix) {
        if (suffix.isEmpty()) {
            return this.root.value;
        }
        Node<V> node = this.root;
        for (int i = suffix.length() - 1; i >= 0; --i) {
            if ((node = node.getChild(suffix.charAt(i))) != null) continue;
            return null;
        }
        return node.value;
    }

    public boolean contains(String suffix) {
        return this.get(suffix) != null;
    }

    protected LookupResult<V> getLongestSuffix(String string) {
        Node<V> node = this.root;
        Object resValue = null;
        int offset = -1;
        if (node.value != null) {
            offset = string.length();
            resValue = node.value;
        }
        for (int i = string.length() - 1; i >= 0 && (node = node.getChild(string.charAt(i))) != null; --i) {
            if (node.value == null) continue;
            offset = i;
            resValue = node.value;
        }
        if (offset != -1) {
            return new LookupResult<Object>(offset, resValue);
        }
        return null;
    }

    protected List<LookupResult<V>> getSuffixes(String string) {
        ArrayList<LookupResult<V>> res = new ArrayList<LookupResult<V>>();
        Node<V> node = this.root;
        if (node.value != null) {
            res.add(new LookupResult(string.length(), node.value));
        }
        for (int i = string.length() - 1; i >= 0 && (node = node.getChild(string.charAt(i))) != null; --i) {
            if (node.value == null) continue;
            res.add(new LookupResult(i, node.value));
        }
        return res;
    }

    public static class LookupResult<V> {
        int offset;
        V value;

        public LookupResult(int offset, V value) {
            this.offset = offset;
            this.value = value;
        }
    }

    protected static class Node<V> {
        char[] chars = new char[0];
        Node<V>[] children = new Node[0];
        V value = null;

        protected Node() {
        }

        public Node<V> getChild(char c) {
            int pos = Arrays.binarySearch(this.chars, c);
            if (pos >= 0) {
                return this.children[pos];
            }
            return null;
        }

        public Node<V> addChild(char c, V value) {
            Node<V> child;
            int pos = Arrays.binarySearch(this.chars, c);
            if (pos >= 0) {
                child = this.children[pos];
            } else {
                child = new Node<V>();
                char[] new_chars = new char[this.chars.length + 1];
                Node[] new_children = new Node[this.children.length + 1];
                pos = -pos - 1;
                new_chars[pos] = c;
                new_children[pos] = child;
                for (int i = 0; i < this.chars.length; ++i) {
                    if (i < pos) {
                        new_chars[i] = this.chars[i];
                        new_children[i] = this.children[i];
                        continue;
                    }
                    if (i < pos) continue;
                    new_chars[i + 1] = this.chars[i];
                    new_children[i + 1] = this.children[i];
                }
                this.chars = new_chars;
                this.children = new_children;
            }
            if (value != null) {
                child.value = value;
            }
            return child;
        }
    }
}

