/*
 * Decompiled with CFR 0.152.
 */
package com.barchart.udt;

import com.barchart.udt.SocketUDT;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorUDT {
    private static final Logger log = LoggerFactory.getLogger(MonitorUDT.class);
    protected final SocketUDT socketUDT;
    protected volatile long msTimeStamp;
    protected volatile long pktSentTotal;
    protected volatile long pktRecvTotal;
    protected volatile int pktSndLossTotal;
    protected volatile int pktRcvLossTotal;
    protected volatile int pktRetransTotal;
    protected volatile int pktSentACKTotal;
    protected volatile int pktRecvACKTotal;
    protected volatile int pktSentNAKTotal;
    protected volatile int pktRecvNAKTotal;
    protected volatile long usSndDurationTotal;
    protected volatile long pktSent;
    protected volatile long pktRecv;
    protected volatile int pktSndLoss;
    protected volatile int pktRcvLoss;
    protected volatile int pktRetrans;
    protected volatile int pktSentACK;
    protected volatile int pktRecvACK;
    protected volatile int pktSentNAK;
    protected volatile int pktRecvNAK;
    protected volatile double mbpsSendRate;
    protected volatile double mbpsRecvRate;
    protected volatile long usSndDuration;
    protected volatile double usPktSndPeriod;
    protected volatile int pktFlowWindow;
    protected volatile int pktCongestionWindow;
    protected volatile int pktFlightSize;
    protected volatile double msRTT;
    protected volatile double mbpsBandwidth;
    protected volatile int byteAvailSndBuf;
    protected volatile int byteAvailRcvBuf;

    protected MonitorUDT(SocketUDT socketUDT) {
        this.socketUDT = socketUDT;
    }

    public long millisSinceStart() {
        return this.msTimeStamp;
    }

    public long globalSentTotal() {
        return this.pktSentTotal;
    }

    public long globalReceivedTotal() {
        return this.pktRecvTotal;
    }

    public int globalSenderLost() {
        return this.pktSndLossTotal;
    }

    public int globalReceiverLost() {
        return this.pktRcvLossTotal;
    }

    public int globalRetransmittedTotal() {
        return this.pktRetransTotal;
    }

    public int globalSentAckTotal() {
        return this.pktSentACKTotal;
    }

    public int globalReceivedAckTotal() {
        return this.pktRecvACKTotal;
    }

    public int globalSentNakTotal() {
        return this.pktSentNAKTotal;
    }

    public int globalReceivedNakTotal() {
        return this.pktRecvNAKTotal;
    }

    public long globalMicrosSendDurationTotal() {
        return this.usSndDurationTotal;
    }

    public long localPacketsSent() {
        return this.pktSent;
    }

    public long localPacketsReceived() {
        return this.pktRecv;
    }

    public int localSenderLost() {
        return this.pktSndLoss;
    }

    public int localReceiverLost() {
        return this.pktRcvLoss;
    }

    public int localRetransmitted() {
        return this.pktRetrans;
    }

    public int localSentAck() {
        return this.pktSentACK;
    }

    public int localReceivedAck() {
        return this.pktRecvACK;
    }

    public int localSentNak() {
        return this.pktSentNAK;
    }

    public int localReceivedNak() {
        return this.pktRecvNAK;
    }

    public double mbpsSendRate() {
        return this.mbpsSendRate;
    }

    public double mbpsReceiveRate() {
        return this.mbpsRecvRate;
    }

    public long microsSendTime() {
        return this.usSndDuration;
    }

    public double currentSendPeriod() {
        return this.usPktSndPeriod;
    }

    public int currentFlowWindow() {
        return this.pktFlowWindow;
    }

    public int currentCongestionWindow() {
        return this.pktCongestionWindow;
    }

    public int currentFlightSize() {
        return this.pktFlightSize;
    }

    public double currentMillisRTT() {
        return this.msRTT;
    }

    public double currentMbpsBandwidth() {
        return this.mbpsBandwidth;
    }

    public int currentAvailableInSender() {
        return this.byteAvailSndBuf;
    }

    public int currentAvailableInReceiver() {
        return this.byteAvailRcvBuf;
    }

    public void appendSnapshot(StringBuilder text) {
        Field[] fieldArray;
        text.append("\n\t");
        text.append(String.format("[id: 0x%08x]", this.socketUDT.id()));
        for (Field field : fieldArray = MonitorUDT.class.getDeclaredFields()) {
            if (!this.isNumeric(field)) continue;
            try {
                field.setAccessible(true);
                String fieldName = field.getName();
                String fieldValue = field.get(this).toString();
                text.append("\n\t");
                text.append(fieldName);
                text.append(" = ");
                text.append(fieldValue);
            }
            catch (Exception e) {
                log.error("unexpected", (Throwable)e);
            }
        }
        double localSendLoss = 100.0 * (double)this.pktSndLoss / (double)this.pktSent;
        text.append("\n\t% localSendLoss = ");
        text.append(localSendLoss);
        double localReceiveLoss = 100.0 * (double)this.pktRcvLoss / (double)this.pktRecv;
        text.append("\n\t% localReceiveLoss = ");
        text.append(localReceiveLoss);
    }

    protected boolean isNumeric(Field field) {
        Class<?> fieledType = field.getType();
        return fieledType == Integer.TYPE || fieledType == Long.TYPE || fieledType == Double.TYPE;
    }

    public String toString() {
        StringBuilder text = new StringBuilder(1024);
        this.appendSnapshot(text);
        return text.toString();
    }
}

