/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.parsefilter.naivebayes;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class Classify {
    private static int uniquewords_size = 0;
    private static int numof_ir = 0;
    private static int numwords_ir = 0;
    private static HashMap<String, Integer> wordfreq_ir = null;
    private static int numof_r = 0;
    private static int numwords_r = 0;
    private static HashMap<String, Integer> wordfreq_r = null;
    private static boolean ismodel = false;

    public static HashMap<String, Integer> unflattenToHashmap(String line) {
        String[] dictarray;
        HashMap<String, Integer> dict = new HashMap<String, Integer>();
        for (String field : dictarray = line.split(",")) {
            dict.put(field.split(":")[0], Integer.valueOf(field.split(":")[1]));
        }
        return dict;
    }

    public static String classify(String line) throws IOException {
        double prob_ir = 0.0;
        double prob_r = 0.0;
        String result = "1";
        String[] linearray = line.replaceAll("[^a-zA-Z ]", "").toLowerCase().split(" ");
        if (!ismodel) {
            Configuration configuration = new Configuration();
            FileSystem fs = FileSystem.get((Configuration)configuration);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fs.open(new Path("naivebayes-model"))));
            uniquewords_size = Integer.parseInt(bufferedReader.readLine());
            bufferedReader.readLine();
            numof_ir = Integer.parseInt(bufferedReader.readLine());
            numwords_ir = Integer.parseInt(bufferedReader.readLine());
            wordfreq_ir = Classify.unflattenToHashmap(bufferedReader.readLine());
            bufferedReader.readLine();
            numof_r = Integer.parseInt(bufferedReader.readLine());
            numwords_r = Integer.parseInt(bufferedReader.readLine());
            wordfreq_r = Classify.unflattenToHashmap(bufferedReader.readLine());
            ismodel = true;
            bufferedReader.close();
        }
        for (String word : linearray) {
            prob_ir = wordfreq_ir.containsKey(word) ? (prob_ir += Math.log(wordfreq_ir.get(word).intValue()) + 1.0 - Math.log(numwords_ir + uniquewords_size)) : (prob_ir += 1.0 - Math.log(numwords_ir + uniquewords_size));
            if (wordfreq_r.containsKey(word)) {
                prob_r += Math.log(wordfreq_r.get(word).intValue()) + 1.0 - Math.log(numwords_r + uniquewords_size);
                continue;
            }
            prob_r += 1.0 - Math.log(numwords_r + uniquewords_size);
        }
        result = (prob_ir += Math.log(numof_ir) - Math.log(numof_ir + numof_r)) > (prob_r += Math.log(numof_r) - Math.log(numof_ir + numof_r)) ? "0" : "1";
        return result;
    }
}

