/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.indexer;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.crawl.Inlinks;
import org.apache.nutch.indexer.IndexingException;
import org.apache.nutch.indexer.IndexingFilter;
import org.apache.nutch.indexer.NutchDocument;
import org.apache.nutch.parse.Parse;
import org.apache.nutch.plugin.PluginRepository;

public class IndexingFilters {
    public static final String INDEXINGFILTER_ORDER = "indexingfilter.order";
    private IndexingFilter[] indexingFilters;

    public IndexingFilters(Configuration conf) {
        this.indexingFilters = (IndexingFilter[])PluginRepository.get(conf).getOrderedPlugins(IndexingFilter.class, IndexingFilter.X_POINT_ID, INDEXINGFILTER_ORDER);
    }

    public NutchDocument filter(NutchDocument doc, Parse parse, Text url, CrawlDatum datum, Inlinks inlinks) throws IndexingException {
        for (int i = 0; i < this.indexingFilters.length; ++i) {
            if ((doc = this.indexingFilters[i].filter(doc, parse, url, datum, inlinks)) != null) continue;
            return null;
        }
        return doc;
    }
}

